/*
 * Decompiled with CFR 0.152.
 */
package io.holixon.avro.adapter.common.registry;

import io.holixon.avro.adapter.api.AvroSchemaInfo;
import io.holixon.avro.adapter.api.AvroSchemaReadOnlyRegistry;
import io.holixon.avro.adapter.api.AvroSchemaRegistry;
import io.holixon.avro.adapter.api.AvroSchemaWithId;
import io.holixon.avro.adapter.common.registry.CompositeAvroSchemaReadOnlyRegistry;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B#\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0005\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0006B\u001d\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\u0002\u0010\bB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0007H\u0096\u0001J\u001f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0096\u0001J\u001b\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\n\u0010\u0014\u001a\u00060\u0010j\u0002`\u0015H\u0096\u0001J\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0096\u0001J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/holixon/avro/adapter/common/registry/CompositeAvroSchemaRegistry;", "Lio/holixon/avro/adapter/api/AvroSchemaReadOnlyRegistry;", "Lio/holixon/avro/adapter/api/AvroSchemaRegistry;", "registry", "readOnlyRegistries", "", "(Lio/holixon/avro/adapter/api/AvroSchemaRegistry;[Lio/holixon/avro/adapter/api/AvroSchemaReadOnlyRegistry;)V", "", "(Lio/holixon/avro/adapter/api/AvroSchemaRegistry;Ljava/util/List;)V", "compositeAvroSchemaReadOnlyRegistry", "Lio/holixon/avro/adapter/common/registry/CompositeAvroSchemaReadOnlyRegistry;", "(Lio/holixon/avro/adapter/api/AvroSchemaRegistry;Lio/holixon/avro/adapter/common/registry/CompositeAvroSchemaReadOnlyRegistry;)V", "findAll", "Lio/holixon/avro/adapter/api/AvroSchemaWithId;", "findAllByCanonicalName", "namespace", "", "name", "findById", "Ljava/util/Optional;", "schemaId", "Lio/holixon/avro/adapter/api/AvroSchemaId;", "findByInfo", "info", "Lio/holixon/avro/adapter/api/AvroSchemaInfo;", "register", "schema", "Lorg/apache/avro/Schema;", "avro-registry-adapter-default"})
public final class CompositeAvroSchemaRegistry
implements AvroSchemaReadOnlyRegistry,
AvroSchemaRegistry {
    @NotNull
    private final AvroSchemaRegistry registry;
    @NotNull
    private final CompositeAvroSchemaReadOnlyRegistry compositeAvroSchemaReadOnlyRegistry;

    public CompositeAvroSchemaRegistry(@NotNull AvroSchemaRegistry registry, @NotNull CompositeAvroSchemaReadOnlyRegistry compositeAvroSchemaReadOnlyRegistry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)compositeAvroSchemaReadOnlyRegistry, (String)"compositeAvroSchemaReadOnlyRegistry");
        this.registry = registry;
        this.compositeAvroSchemaReadOnlyRegistry = compositeAvroSchemaReadOnlyRegistry;
    }

    @NotNull
    public List<AvroSchemaWithId> findAll() {
        return this.compositeAvroSchemaReadOnlyRegistry.findAll();
    }

    @NotNull
    public List<AvroSchemaWithId> findAllByCanonicalName(@NotNull String namespace, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.compositeAvroSchemaReadOnlyRegistry.findAllByCanonicalName(namespace, name);
    }

    @NotNull
    public Optional<AvroSchemaWithId> findById(@NotNull String schemaId) {
        Intrinsics.checkNotNullParameter((Object)schemaId, (String)"schemaId");
        return this.compositeAvroSchemaReadOnlyRegistry.findById(schemaId);
    }

    @NotNull
    public Optional<AvroSchemaWithId> findByInfo(@NotNull AvroSchemaInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        return this.compositeAvroSchemaReadOnlyRegistry.findByInfo(info);
    }

    public CompositeAvroSchemaRegistry(@NotNull AvroSchemaRegistry registry, AvroSchemaReadOnlyRegistry ... readOnlyRegistries) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)readOnlyRegistries, (String)"readOnlyRegistries");
        this(registry, ArraysKt.toList((Object[])readOnlyRegistries));
    }

    public CompositeAvroSchemaRegistry(@NotNull AvroSchemaRegistry registry, @NotNull List<? extends AvroSchemaReadOnlyRegistry> readOnlyRegistries) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter(readOnlyRegistries, (String)"readOnlyRegistries");
        this(registry, new CompositeAvroSchemaReadOnlyRegistry(readOnlyRegistries));
    }

    @NotNull
    public AvroSchemaWithId register(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return this.registry.register(schema);
    }
}

