/*
 * Decompiled with CFR 0.152.
 */
package io.holixon.avro.adapter.common.converter;

import io.holixon.avro.adapter.api.AvroPayloadAndSchemaId;
import io.holixon.avro.adapter.api.AvroSchemaResolver;
import io.holixon.avro.adapter.api.AvroSchemaWithId;
import io.holixon.avro.adapter.api.JsonStringAndSchemaId;
import io.holixon.avro.adapter.api.converter.SingleObjectToJsonConverter;
import io.holixon.avro.adapter.api.type.JsonStringAndSchemaIdData;
import io.holixon.avro.adapter.common.AvroAdapterDefault;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u001c\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/holixon/avro/adapter/common/converter/DefaultSingleObjectToJsonConverter;", "Lio/holixon/avro/adapter/api/converter/SingleObjectToJsonConverter;", "schemaResolver", "Lio/holixon/avro/adapter/api/AvroSchemaResolver;", "(Lio/holixon/avro/adapter/api/AvroSchemaResolver;)V", "convert", "Lio/holixon/avro/adapter/api/JsonStringAndSchemaId;", "bytes", "", "Lio/holixon/avro/adapter/api/AvroSingleObjectEncoded;", "readGenericDatum", "", "schema", "Lorg/apache/avro/Schema;", "avroBinary", "writeToJson", "", "Lio/holixon/avro/adapter/api/JsonString;", "genericDatum", "avro-registry-adapter-default"})
@SourceDebugExtension(value={"SMAP\nDefaultSingleObjectToJsonConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultSingleObjectToJsonConverter.kt\nio/holixon/avro/adapter/common/converter/DefaultSingleObjectToJsonConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,48:1\n1#2:49\n*E\n"})
public class DefaultSingleObjectToJsonConverter
implements SingleObjectToJsonConverter {
    @NotNull
    private final AvroSchemaResolver schemaResolver;

    public DefaultSingleObjectToJsonConverter(@NotNull AvroSchemaResolver schemaResolver) {
        Intrinsics.checkNotNullParameter((Object)schemaResolver, (String)"schemaResolver");
        this.schemaResolver = schemaResolver;
    }

    @NotNull
    public JsonStringAndSchemaId convert(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        AvroPayloadAndSchemaId it = AvroAdapterDefault.INSTANCE.readPayloadAndSchemaId(bytes);
        boolean bl = false;
        Pair pair = TuplesKt.to((Object)it.getSchemaId(), (Object)it.getPayload());
        String schemaId = (String)pair.component1();
        byte[] payload = (byte[])pair.component2();
        Schema writerSchema = ((AvroSchemaWithId)((Optional)this.schemaResolver.apply((Object)schemaId)).orElseThrow()).getSchema();
        Object genericDatum = this.readGenericDatum(writerSchema, payload);
        return (JsonStringAndSchemaId)new JsonStringAndSchemaIdData(schemaId, this.writeToJson(writerSchema, genericDatum));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String writeToJson(Schema schema, Object genericDatum) {
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream it = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            DatumWriter writer = (DatumWriter)new GenericDatumWriter(schema);
            JsonEncoder jsonEncoder = EncoderFactory.get().jsonEncoder(schema, (OutputStream)it, false);
            Intrinsics.checkNotNullExpressionValue((Object)jsonEncoder, (String)"jsonEncoder(...)");
            JsonEncoder encoder = jsonEncoder;
            writer.write(genericDatum, (Encoder)encoder);
            encoder.flush();
            it.flush();
            byte[] byArray = it.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            byte[] byArray2 = byArray;
            Charset charset = Charsets.UTF_8;
            String string = new String(byArray2, charset);
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final Object readGenericDatum(Schema schema, byte[] avroBinary) {
        DatumReader datumReader = (DatumReader)new GenericDatumReader(schema);
        BinaryDecoder binaryDecoder = DecoderFactory.get().binaryDecoder(avroBinary, null);
        Intrinsics.checkNotNullExpressionValue((Object)binaryDecoder, (String)"binaryDecoder(...)");
        Decoder decoder = (Decoder)binaryDecoder;
        Object object = datumReader.read(null, decoder);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"read(...)");
        return object;
    }
}

