/*
 * Decompiled with CFR 0.152.
 */
package io.holixon.avro.adapter.common.registry;

import io.holixon.avro.adapter.api.AvroAdapterApi;
import io.holixon.avro.adapter.api.AvroSchemaInfo;
import io.holixon.avro.adapter.api.AvroSchemaRegistry;
import io.holixon.avro.adapter.api.AvroSchemaWithId;
import io.holixon.avro.adapter.api.SchemaIdSupplier;
import io.holixon.avro.adapter.api.SchemaRevisionResolver;
import io.holixon.avro.adapter.api.type.AvroSchemaInfoData;
import io.holixon.avro.adapter.common.registry.InMemoryAvroSchemaReadOnlyRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B5\u0012\u001e\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\t\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rH\u0016J\u0006\u0010\u0016\u001a\u00020\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lio/holixon/avro/adapter/common/registry/InMemoryAvroSchemaRegistry;", "Lio/holixon/avro/adapter/common/registry/InMemoryAvroSchemaReadOnlyRegistry;", "Lio/holixon/avro/adapter/api/AvroSchemaRegistry;", "schemaIdSupplier", "Lio/holixon/avro/adapter/api/SchemaIdSupplier;", "schemaRevisionResolver", "Lio/holixon/avro/adapter/api/SchemaRevisionResolver;", "(Lio/holixon/avro/adapter/api/SchemaIdSupplier;Lio/holixon/avro/adapter/api/SchemaRevisionResolver;)V", "store", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lkotlin/Pair;", "Lio/holixon/avro/adapter/api/AvroSchemaInfo;", "Lorg/apache/avro/Schema;", "(Ljava/util/concurrent/ConcurrentHashMap;Lio/holixon/avro/adapter/api/SchemaIdSupplier;Lio/holixon/avro/adapter/api/SchemaRevisionResolver;)V", "getSchemaIdSupplier", "()Lio/holixon/avro/adapter/api/SchemaIdSupplier;", "getSchemaRevisionResolver", "()Lio/holixon/avro/adapter/api/SchemaRevisionResolver;", "register", "Lio/holixon/avro/adapter/api/AvroSchemaWithId;", "schema", "toReadOnly", "avro-registry-adapter-default"})
public class InMemoryAvroSchemaRegistry
extends InMemoryAvroSchemaReadOnlyRegistry
implements AvroSchemaRegistry {
    @NotNull
    private final SchemaIdSupplier schemaIdSupplier;
    @NotNull
    private final SchemaRevisionResolver schemaRevisionResolver;

    public InMemoryAvroSchemaRegistry(@NotNull ConcurrentHashMap<String, Pair<AvroSchemaInfo, Schema>> store, @NotNull SchemaIdSupplier schemaIdSupplier, @NotNull SchemaRevisionResolver schemaRevisionResolver) {
        Intrinsics.checkNotNullParameter(store, (String)"store");
        Intrinsics.checkNotNullParameter((Object)schemaIdSupplier, (String)"schemaIdSupplier");
        Intrinsics.checkNotNullParameter((Object)schemaRevisionResolver, (String)"schemaRevisionResolver");
        super(store);
        this.schemaIdSupplier = schemaIdSupplier;
        this.schemaRevisionResolver = schemaRevisionResolver;
    }

    @NotNull
    public final SchemaIdSupplier getSchemaIdSupplier() {
        return this.schemaIdSupplier;
    }

    @NotNull
    public final SchemaRevisionResolver getSchemaRevisionResolver() {
        return this.schemaRevisionResolver;
    }

    public InMemoryAvroSchemaRegistry(@NotNull SchemaIdSupplier schemaIdSupplier, @NotNull SchemaRevisionResolver schemaRevisionResolver) {
        Intrinsics.checkNotNullParameter((Object)schemaIdSupplier, (String)"schemaIdSupplier");
        Intrinsics.checkNotNullParameter((Object)schemaRevisionResolver, (String)"schemaRevisionResolver");
        this(new ConcurrentHashMap<String, Pair<AvroSchemaInfo, Schema>>(), schemaIdSupplier, schemaRevisionResolver);
    }

    @NotNull
    public AvroSchemaWithId register(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        AvroSchemaInfoData info = AvroAdapterApi.extractSchemaInfo((Schema)schema, (SchemaRevisionResolver)this.schemaRevisionResolver);
        AvroSchemaWithId avroSchemaWithId = this.findByInfo((AvroSchemaInfo)info).orElseGet(() -> InMemoryAvroSchemaRegistry.register$lambda$0(this, schema, info));
        Intrinsics.checkNotNullExpressionValue((Object)avroSchemaWithId, (String)"orElseGet(...)");
        return avroSchemaWithId;
    }

    @NotNull
    public final InMemoryAvroSchemaReadOnlyRegistry toReadOnly() {
        return new InMemoryAvroSchemaReadOnlyRegistry(this.getStore());
    }

    private static final AvroSchemaWithId register$lambda$0(InMemoryAvroSchemaRegistry this$0, Schema $schema, AvroSchemaInfoData $info) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$schema, (String)"$schema");
        Intrinsics.checkNotNullParameter((Object)$info, (String)"$info");
        Object object = this$0.schemaIdSupplier.apply((Object)$schema);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"apply(...)");
        String id = (String)object;
        ((Map)this$0.getStore()).put(id, TuplesKt.to((Object)$info, (Object)$schema));
        return this$0.findById(id).get();
    }
}

