/*
 * Decompiled with CFR 0.152.
 */
package io.holixon.axon.gateway.query;

import io.holixon.axon.gateway.query.QueryResponseMessageResponseType;
import io.holixon.axon.gateway.query.RevisionAwareQueryGateway;
import io.holixon.axon.gateway.query.RevisionQueryParameters;
import io.holixon.axon.gateway.query.RevisionValue;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.axonframework.common.Registration;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.responsetypes.ResponseType;
import org.axonframework.queryhandling.DefaultQueryGateway;
import org.axonframework.queryhandling.GenericSubscriptionQueryMessage;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryResult;
import org.axonframework.queryhandling.SubscriptionQueryUpdateMessage;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.SignalType;
import reactor.util.concurrent.Queues;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0001$B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J7\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\r\"\u0004\b\u0001\u0010\u000e\"\u0014\b\u0002\u0010\f*\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000e0\n2\u0006\u0010\u000f\u001a\u0002H\fH\u0002\u00a2\u0006\u0002\u0010\u0010JE\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0011\"\b\b\u0000\u0010\u000e*\u00020\u0012\"\b\b\u0001\u0010\r*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u0002H\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017Jv\u0010\u0018\u001a8\u00124\u00122\u0012\f\u0012\n \u001b*\u0004\u0018\u0001H\u000eH\u000e\u0012\u0004\u0012\u00020\u001c \u001b*\u0018\u0012\f\u0012\n \u001b*\u0004\u0018\u0001H\u000eH\u000e\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001a0\u001a0\u0019\"\b\b\u0000\u0010\u000e*\u00020\u00122\u001e\u0010\u001d\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000e0\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000e0 0\u001e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0016H\u0002J\"\u0010!\u001a\u00020\"2\u0018\u0010#\u001a\u0014\u0012\u0010\b\u0000\u0012\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\n0\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0007\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\b\u0000\u0012\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lio/holixon/axon/gateway/query/RevisionAwareQueryGateway;", "Lorg/axonframework/queryhandling/DefaultQueryGateway;", "queryBus", "Lorg/axonframework/queryhandling/QueryBus;", "defaultTimeout", "", "(Lorg/axonframework/queryhandling/QueryBus;J)V", "dispatchInterceptors", "", "Lorg/axonframework/messaging/MessageDispatchInterceptor;", "Lorg/axonframework/queryhandling/QueryMessage;", "processInterceptors", "T", "Q", "R", "query", "(Lorg/axonframework/queryhandling/QueryMessage;)Lorg/axonframework/queryhandling/QueryMessage;", "Ljava/util/concurrent/CompletableFuture;", "", "queryName", "", "responseType", "Lorg/axonframework/messaging/responsetypes/ResponseType;", "(Ljava/lang/String;Ljava/lang/Object;Lorg/axonframework/messaging/responsetypes/ResponseType;)Ljava/util/concurrent/CompletableFuture;", "queryResultPayloadWithMetadata", "Lreactor/core/publisher/Flux;", "Lkotlin/Pair;", "kotlin.jvm.PlatformType", "Lio/holixon/axon/gateway/query/RevisionValue;", "queryResult", "Lorg/axonframework/queryhandling/SubscriptionQueryResult;", "Lorg/axonframework/queryhandling/QueryResponseMessage;", "Lorg/axonframework/queryhandling/SubscriptionQueryUpdateMessage;", "registerDispatchInterceptor", "Lorg/axonframework/common/Registration;", "interceptor", "Companion", "axon-gateway-extension"})
public final class RevisionAwareQueryGateway
extends DefaultQueryGateway {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final QueryBus queryBus;
    private final long defaultTimeout;
    @NotNull
    private final List<MessageDispatchInterceptor<? super QueryMessage<?, ?>>> dispatchInterceptors;
    private static final Logger logger = LoggerFactory.getLogger(RevisionAwareQueryGateway.class);

    public RevisionAwareQueryGateway(@NotNull QueryBus queryBus, long defaultTimeout) {
        Intrinsics.checkNotNullParameter((Object)queryBus, (String)"queryBus");
        super(DefaultQueryGateway.builder().queryBus(queryBus));
        this.queryBus = queryBus;
        this.defaultTimeout = defaultTimeout;
        this.dispatchInterceptors = new CopyOnWriteArrayList();
    }

    @NotNull
    public <R, Q> CompletableFuture<R> query(@NotNull String queryName, @NotNull Q query2, @NotNull ResponseType<R> responseType) {
        CompletableFuture completableFuture;
        Intrinsics.checkNotNullParameter((Object)queryName, (String)"queryName");
        Intrinsics.checkNotNullParameter(query2, (String)"query");
        Intrinsics.checkNotNullParameter(responseType, (String)"responseType");
        Message message = GenericMessage.asMessage(query2);
        Intrinsics.checkNotNull((Object)message, (String)"null cannot be cast to non-null type org.axonframework.messaging.Message<Q of io.holixon.axon.gateway.query.RevisionAwareQueryGateway.query>");
        Message queryMessage = message;
        MetaData metaData = queryMessage.getMetaData();
        Intrinsics.checkNotNullExpressionValue((Object)metaData, (String)"getMetaData(...)");
        RevisionQueryParameters revisionQueryParameter = RevisionQueryParameters.Companion.fromMetaData(metaData);
        if (Intrinsics.areEqual((Object)revisionQueryParameter, (Object)RevisionQueryParameters.Companion.getNOT_PRESENT())) {
            CompletableFuture completableFuture2 = super.query(queryName, query2, responseType);
            Intrinsics.checkNotNull((Object)completableFuture2);
            completableFuture = completableFuture2;
        } else {
            CompletableFuture result = new CompletableFuture();
            logger.debug("REVISION-QUERY-GATEWAY-002: Revision-aware query " + queryName + " detected, revision: " + revisionQueryParameter);
            long queryTimeout = revisionQueryParameter.getTimeoutOrDefault(this.defaultTimeout);
            SubscriptionQueryMessage subscriptionQueryMessage = (SubscriptionQueryMessage)new GenericSubscriptionQueryMessage(queryMessage, queryName, responseType, responseType);
            SubscriptionQueryResult subscriptionQueryResult = this.queryBus.subscriptionQuery((SubscriptionQueryMessage)this.processInterceptors((QueryMessage)subscriptionQueryMessage), Queues.SMALL_BUFFER_SIZE);
            Intrinsics.checkNotNullExpressionValue((Object)subscriptionQueryResult, (String)"subscriptionQuery(...)");
            this.queryResultPayloadWithMetadata(subscriptionQueryResult, responseType).doOnNext(arg_0 -> RevisionAwareQueryGateway.query$lambda$0(query.1.INSTANCE, arg_0)).filter(arg_0 -> RevisionAwareQueryGateway.query$lambda$1((Function1)new Function1<Pair<? extends R, ? extends RevisionValue>, Boolean>(revisionQueryParameter){
                final /* synthetic */ RevisionQueryParameters $revisionQueryParameter;
                {
                    this.$revisionQueryParameter = $revisionQueryParameter;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(Pair<? extends R, RevisionValue> pair) {
                    return ((RevisionValue)pair.getSecond()).getRevision() >= this.$revisionQueryParameter.getMinimalRevision();
                }
            }, arg_0)).map(arg_0 -> RevisionAwareQueryGateway.query$lambda$2((Function1)new Function1<Pair<? extends R, ? extends RevisionValue>, R>(queryName, revisionQueryParameter){
                final /* synthetic */ String $queryName;
                final /* synthetic */ RevisionQueryParameters $revisionQueryParameter;
                {
                    this.$queryName = $queryName;
                    this.$revisionQueryParameter = $revisionQueryParameter;
                    super(1);
                }

                public final R invoke(Pair<? extends R, RevisionValue> pair) {
                    RevisionAwareQueryGateway.access$getLogger$cp().debug("REVISION-QUERY-GATEWAY-004: Responded " + this.$queryName + " having " + this.$revisionQueryParameter + " with revision " + pair.getSecond());
                    return (R)pair.getFirst();
                }
            }, arg_0)).take(1L).timeout(Duration.of(queryTimeout, ChronoUnit.SECONDS)).subscribe(arg_0 -> RevisionAwareQueryGateway.query$lambda$3((Function1)new Function1<R, Unit>(result){
                final /* synthetic */ CompletableFuture<R> $result;
                {
                    this.$result = $result;
                    super(1);
                }

                public final void invoke(R projectionResult) {
                    this.$result.complete(projectionResult);
                }
            }, arg_0), arg_0 -> RevisionAwareQueryGateway.query$lambda$4((Function1)new Function1<Throwable, Unit>(result){
                final /* synthetic */ CompletableFuture<R> $result;
                {
                    this.$result = $result;
                    super(1);
                }

                public final void invoke(Throwable exception) {
                    this.$result.completeExceptionally(exception);
                }
            }, arg_0));
            completableFuture = result;
        }
        return completableFuture;
    }

    private final <R> Flux<Pair<R, RevisionValue>> queryResultPayloadWithMetadata(SubscriptionQueryResult<QueryResponseMessage<R>, SubscriptionQueryUpdateMessage<R>> queryResult, ResponseType<R> responseType) {
        Flux flux;
        if (responseType instanceof QueryResponseMessageResponseType) {
            var4_3 = new Publisher[]{queryResult.initialResult().delayElement(Duration.ofNanos(1L)).filter(arg_0 -> RevisionAwareQueryGateway.queryResultPayloadWithMetadata$lambda$5(queryResultPayloadWithMetadata.1.INSTANCE, arg_0)).map(arg_0 -> RevisionAwareQueryGateway.queryResultPayloadWithMetadata$lambda$6(queryResultPayloadWithMetadata.2.INSTANCE, arg_0)).onErrorMap(arg_0 -> RevisionAwareQueryGateway.queryResultPayloadWithMetadata$lambda$7(queryResultPayloadWithMetadata.3.INSTANCE, arg_0)), queryResult.updates().filter(arg_0 -> RevisionAwareQueryGateway.queryResultPayloadWithMetadata$lambda$8(queryResultPayloadWithMetadata.4.INSTANCE, arg_0)).map(arg_0 -> RevisionAwareQueryGateway.queryResultPayloadWithMetadata$lambda$9(queryResultPayloadWithMetadata.5.INSTANCE, arg_0)).onErrorMap(arg_0 -> RevisionAwareQueryGateway.queryResultPayloadWithMetadata$lambda$10(queryResultPayloadWithMetadata.6.INSTANCE, arg_0))};
            flux = Flux.mergeSequential((Publisher[])var4_3).doFinally(arg_0 -> RevisionAwareQueryGateway.queryResultPayloadWithMetadata$lambda$11(queryResult, arg_0));
        } else {
            var4_3 = new Publisher[]{queryResult.initialResult().delayElement(Duration.ofNanos(1L)).filter(arg_0 -> RevisionAwareQueryGateway.queryResultPayloadWithMetadata$lambda$12(queryResultPayloadWithMetadata.8.INSTANCE, arg_0)).map(arg_0 -> RevisionAwareQueryGateway.queryResultPayloadWithMetadata$lambda$13(queryResultPayloadWithMetadata.9.INSTANCE, arg_0)).onErrorMap(arg_0 -> RevisionAwareQueryGateway.queryResultPayloadWithMetadata$lambda$14(queryResultPayloadWithMetadata.10.INSTANCE, arg_0)), queryResult.updates().filter(arg_0 -> RevisionAwareQueryGateway.queryResultPayloadWithMetadata$lambda$15(queryResultPayloadWithMetadata.11.INSTANCE, arg_0)).map(arg_0 -> RevisionAwareQueryGateway.queryResultPayloadWithMetadata$lambda$16(queryResultPayloadWithMetadata.12.INSTANCE, arg_0)).onErrorMap(arg_0 -> RevisionAwareQueryGateway.queryResultPayloadWithMetadata$lambda$17(queryResultPayloadWithMetadata.13.INSTANCE, arg_0))};
            flux = Flux.mergeSequential((Publisher[])var4_3).filter(arg_0 -> RevisionAwareQueryGateway.queryResultPayloadWithMetadata$lambda$18(queryResultPayloadWithMetadata.14.INSTANCE, arg_0)).map(arg_0 -> RevisionAwareQueryGateway.queryResultPayloadWithMetadata$lambda$19(queryResultPayloadWithMetadata.15.INSTANCE, arg_0)).doFinally(arg_0 -> RevisionAwareQueryGateway.queryResultPayloadWithMetadata$lambda$20(queryResult, arg_0));
        }
        Flux flux2 = flux;
        Intrinsics.checkNotNull((Object)flux2);
        return flux2;
    }

    @NotNull
    public Registration registerDispatchInterceptor(@NotNull MessageDispatchInterceptor<? super QueryMessage<?, ?>> interceptor) {
        Intrinsics.checkNotNullParameter(interceptor, (String)"interceptor");
        this.dispatchInterceptors.add(interceptor);
        return () -> RevisionAwareQueryGateway.registerDispatchInterceptor$lambda$21(this, interceptor);
    }

    private final <Q, R, T extends QueryMessage<Q, R>> T processInterceptors(T query2) {
        Object intercepted = query2;
        for (MessageDispatchInterceptor<? super QueryMessage<?, ?>> messageDispatchInterceptor : this.dispatchInterceptors) {
            Message message = messageDispatchInterceptor.handle((Message)intercepted);
            Intrinsics.checkNotNull((Object)message, (String)"null cannot be cast to non-null type T of io.holixon.axon.gateway.query.RevisionAwareQueryGateway.processInterceptors");
            intercepted = (QueryMessage)message;
        }
        return intercepted;
    }

    private static final void query$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean query$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Object query$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke(p0);
    }

    private static final void query$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void query$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean queryResultPayloadWithMetadata$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Pair queryResultPayloadWithMetadata$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Pair)$tmp0.invoke(p0);
    }

    private static final Throwable queryResultPayloadWithMetadata$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Throwable)$tmp0.invoke(p0);
    }

    private static final boolean queryResultPayloadWithMetadata$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Pair queryResultPayloadWithMetadata$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Pair)$tmp0.invoke(p0);
    }

    private static final Throwable queryResultPayloadWithMetadata$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Throwable)$tmp0.invoke(p0);
    }

    private static final void queryResultPayloadWithMetadata$lambda$11(SubscriptionQueryResult $queryResult, SignalType it) {
        Intrinsics.checkNotNullParameter((Object)$queryResult, (String)"$queryResult");
        $queryResult.cancel();
    }

    private static final boolean queryResultPayloadWithMetadata$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Object queryResultPayloadWithMetadata$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke(p0);
    }

    private static final Throwable queryResultPayloadWithMetadata$lambda$14(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Throwable)$tmp0.invoke(p0);
    }

    private static final boolean queryResultPayloadWithMetadata$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Object queryResultPayloadWithMetadata$lambda$16(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke(p0);
    }

    private static final Throwable queryResultPayloadWithMetadata$lambda$17(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Throwable)$tmp0.invoke(p0);
    }

    private static final boolean queryResultPayloadWithMetadata$lambda$18(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Pair queryResultPayloadWithMetadata$lambda$19(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Pair)$tmp0.invoke(p0);
    }

    private static final void queryResultPayloadWithMetadata$lambda$20(SubscriptionQueryResult $queryResult, SignalType it) {
        Intrinsics.checkNotNullParameter((Object)$queryResult, (String)"$queryResult");
        $queryResult.cancel();
    }

    private static final boolean registerDispatchInterceptor$lambda$21(RevisionAwareQueryGateway this$0, MessageDispatchInterceptor $interceptor) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$interceptor, (String)"$interceptor");
        return this$0.dispatchInterceptors.remove($interceptor);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u00a8\u0006\u0007"}, d2={"Lio/holixon/axon/gateway/query/RevisionAwareQueryGateway$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger$annotations", "axon-gateway-extension"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLogger$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

