/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.camunda.platform.login;

import io.holunda.camunda.platform.login.CamundaLoginAutoConfiguration;
import io.holunda.camunda.platform.login.CamundaLoginProperties;
import io.holunda.camunda.platform.login.ExtendedContainerBasedAuthenticationFilter;
import io.holunda.camunda.platform.login.SessionBasedAuthenticationProvider;
import java.util.EnumSet;
import javax.annotation.PostConstruct;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.spring.boot.starter.util.SpringBootProcessEnginePlugin;
import org.camunda.bpm.webapp.impl.security.auth.ContainerBasedAuthenticationFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={CamundaLoginProperties.class})
@ConditionalOnProperty(value={"camunda.bpm.login.enabled"}, havingValue="true", matchIfMissing=false)
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\r"}, d2={"Lio/holunda/camunda/platform/login/CamundaLoginAutoConfiguration;", "", "()V", "containerBasedAuthenticationFilterRegistrationBean", "Lorg/springframework/boot/web/servlet/FilterRegistrationBean;", "Lorg/camunda/bpm/webapp/impl/security/auth/ContainerBasedAuthenticationFilter;", "camundaLoginProperties", "Lio/holunda/camunda/platform/login/CamundaLoginProperties;", "createMissingUserForAutoLoginPlugin", "Lorg/camunda/bpm/spring/boot/starter/util/SpringBootProcessEnginePlugin;", "reportActivation", "", "Companion", "camunda-platform-7-autologin"})
public final class CamundaLoginAutoConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @PostConstruct
    public final void reportActivation() {
        Companion.getLogger().warn((Function0)reportActivation.1.INSTANCE);
    }

    @Bean
    @NotNull
    public final FilterRegistrationBean<ContainerBasedAuthenticationFilter> containerBasedAuthenticationFilterRegistrationBean(@NotNull CamundaLoginProperties camundaLoginProperties) {
        FilterRegistrationBean filterRegistrationBean;
        Intrinsics.checkNotNullParameter((Object)camundaLoginProperties, (String)"camundaLoginProperties");
        FilterRegistrationBean $this$containerBasedAuthenticationFilterRegistrationBean_u24lambda_u2d0 = filterRegistrationBean = new FilterRegistrationBean();
        boolean bl = false;
        $this$containerBasedAuthenticationFilterRegistrationBean_u24lambda_u2d0.setFilter((Filter)new ExtendedContainerBasedAuthenticationFilter(new SessionBasedAuthenticationProvider(camundaLoginProperties.getUserId())));
        $this$containerBasedAuthenticationFilterRegistrationBean_u24lambda_u2d0.setInitParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)"authentication-provider", (Object)SessionBasedAuthenticationProvider.Companion.getFQN())));
        String[] stringArray = new String[]{camundaLoginProperties.getCamundaContextPath() + "/app/*", camundaLoginProperties.getCamundaContextPath() + "/api/*"};
        $this$containerBasedAuthenticationFilterRegistrationBean_u24lambda_u2d0.addUrlPatterns(stringArray);
        $this$containerBasedAuthenticationFilterRegistrationBean_u24lambda_u2d0.setDispatcherTypes(EnumSet.of((Enum)DispatcherType.REQUEST));
        return filterRegistrationBean;
    }

    @Bean
    @NotNull
    public final SpringBootProcessEnginePlugin createMissingUserForAutoLoginPlugin(@NotNull CamundaLoginProperties camundaLoginProperties) {
        Intrinsics.checkNotNullParameter((Object)camundaLoginProperties, (String)"camundaLoginProperties");
        return new SpringBootProcessEnginePlugin(camundaLoginProperties){
            final /* synthetic */ CamundaLoginProperties $camundaLoginProperties;
            {
                this.$camundaLoginProperties = $camundaLoginProperties;
            }

            public void postProcessEngineBuild(@NotNull ProcessEngine processEngine) {
                Intrinsics.checkNotNullParameter((Object)processEngine, (String)"processEngine");
                if (this.$camundaLoginProperties.getCreateIfAbsent() && processEngine.getIdentityService().createUserQuery().userId(this.$camundaLoginProperties.getUserId()).count() == 0L) {
                    processEngine.getIdentityService().saveUser((User)this.$camundaLoginProperties.extractUser());
                    CamundaLoginAutoConfiguration.Companion.getLogger().info((Function0)new Function0<Object>(this.$camundaLoginProperties){
                        final /* synthetic */ CamundaLoginProperties $camundaLoginProperties;
                        {
                            this.$camundaLoginProperties = $camundaLoginProperties;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "Created the auto-login user '" + this.$camundaLoginProperties.extractUser().getId() + "'.";
                        }
                    });
                }
            }
        };
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/holunda/camunda/platform/login/CamundaLoginAutoConfiguration$Companion;", "Lmu/KLogging;", "()V", "camunda-platform-7-autologin"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

