/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.camunda.bpm.data.adapter.basic;

import io.holunda.camunda.bpm.data.adapter.basic.AbstractBasicReadWriteAdapter;
import java.util.Optional;
import org.camunda.bpm.engine.RuntimeService;

public class ReadWriteAdapterRuntimeService<T>
extends AbstractBasicReadWriteAdapter<T> {
    private final RuntimeService runtimeService;
    private final String executionId;

    public ReadWriteAdapterRuntimeService(RuntimeService runtimeService, String executionId, String variableName, Class<T> clazz) {
        super(variableName, clazz);
        this.runtimeService = runtimeService;
        this.executionId = executionId;
    }

    @Override
    public Optional<T> getOptional() {
        return Optional.ofNullable(this.getOrNull(this.runtimeService.getVariable(this.executionId, this.variableName)));
    }

    @Override
    public void set(T value, boolean isTransient) {
        this.runtimeService.setVariable(this.executionId, this.variableName, (Object)this.getTypedValue(value, isTransient));
    }

    @Override
    public Optional<T> getLocalOptional() {
        return Optional.ofNullable(this.getOrNull(this.runtimeService.getVariableLocal(this.executionId, this.variableName)));
    }

    @Override
    public void setLocal(T value, boolean isTransient) {
        this.runtimeService.setVariableLocal(this.executionId, this.variableName, (Object)this.getTypedValue(value, isTransient));
    }

    @Override
    public void remove() {
        this.runtimeService.removeVariable(this.executionId, this.variableName);
    }

    @Override
    public void removeLocal() {
        this.runtimeService.removeVariableLocal(this.executionId, this.variableName);
    }
}

