/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.camunda.bpm.data.adapter.list;

import io.holunda.camunda.bpm.data.adapter.ReadAdapter;
import io.holunda.camunda.bpm.data.adapter.WrongVariableTypeException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;

public class ListReadAdapterLockedExternalTask<T>
implements ReadAdapter<List<T>> {
    private final LockedExternalTask lockedExternalTask;
    private final String variableName;
    private final Class<T> memberClazz;

    public ListReadAdapterLockedExternalTask(LockedExternalTask lockedExternalTask, String variableName, Class<T> memberClazz) {
        this.lockedExternalTask = lockedExternalTask;
        this.variableName = variableName;
        this.memberClazz = memberClazz;
    }

    @Override
    public List<T> get() {
        return null;
    }

    @Override
    public Optional<List<T>> getOptional() {
        return Optional.ofNullable(this.getOrNull(this.getValue()));
    }

    @Override
    public List<T> getLocal() {
        throw new UnsupportedOperationException("Can't get a local variable on an external task");
    }

    @Override
    public Optional<List<T>> getLocalOptional() {
        throw new UnsupportedOperationException("Can't get a local variable on an external task");
    }

    @Override
    public List<T> getOrDefault(List<T> defaultValue) {
        return this.getOptional().orElse(defaultValue);
    }

    @Override
    public List<T> getLocalOrDefault(List<T> defaultValue) {
        throw new UnsupportedOperationException("Can't get a local variable on an external task");
    }

    @Override
    public List<T> getOrNull() {
        return this.getOrNull(this.getValue());
    }

    @Override
    public List<T> getLocalOrNull() {
        throw new UnsupportedOperationException("Can't get a local variable on an external task");
    }

    private List<T> getOrNull(T value) {
        if (value == null) {
            return null;
        }
        if (List.class.isAssignableFrom(value.getClass())) {
            List valueAsList = (List)value;
            if (valueAsList.isEmpty()) {
                return Collections.emptyList();
            }
            if (this.memberClazz.isAssignableFrom(valueAsList.iterator().next().getClass())) {
                return valueAsList;
            }
            throw new WrongVariableTypeException("Error reading " + this.variableName + ": Wrong list type detected, expected " + this.memberClazz.getName() + ", but was not found in " + valueAsList);
        }
        throw new WrongVariableTypeException("Error reading " + this.variableName + ": Couldn't read value of type List from " + value);
    }

    private T getValue() {
        return (T)Optional.ofNullable(this.lockedExternalTask.getVariables()).map(it -> it.get((Object)this.variableName)).get();
    }
}

