/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.camunda.bpm.data.writer;

import io.holunda.camunda.bpm.data.factory.VariableFactory;
import io.holunda.camunda.bpm.data.writer.VariableWriter;
import java.util.Objects;
import java.util.function.Function;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.variable.VariableMap;
import org.jetbrains.annotations.NotNull;

public class CaseServiceVariableWriter
implements VariableWriter<CaseServiceVariableWriter> {
    private final CaseService caseService;
    private final String caseExecutionId;

    public CaseServiceVariableWriter(CaseService caseService, String caseExecutionId) {
        this.caseService = caseService;
        this.caseExecutionId = caseExecutionId;
    }

    @Override
    @NotNull
    public VariableMap variables() {
        return this.caseService.getVariablesTyped(this.caseExecutionId);
    }

    @Override
    @NotNull
    public VariableMap variablesLocal() {
        return this.caseService.getVariablesLocalTyped(this.caseExecutionId);
    }

    @Override
    @NotNull
    public <T> CaseServiceVariableWriter set(VariableFactory<T> factory, T value) {
        return this.set((VariableFactory)factory, (Object)value, false);
    }

    @Override
    @NotNull
    public <T> CaseServiceVariableWriter set(VariableFactory<T> factory, T value, boolean isTransient) {
        factory.on(this.caseService, this.caseExecutionId).set(value, isTransient);
        return this;
    }

    @Override
    @NotNull
    public <T> CaseServiceVariableWriter setLocal(VariableFactory<T> factory, T value) {
        return this.setLocal((VariableFactory)factory, (Object)value, false);
    }

    @Override
    @NotNull
    public <T> CaseServiceVariableWriter setLocal(VariableFactory<T> factory, T value, boolean isTransient) {
        factory.on(this.caseService, this.caseExecutionId).setLocal(value, isTransient);
        return this;
    }

    @Override
    @NotNull
    public <T> CaseServiceVariableWriter updateLocal(VariableFactory<T> factory, Function<T, T> valueProcessor) {
        return this.updateLocal((VariableFactory)factory, (Function)valueProcessor, false);
    }

    @Override
    @NotNull
    public <T> CaseServiceVariableWriter updateLocal(VariableFactory<T> factory, Function<T, T> valueProcessor, boolean isTransient) {
        factory.on(this.caseService, this.caseExecutionId).updateLocal(valueProcessor, isTransient);
        return this;
    }

    @Override
    @NotNull
    public <T> CaseServiceVariableWriter remove(VariableFactory<T> factory) {
        factory.on(this.caseService, this.caseExecutionId).remove();
        return this;
    }

    @Override
    @NotNull
    public <T> CaseServiceVariableWriter removeLocal(VariableFactory<T> factory) {
        factory.on(this.caseService, this.caseExecutionId).removeLocal();
        return this;
    }

    @Override
    @NotNull
    public <T> CaseServiceVariableWriter update(VariableFactory<T> factory, Function<T, T> valueProcessor) {
        factory.on(this.caseService, this.caseExecutionId).update(valueProcessor);
        return this;
    }

    @Override
    @NotNull
    public <T> CaseServiceVariableWriter update(VariableFactory<T> factory, Function<T, T> valueProcessor, boolean isTransient) {
        factory.on(this.caseService, this.caseExecutionId).updateLocal(valueProcessor, isTransient);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CaseServiceVariableWriter that = (CaseServiceVariableWriter)o;
        if (!Objects.equals(this.caseService, that.caseService)) {
            return false;
        }
        return Objects.equals(this.caseExecutionId, that.caseExecutionId);
    }

    public int hashCode() {
        int result = this.caseService != null ? this.caseService.hashCode() : 0;
        result = 31 * result + (this.caseExecutionId != null ? this.caseExecutionId.hashCode() : 0);
        return result;
    }
}

