/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.camunda.bpm.data.builder;

import io.holunda.camunda.bpm.data.factory.VariableFactory;
import io.holunda.camunda.bpm.data.writer.VariableMapWriter;
import java.util.Collections;
import java.util.Objects;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.jetbrains.annotations.NotNull;

public class VariableMapBuilder {
    private final VariableMapWriter writer = new VariableMapWriter(Variables.createVariables());

    @NotNull
    public <T> VariableMapBuilder set(VariableFactory<T> variableFactory, T value) {
        this.writer.set((VariableFactory)variableFactory, (Object)value);
        return this;
    }

    @NotNull
    public <T> VariableMapBuilder set(VariableFactory<T> variableFactory, T value, boolean isTransient) {
        this.writer.set((VariableFactory)variableFactory, (Object)value, isTransient);
        return this;
    }

    @NotNull
    public VariableMap build() {
        return Variables.fromMap(Collections.unmodifiableMap(this.writer.variables()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariableMapBuilder that = (VariableMapBuilder)o;
        return Objects.equals(this.writer, that.writer);
    }

    public int hashCode() {
        return this.writer != null ? this.writer.hashCode() : 0;
    }
}

