/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.camunda.bpm.data.guard.integration;

import io.holunda.camunda.bpm.data.guard.GuardViolation;
import io.holunda.camunda.bpm.data.guard.VariablesGuard;
import io.holunda.camunda.bpm.data.guard.condition.VariableGuardCondition;
import io.holunda.camunda.bpm.data.guard.integration.GuardViolationException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B!\b\u0016\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0017\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0014H\u0002R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lio/holunda/camunda/bpm/data/guard/integration/DefaultGuardTaskListener;", "Lorg/camunda/bpm/engine/delegate/TaskListener;", "variableConditions", "", "Lio/holunda/camunda/bpm/data/guard/condition/VariableGuardCondition;", "throwViolations", "", "(Ljava/util/List;Z)V", "guard", "Lio/holunda/camunda/bpm/data/guard/VariablesGuard;", "(Lio/holunda/camunda/bpm/data/guard/VariablesGuard;Z)V", "getGuard", "()Lio/holunda/camunda/bpm/data/guard/VariablesGuard;", "getThrowViolations", "()Z", "notify", "", "task", "Lorg/camunda/bpm/engine/delegate/DelegateTask;", "removeNewLines", "", "Companion", "camunda-bpm-data"})
public final class DefaultGuardTaskListener
implements TaskListener {
    @NotNull
    private final VariablesGuard guard;
    private final boolean throwViolations;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    public void notify(@NotNull DelegateTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        List<GuardViolation<?>> violations = this.guard.evaluate((VariableScope)task);
        Collection collection = violations;
        boolean bl = false;
        if (!collection.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder().append("Guard violated in task '");
            String string = task.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"task.name");
            String message = stringBuilder.append(this.removeNewLines(string)).append("' (taskId: '").append(task.getId()).append("')").toString();
            Iterable $this$forEach$iv = violations;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GuardViolation it = (GuardViolation)element$iv;
                boolean bl2 = false;
                logger.error(message + ": " + it.getMessage());
            }
            if (this.throwViolations) {
                throw (Throwable)((Object)new GuardViolationException(violations, message));
            }
        }
    }

    private final String removeNewLines(String $this$removeNewLines) {
        return StringsKt.replace$default((String)$this$removeNewLines, (String)"\n", (String)" ", (boolean)false, (int)4, null);
    }

    @NotNull
    public final VariablesGuard getGuard() {
        return this.guard;
    }

    public final boolean getThrowViolations() {
        return this.throwViolations;
    }

    public DefaultGuardTaskListener(@NotNull VariablesGuard guard, boolean throwViolations) {
        Intrinsics.checkNotNullParameter((Object)guard, (String)"guard");
        this.guard = guard;
        this.throwViolations = throwViolations;
    }

    public /* synthetic */ DefaultGuardTaskListener(VariablesGuard variablesGuard, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(variablesGuard, bl);
    }

    public DefaultGuardTaskListener(@NotNull List<? extends VariableGuardCondition<?>> variableConditions, boolean throwViolations) {
        Intrinsics.checkNotNullParameter(variableConditions, (String)"variableConditions");
        this(new VariablesGuard(variableConditions), throwViolations);
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(DefaultGuardTaskListener.class);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/holunda/camunda/bpm/data/guard/integration/DefaultGuardTaskListener$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "camunda-bpm-data"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

