/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.camunda.bpm.data.writer;

import io.holunda.camunda.bpm.data.factory.VariableFactory;
import io.holunda.camunda.bpm.data.writer.GlobalVariableWriter;
import java.util.Objects;
import java.util.function.Function;
import org.camunda.bpm.engine.variable.VariableMap;
import org.jetbrains.annotations.NotNull;

public class VariableMapWriter
implements GlobalVariableWriter<VariableMapWriter> {
    private final VariableMap variables;

    public VariableMapWriter(VariableMap variables) {
        this.variables = variables;
    }

    @Override
    @NotNull
    public <T> VariableMapWriter set(VariableFactory<T> factory, T value) {
        return this.set((VariableFactory)factory, (Object)value, false);
    }

    @Override
    @NotNull
    public <T> VariableMapWriter set(VariableFactory<T> factory, T value, boolean isTransient) {
        factory.on(this.variables).set(value, isTransient);
        return this;
    }

    @Override
    @NotNull
    public <T> VariableMapWriter remove(VariableFactory<T> factory) {
        factory.on(this.variables).remove();
        return this;
    }

    @Override
    @NotNull
    public <T> VariableMapWriter update(VariableFactory<T> factory, Function<T, T> valueProcessor) {
        factory.on(this.variables).update(valueProcessor);
        return this;
    }

    @Override
    @NotNull
    public <T> VariableMapWriter update(VariableFactory<T> factory, Function<T, T> valueProcessor, boolean isTransient) {
        factory.on(this.variables).update(valueProcessor, isTransient);
        return this;
    }

    @Override
    @NotNull
    public VariableMap variables() {
        return this.variables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariableMapWriter that = (VariableMapWriter)o;
        return Objects.equals(this.variables, that.variables);
    }

    public int hashCode() {
        return this.variables != null ? this.variables.hashCode() : 0;
    }
}

