/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.camunda.bpm.data.factory;

import io.holunda.camunda.bpm.data.adapter.ReadAdapter;
import io.holunda.camunda.bpm.data.adapter.WriteAdapter;
import io.holunda.camunda.bpm.data.adapter.basic.ReadAdapterLockedExternalTask;
import io.holunda.camunda.bpm.data.adapter.basic.ReadWriteAdapterCaseService;
import io.holunda.camunda.bpm.data.adapter.basic.ReadWriteAdapterRuntimeService;
import io.holunda.camunda.bpm.data.adapter.basic.ReadWriteAdapterTaskService;
import io.holunda.camunda.bpm.data.adapter.basic.ReadWriteAdapterVariableMap;
import io.holunda.camunda.bpm.data.adapter.basic.ReadWriteAdapterVariableScope;
import io.holunda.camunda.bpm.data.factory.VariableFactory;
import java.util.Objects;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.variable.VariableMap;
import org.jetbrains.annotations.NotNull;

public class BasicVariableFactory<T>
implements VariableFactory<T> {
    @NotNull
    private final String name;
    @NotNull
    private final Class<T> clazz;

    public BasicVariableFactory(@NotNull String name, @NotNull Class<T> clazz) {
        this.name = name;
        this.clazz = clazz;
    }

    @Override
    public WriteAdapter<T> on(VariableScope variableScope) {
        return new ReadWriteAdapterVariableScope<T>(variableScope, this.name, this.clazz);
    }

    @Override
    public ReadAdapter<T> from(VariableScope variableScope) {
        return new ReadWriteAdapterVariableScope<T>(variableScope, this.name, this.clazz);
    }

    @Override
    public WriteAdapter<T> on(VariableMap variableMap) {
        return new ReadWriteAdapterVariableMap<T>(variableMap, this.name, this.clazz);
    }

    @Override
    public ReadAdapter<T> from(VariableMap variableMap) {
        return new ReadWriteAdapterVariableMap<T>(variableMap, this.name, this.clazz);
    }

    @Override
    public WriteAdapter<T> on(RuntimeService runtimeService, String executionId) {
        return new ReadWriteAdapterRuntimeService<T>(runtimeService, executionId, this.name, this.clazz);
    }

    @Override
    public ReadAdapter<T> from(RuntimeService runtimeService, String executionId) {
        return new ReadWriteAdapterRuntimeService<T>(runtimeService, executionId, this.name, this.clazz);
    }

    @Override
    public WriteAdapter<T> on(TaskService taskService, String taskId) {
        return new ReadWriteAdapterTaskService<T>(taskService, taskId, this.name, this.clazz);
    }

    @Override
    public ReadAdapter<T> from(TaskService taskService, String taskId) {
        return new ReadWriteAdapterTaskService<T>(taskService, taskId, this.name, this.clazz);
    }

    @Override
    public WriteAdapter<T> on(CaseService caseService, String caseExecutionId) {
        return new ReadWriteAdapterCaseService<T>(caseService, caseExecutionId, this.name, this.clazz);
    }

    @Override
    public ReadAdapter<T> from(CaseService caseService, String caseExecutionId) {
        return new ReadWriteAdapterCaseService<T>(caseService, caseExecutionId, this.name, this.clazz);
    }

    @Override
    public ReadAdapter<T> from(LockedExternalTask lockedExternalTask) {
        return new ReadAdapterLockedExternalTask<T>(lockedExternalTask, this.name, this.clazz);
    }

    public BasicRuntimeServiceAdapterBuilder<T> using(RuntimeService runtimeService) {
        return new BasicRuntimeServiceAdapterBuilder(this, runtimeService);
    }

    public BasicTaskServiceAdapterBuilder<T> using(TaskService taskService) {
        return new BasicTaskServiceAdapterBuilder(this, taskService);
    }

    public BasicCaseServiceAdapterBuilder<T> using(CaseService caseService) {
        return new BasicCaseServiceAdapterBuilder(this, caseService);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public Class<T> getVariableClass() {
        return this.clazz;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicVariableFactory that = (BasicVariableFactory)o;
        return this.name.equals(that.name) && this.clazz.equals(that.clazz);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.clazz);
    }

    public String toString() {
        return "BasicVariableFactory{name='" + this.name + "', clazz=" + this.clazz + "}";
    }

    public static class BasicCaseServiceAdapterBuilder<T> {
        private final CaseService caseService;
        private final BasicVariableFactory<T> basicVariableFactory;

        public BasicCaseServiceAdapterBuilder(BasicVariableFactory<T> basicVariableFactory, CaseService caseService) {
            this.caseService = caseService;
            this.basicVariableFactory = basicVariableFactory;
        }

        private ReadWriteAdapterCaseService<T> readWriteAdapter(String caseExecutionId) {
            return new ReadWriteAdapterCaseService<T>(this.caseService, caseExecutionId, this.basicVariableFactory.getName(), this.basicVariableFactory.getVariableClass());
        }

        public WriteAdapter<T> on(String caseExecutionId) {
            return this.readWriteAdapter(caseExecutionId);
        }

        public ReadAdapter<T> from(String caseExecutionId) {
            return this.readWriteAdapter(caseExecutionId);
        }
    }

    public static class BasicTaskServiceAdapterBuilder<T> {
        private final TaskService taskService;
        private final BasicVariableFactory<T> basicVariableFactory;

        public BasicTaskServiceAdapterBuilder(BasicVariableFactory<T> basicVariableFactory, TaskService taskService) {
            this.taskService = taskService;
            this.basicVariableFactory = basicVariableFactory;
        }

        private ReadWriteAdapterTaskService<T> readWriteAdapter(String taskId) {
            return new ReadWriteAdapterTaskService<T>(this.taskService, taskId, this.basicVariableFactory.getName(), this.basicVariableFactory.getVariableClass());
        }

        public WriteAdapter<T> on(String taskId) {
            return this.readWriteAdapter(taskId);
        }

        public ReadAdapter<T> from(String taskId) {
            return this.readWriteAdapter(taskId);
        }
    }

    public static class BasicRuntimeServiceAdapterBuilder<T> {
        private final RuntimeService runtimeService;
        private final BasicVariableFactory<T> basicVariableFactory;

        public BasicRuntimeServiceAdapterBuilder(BasicVariableFactory<T> basicVariableFactory, RuntimeService runtimeService) {
            this.runtimeService = runtimeService;
            this.basicVariableFactory = basicVariableFactory;
        }

        private ReadWriteAdapterRuntimeService<T> readWriteAdapter(String executionId) {
            return new ReadWriteAdapterRuntimeService<T>(this.runtimeService, executionId, this.basicVariableFactory.getName(), this.basicVariableFactory.getVariableClass());
        }

        public WriteAdapter<T> on(String executionId) {
            return this.readWriteAdapter(executionId);
        }

        public ReadAdapter<T> from(String executionId) {
            return this.readWriteAdapter(executionId);
        }
    }
}

