/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.camunda.bpm.data.reader;

import io.holunda.camunda.bpm.data.factory.VariableFactory;
import io.holunda.camunda.bpm.data.reader.VariableReader;
import java.util.Objects;
import java.util.Optional;
import org.camunda.bpm.engine.TaskService;
import org.jetbrains.annotations.NotNull;

public class TaskServiceVariableReader
implements VariableReader {
    private final TaskService taskService;
    private final String taskId;

    public TaskServiceVariableReader(TaskService taskService, String taskId) {
        this.taskService = taskService;
        this.taskId = taskId;
    }

    @Override
    @NotNull
    public <T> Optional<T> getOptional(VariableFactory<T> variableFactory) {
        return variableFactory.from(this.taskService, this.taskId).getOptional();
    }

    @Override
    @NotNull
    public <T> T get(VariableFactory<T> variableFactory) {
        return variableFactory.from(this.taskService, this.taskId).get();
    }

    @Override
    @NotNull
    public <T> T getLocal(VariableFactory<T> variableFactory) {
        return variableFactory.from(this.taskService, this.taskId).getLocal();
    }

    @Override
    @NotNull
    public <T> Optional<T> getLocalOptional(VariableFactory<T> variableFactory) {
        return variableFactory.from(this.taskService, this.taskId).getLocalOptional();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskServiceVariableReader that = (TaskServiceVariableReader)o;
        if (!Objects.equals(this.taskService, that.taskService)) {
            return false;
        }
        return Objects.equals(this.taskId, that.taskId);
    }

    public int hashCode() {
        int result = this.taskService != null ? this.taskService.hashCode() : 0;
        result = 31 * result + (this.taskId != null ? this.taskId.hashCode() : 0);
        return result;
    }
}

