/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.camunda.bpm.data.adapter.map;

import io.holunda.camunda.bpm.data.adapter.map.AbstractMapReadWriteAdapter;
import java.util.Map;
import java.util.Optional;
import org.camunda.bpm.engine.RuntimeService;

public class MapReadWriteAdapterRuntimeService<K, V>
extends AbstractMapReadWriteAdapter<K, V> {
    private final RuntimeService runtimeService;
    private final String executionId;

    public MapReadWriteAdapterRuntimeService(RuntimeService runtimeService, String executionId, String variableName, Class<K> keyClazz, Class<V> valueClazz) {
        super(variableName, keyClazz, valueClazz);
        this.runtimeService = runtimeService;
        this.executionId = executionId;
    }

    @Override
    public Optional<Map<K, V>> getOptional() {
        return Optional.ofNullable(this.getOrNull(this.runtimeService.getVariable(this.executionId, this.variableName)));
    }

    @Override
    public void set(Map<K, V> value, boolean isTransient) {
        this.runtimeService.setVariable(this.executionId, this.variableName, (Object)this.getTypedValue(value, isTransient));
    }

    @Override
    public Optional<Map<K, V>> getLocalOptional() {
        return Optional.ofNullable(this.getOrNull(this.runtimeService.getVariableLocal(this.executionId, this.variableName)));
    }

    @Override
    public void setLocal(Map<K, V> value, boolean isTransient) {
        this.runtimeService.setVariableLocal(this.executionId, this.variableName, (Object)this.getTypedValue(value, isTransient));
    }

    @Override
    public void remove() {
        this.runtimeService.removeVariable(this.executionId, this.variableName);
    }

    @Override
    public void removeLocal() {
        this.runtimeService.removeVariableLocal(this.executionId, this.variableName);
    }
}

