/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.camunda.bpm.data.adapter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import io.holunda.camunda.bpm.data.adapter.WrongVariableTypeException;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.camunda.bpm.engine.variable.impl.value.ObjectValueImpl;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JW\u0010\u0004\u001a\u0004\u0018\u0001H\u0005\"\b\b\u0000\u0010\u0006*\u00020\u0001\"\u000e\b\u0001\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00060\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00060\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012Jf\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u0002H\u0015\u0018\u00010\u0013\"\b\b\u0000\u0010\u0014*\u00020\u0001\"\b\b\u0001\u0010\u0015*\u00020\u00012\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00140\r2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00150\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019\u00a8\u0006\u001a"}, d2={"Lio/holunda/camunda/bpm/data/adapter/CollectionTypedValueUtil;", "", "<init>", "()V", "readFromTypedValue", "C", "T", "", "typedValue", "Lorg/camunda/bpm/engine/variable/value/TypedValue;", "variableName", "", "memberClazz", "Ljava/lang/Class;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "collectionType", "Lcom/fasterxml/jackson/databind/type/CollectionType;", "(Lorg/camunda/bpm/engine/variable/value/TypedValue;Ljava/lang/String;Ljava/lang/Class;Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/fasterxml/jackson/databind/type/CollectionType;)Ljava/util/Collection;", "", "K", "V", "keyClazz", "valueClazz", "mapType", "Lcom/fasterxml/jackson/databind/type/MapType;", "camunda-bpm-data"})
public final class CollectionTypedValueUtil {
    @NotNull
    public static final CollectionTypedValueUtil INSTANCE = new CollectionTypedValueUtil();

    private CollectionTypedValueUtil() {
    }

    @Nullable
    public final <T, C extends Collection<? extends T>> C readFromTypedValue(@Nullable TypedValue typedValue, @NotNull String variableName, @NotNull Class<T> memberClazz, @NotNull ObjectMapper objectMapper, @NotNull CollectionType collectionType) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
        Intrinsics.checkNotNullParameter(memberClazz, (String)"memberClazz");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)collectionType, (String)"collectionType");
        if (typedValue == null) {
            return null;
        }
        if (typedValue instanceof ObjectValueImpl) {
            String json = ((ObjectValueImpl)typedValue).getValueSerialized();
            try {
                Collection collection2;
                Collection values = (Collection)objectMapper.readValue(json, (JavaType)collectionType);
                if (values.isEmpty()) {
                    collection2 = values;
                } else {
                    Object value = values.iterator().next();
                    if (memberClazz.isAssignableFrom(value.getClass())) {
                        collection2 = values;
                    } else {
                        throw new WrongVariableTypeException("Error reading " + variableName + ": Wrong member type detected, expected " + memberClazz.getName() + ", but was not found in " + values);
                    }
                }
                collection = collection2;
            }
            catch (JsonProcessingException jpe) {
                throw new WrongVariableTypeException("Error reading " + variableName + ": Couldn't read value from " + json);
            }
        } else {
            throw new WrongVariableTypeException("Error reading " + variableName + ": Couldn't read value from " + typedValue);
        }
        return (C)collection;
    }

    @Nullable
    public final <K, V> Map<K, V> readFromTypedValue(@Nullable TypedValue typedValue, @NotNull String variableName, @NotNull Class<K> keyClazz, @NotNull Class<V> valueClazz, @NotNull ObjectMapper objectMapper, @NotNull MapType mapType) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
        Intrinsics.checkNotNullParameter(keyClazz, (String)"keyClazz");
        Intrinsics.checkNotNullParameter(valueClazz, (String)"valueClazz");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)mapType, (String)"mapType");
        if (typedValue == null) {
            return null;
        }
        if (typedValue instanceof ObjectValueImpl) {
            String json = ((ObjectValueImpl)typedValue).getValueSerialized();
            try {
                Map map2;
                Map map3 = (Map)objectMapper.readValue(json, (JavaType)mapType);
                if (map3.isEmpty()) {
                    map2 = map3;
                } else {
                    Map.Entry entry = map3.entrySet().iterator().next();
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (valueClazz.isAssignableFrom(value.getClass()) && keyClazz.isAssignableFrom(key.getClass())) {
                        map2 = map3;
                    } else {
                        throw new WrongVariableTypeException("Error reading " + variableName + ": Wrong map type detected, expected key " + keyClazz.getName() + " and value " + valueClazz.getName() + ", but was not found in " + map3);
                    }
                }
                map = map2;
            }
            catch (JsonProcessingException jpe) {
                throw new WrongVariableTypeException("Error reading " + variableName + ": Couldn't read value from " + json);
            }
        } else {
            throw new WrongVariableTypeException("Error reading " + variableName + ": Couldn't read value from " + typedValue);
        }
        return map;
    }
}

