/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.polyflow.bus.jackson.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.ObjectUtils;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003\u00a8\u0006\u0007"}, d2={"isQualifierMatch", "", "beanName", "", "beanFactory", "Lorg/springframework/beans/factory/config/ConfigurableListableBeanFactory;", "qualifier", "polyflow-bus-jackson"})
public final class AbstractQualifiedBeanConditionKt {
    public static final boolean isQualifierMatch(@NotNull String beanName, @NotNull ConfigurableListableBeanFactory beanFactory, @NotNull String qualifier) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)beanName, (String)"beanName");
        Intrinsics.checkNotNullParameter((Object)beanFactory, (String)"beanFactory");
        Intrinsics.checkNotNullParameter((Object)qualifier, (String)"qualifier");
        if (!beanFactory.containsBean(beanName)) {
            bl = false;
        } else {
            try {
                Method factoryMethod;
                AutowireCandidateQualifier candidate;
                BeanDefinition beanDefinition = beanFactory.getMergedBeanDefinition(beanName);
                Intrinsics.checkNotNullExpressionValue((Object)beanDefinition, (String)"beanFactory.getMergedBeanDefinition(beanName)");
                BeanDefinition bd = beanDefinition;
                if (bd instanceof AnnotatedBeanDefinition) {
                    MethodMetadata factoryMethodMetadata;
                    MethodMetadata methodMetadata = factoryMethodMetadata = ((AnnotatedBeanDefinition)bd).getFactoryMethodMetadata();
                    Intrinsics.checkNotNull((Object)methodMetadata);
                    Map qualifierAttributes = methodMetadata.getAnnotationAttributes(Qualifier.class.getName());
                    if (qualifierAttributes != null && Intrinsics.areEqual((Object)qualifier, qualifierAttributes.get("value"))) {
                        return true;
                    }
                }
                if (bd instanceof AbstractBeanDefinition && ((candidate = ((AbstractBeanDefinition)bd).getQualifier(Qualifier.class.getName())) != null && Intrinsics.areEqual((Object)qualifier, (Object)candidate.getAttribute("value")) || Intrinsics.areEqual((Object)qualifier, (Object)beanName) || ObjectUtils.containsElement((Object[])beanFactory.getAliases(beanName), (Object)qualifier))) {
                    return true;
                }
                Qualifier targetAnnotation = null;
                if (bd instanceof RootBeanDefinition && (factoryMethod = ((RootBeanDefinition)bd).getResolvedFactoryMethod()) != null && (targetAnnotation = (Qualifier)AnnotationUtils.getAnnotation((Method)factoryMethod, Qualifier.class)) != null) {
                    return Intrinsics.areEqual((Object)qualifier, (Object)targetAnnotation.value());
                }
                Class beanType = beanFactory.getType(beanName);
                if (beanType != null && (targetAnnotation = (Qualifier)AnnotationUtils.getAnnotation((AnnotatedElement)beanType, Qualifier.class)) != null) {
                    return Intrinsics.areEqual((Object)qualifier, (Object)targetAnnotation.value());
                }
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
            bl = false;
        }
        return bl;
    }
}

