/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.polyflow.client.camunda.task;

import io.holunda.camunda.taskpool.api.task.TaskClaimedEvent;
import io.holunda.camunda.taskpool.api.task.TaskDeferredEvent;
import io.holunda.camunda.taskpool.api.task.TaskIdentity;
import io.holunda.camunda.taskpool.api.task.TaskToBeCompletedEvent;
import io.holunda.camunda.taskpool.api.task.TaskUnclaimedEvent;
import io.holunda.camunda.taskpool.api.task.TaskUndeferredEvent;
import io.holunda.polyflow.client.camunda.CamundaEngineClientProperties;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.axonframework.eventhandling.EventHandler;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.task.Task;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0012J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\rH\u0017J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u000eH\u0017J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u000fH\u0017J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0010H\u0017J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0011H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/holunda/polyflow/client/camunda/task/TaskEventHandlers;", "", "taskService", "Lorg/camunda/bpm/engine/TaskService;", "properties", "Lio/holunda/polyflow/client/camunda/CamundaEngineClientProperties;", "(Lorg/camunda/bpm/engine/TaskService;Lio/holunda/polyflow/client/camunda/CamundaEngineClientProperties;)V", "isAddressedToMe", "", "event", "Lio/holunda/camunda/taskpool/api/task/TaskIdentity;", "on", "", "Lio/holunda/camunda/taskpool/api/task/TaskClaimedEvent;", "Lio/holunda/camunda/taskpool/api/task/TaskDeferredEvent;", "Lio/holunda/camunda/taskpool/api/task/TaskToBeCompletedEvent;", "Lio/holunda/camunda/taskpool/api/task/TaskUnclaimedEvent;", "Lio/holunda/camunda/taskpool/api/task/TaskUndeferredEvent;", "Companion", "polyflow-camunda-bpm-engine-client"})
public class TaskEventHandlers {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TaskService taskService;
    @NotNull
    private final CamundaEngineClientProperties properties;

    public TaskEventHandlers(@NotNull TaskService taskService, @NotNull CamundaEngineClientProperties properties) {
        Intrinsics.checkNotNullParameter((Object)taskService, (String)"taskService");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.taskService = taskService;
        this.properties = properties;
    }

    @EventHandler
    public void on(@NotNull TaskClaimedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isAddressedToMe((TaskIdentity)event)) {
            try {
                Companion.getLogger().debug((Function0)new Function0<Object>(event){
                    final /* synthetic */ TaskClaimedEvent $event;
                    {
                        this.$event = $event;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Claiming task " + this.$event;
                    }
                });
                Task task = (Task)this.taskService.createTaskQuery().taskId(event.getId()).singleResult();
                if (task != null) {
                    this.taskService.setAssignee(event.getId(), event.getAssignee());
                } else {
                    Companion.getLogger().error((Function0)new Function0<Object>(event){
                        final /* synthetic */ TaskClaimedEvent $event;
                        {
                            this.$event = $event;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "CLIENT-004: Task with id " + this.$event.getId() + " was not found in the engine. Ignoring the event " + this.$event + ".";
                        }
                    });
                }
            }
            catch (ProcessEngineException e) {
                Companion.getLogger().error("CLIENT-001: Error claiming task", (Throwable)e);
            }
        }
    }

    @EventHandler
    public void on(@NotNull TaskUnclaimedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isAddressedToMe((TaskIdentity)event)) {
            try {
                Companion.getLogger().debug((Function0)new Function0<Object>(event){
                    final /* synthetic */ TaskUnclaimedEvent $event;
                    {
                        this.$event = $event;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Unclaiming task " + this.$event;
                    }
                });
                Task task = (Task)this.taskService.createTaskQuery().taskId(event.getId()).singleResult();
                if (task != null) {
                    this.taskService.setAssignee(event.getId(), null);
                } else {
                    Companion.getLogger().error((Function0)new Function0<Object>(event){
                        final /* synthetic */ TaskUnclaimedEvent $event;
                        {
                            this.$event = $event;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "CLIENT-005: Task with id " + this.$event.getId() + " was not found in the engine. Ignoring the event " + this.$event + ".";
                        }
                    });
                }
            }
            catch (ProcessEngineException e) {
                Companion.getLogger().error("CLIENT-002: Error un-claiming task", (Throwable)e);
            }
        }
    }

    @EventHandler
    public void on(@NotNull TaskToBeCompletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isAddressedToMe((TaskIdentity)event)) {
            try {
                Companion.getLogger().debug((Function0)new Function0<Object>(event){
                    final /* synthetic */ TaskToBeCompletedEvent $event;
                    {
                        this.$event = $event;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Completing task " + this.$event;
                    }
                });
                Task task = (Task)this.taskService.createTaskQuery().taskId(event.getId()).singleResult();
                if (task != null) {
                    this.taskService.complete(event.getId(), (Map)event.getPayload());
                } else {
                    Companion.getLogger().error((Function0)new Function0<Object>(event){
                        final /* synthetic */ TaskToBeCompletedEvent $event;
                        {
                            this.$event = $event;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "CLIENT-006: Task with id " + this.$event.getId() + " was not found in the engine. Ignoring the event " + this.$event + ".";
                        }
                    });
                }
            }
            catch (ProcessEngineException e) {
                Companion.getLogger().error("CLIENT-003: Error completing task", (Throwable)e);
            }
        }
    }

    @EventHandler
    public void on(@NotNull TaskDeferredEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isAddressedToMe((TaskIdentity)event)) {
            try {
                Companion.getLogger().debug((Function0)new Function0<Object>(event){
                    final /* synthetic */ TaskDeferredEvent $event;
                    {
                        this.$event = $event;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Deferring task " + this.$event;
                    }
                });
                Task task = (Task)this.taskService.createTaskQuery().taskId(event.getId()).singleResult();
                if (task != null) {
                    if (!Intrinsics.areEqual((Object)task.getFollowUpDate(), (Object)event.getFollowUpDate())) {
                        task.setFollowUpDate(event.getFollowUpDate());
                        this.taskService.saveTask(task);
                    } else {
                        Companion.getLogger().debug("CLIENT-008: Task deferred event ignored because task with id " + event.getId() + " had equal follow-up date set already.");
                    }
                } else {
                    Companion.getLogger().error((Function0)new Function0<Object>(event){
                        final /* synthetic */ TaskDeferredEvent $event;
                        {
                            this.$event = $event;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "CLIENT-006: Task with id " + this.$event.getId() + " was not found in the engine. Ignoring the event " + this.$event + ".";
                        }
                    });
                }
            }
            catch (ProcessEngineException e) {
                Companion.getLogger().error("CLIENT-003: Error deferring task", (Throwable)e);
            }
        }
    }

    @EventHandler
    public void on(@NotNull TaskUndeferredEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isAddressedToMe((TaskIdentity)event)) {
            try {
                Companion.getLogger().debug((Function0)new Function0<Object>(event){
                    final /* synthetic */ TaskUndeferredEvent $event;
                    {
                        this.$event = $event;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Deferring task " + this.$event;
                    }
                });
                Task task = (Task)this.taskService.createTaskQuery().taskId(event.getId()).singleResult();
                if (task != null) {
                    if (task.getFollowUpDate() != null) {
                        task.setFollowUpDate(null);
                        this.taskService.saveTask(task);
                    } else {
                        Companion.getLogger().debug("CLIENT-007: Task undeferred event ignored because task with id " + event.getId() + " was not deferred.");
                    }
                } else {
                    Companion.getLogger().error((Function0)new Function0<Object>(event){
                        final /* synthetic */ TaskUndeferredEvent $event;
                        {
                            this.$event = $event;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "CLIENT-006: Task with id " + this.$event.getId() + " was not found in the engine. Ignoring the event " + this.$event + ".";
                        }
                    });
                }
            }
            catch (ProcessEngineException e) {
                Companion.getLogger().error("CLIENT-003: Error deferring task", (Throwable)e);
            }
        }
    }

    private boolean isAddressedToMe(TaskIdentity event) {
        return Intrinsics.areEqual((Object)this.properties.getApplicationName(), (Object)event.getSourceReference().getApplicationName());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/holunda/polyflow/client/camunda/task/TaskEventHandlers$Companion;", "Lmu/KLogging;", "()V", "polyflow-camunda-bpm-engine-client"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

