/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.polyflow.taskpool.collector.process.instance;

import io.holunda.camunda.taskpool.api.process.instance.CancelProcessInstanceCommand;
import io.holunda.camunda.taskpool.api.process.instance.EndProcessInstanceCommand;
import io.holunda.camunda.taskpool.api.process.instance.FinishProcessInstanceCommand;
import io.holunda.camunda.taskpool.api.process.instance.ResumeProcessInstanceCommand;
import io.holunda.camunda.taskpool.api.process.instance.StartProcessInstanceCommand;
import io.holunda.camunda.taskpool.api.process.instance.SuspendProcessInstanceCommand;
import io.holunda.camunda.taskpool.api.process.instance.UpdateProcessInstanceCommand;
import io.holunda.camunda.taskpool.api.task.SourceReference;
import io.holunda.polyflow.taskpool.HistoricProcessInstanceEventExtensionsKt;
import io.holunda.polyflow.taskpool.collector.CamundaTaskpoolCollectorProperties;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.impl.history.event.HistoricProcessInstanceEventEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/holunda/polyflow/taskpool/collector/process/instance/ProcessInstanceEventCollectorService;", "", "camundaTaskpoolCollectorProperties", "Lio/holunda/polyflow/taskpool/collector/CamundaTaskpoolCollectorProperties;", "repositoryService", "Lorg/camunda/bpm/engine/RepositoryService;", "(Lio/holunda/polyflow/taskpool/collector/CamundaTaskpoolCollectorProperties;Lorg/camunda/bpm/engine/RepositoryService;)V", "create", "Lio/holunda/camunda/taskpool/api/process/instance/StartProcessInstanceCommand;", "processInstance", "Lorg/camunda/bpm/engine/impl/history/event/HistoricProcessInstanceEventEntity;", "end", "Lio/holunda/camunda/taskpool/api/process/instance/EndProcessInstanceCommand;", "update", "Lio/holunda/camunda/taskpool/api/process/instance/UpdateProcessInstanceCommand;", "Companion", "polyflow-camunda-bpm-taskpool-collector"})
public final class ProcessInstanceEventCollectorService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CamundaTaskpoolCollectorProperties camundaTaskpoolCollectorProperties;
    @NotNull
    private final RepositoryService repositoryService;
    public static final int ORDER = 2147483547;

    public ProcessInstanceEventCollectorService(@NotNull CamundaTaskpoolCollectorProperties camundaTaskpoolCollectorProperties, @NotNull RepositoryService repositoryService) {
        Intrinsics.checkNotNullParameter((Object)camundaTaskpoolCollectorProperties, (String)"camundaTaskpoolCollectorProperties");
        Intrinsics.checkNotNullParameter((Object)repositoryService, (String)"repositoryService");
        this.camundaTaskpoolCollectorProperties = camundaTaskpoolCollectorProperties;
        this.repositoryService = repositoryService;
    }

    @Order(value=2147483547)
    @EventListener(condition="#processInstance.eventType.equals('start')")
    @NotNull
    public final StartProcessInstanceCommand create(@NotNull HistoricProcessInstanceEventEntity processInstance) {
        Intrinsics.checkNotNullParameter((Object)processInstance, (String)"processInstance");
        SourceReference sourceReference = HistoricProcessInstanceEventExtensionsKt.sourceReference(processInstance, this.repositoryService, this.camundaTaskpoolCollectorProperties.getApplicationName());
        String string = processInstance.getProcessInstanceId();
        String string2 = processInstance.getBusinessKey();
        String string3 = processInstance.getStartActivityId();
        String string4 = processInstance.getStartUserId();
        String string5 = processInstance.getSuperProcessInstanceId() != null ? processInstance.getSuperProcessInstanceId() : (processInstance.getSuperCaseInstanceId() != null ? processInstance.getSuperCaseInstanceId() : null);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"processInstanceId");
        return new StartProcessInstanceCommand(string, sourceReference, string2, string4, string5, string3);
    }

    @Order(value=2147483547)
    @EventListener(condition="#processInstance.eventType.equals('update')")
    @Nullable
    public final UpdateProcessInstanceCommand update(@NotNull HistoricProcessInstanceEventEntity processInstance) {
        UpdateProcessInstanceCommand updateProcessInstanceCommand;
        Intrinsics.checkNotNullParameter((Object)processInstance, (String)"processInstance");
        String string = processInstance.getState();
        if (Intrinsics.areEqual((Object)string, (Object)"SUSPENDED")) {
            SourceReference sourceReference = HistoricProcessInstanceEventExtensionsKt.sourceReference(processInstance, this.repositoryService, this.camundaTaskpoolCollectorProperties.getApplicationName());
            String string2 = processInstance.getProcessInstanceId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"processInstanceId");
            updateProcessInstanceCommand = (UpdateProcessInstanceCommand)new SuspendProcessInstanceCommand(string2, sourceReference);
        } else if (Intrinsics.areEqual((Object)string, (Object)"ACTIVE")) {
            SourceReference sourceReference = HistoricProcessInstanceEventExtensionsKt.sourceReference(processInstance, this.repositoryService, this.camundaTaskpoolCollectorProperties.getApplicationName());
            String string3 = processInstance.getProcessInstanceId();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"processInstanceId");
            updateProcessInstanceCommand = (UpdateProcessInstanceCommand)new ResumeProcessInstanceCommand(string3, sourceReference);
        } else {
            Companion.getLogger().debug((Function0)new Function0<Object>(processInstance){
                final /* synthetic */ HistoricProcessInstanceEventEntity $processInstance;
                {
                    this.$processInstance = $processInstance;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Unknown update process instance event received " + this.$processInstance;
                }
            });
            updateProcessInstanceCommand = null;
        }
        return updateProcessInstanceCommand;
    }

    @Order(value=2147483547)
    @EventListener(condition="#processInstance.eventType.equals('end')")
    @Nullable
    public final EndProcessInstanceCommand end(@NotNull HistoricProcessInstanceEventEntity processInstance) {
        EndProcessInstanceCommand endProcessInstanceCommand;
        Intrinsics.checkNotNullParameter((Object)processInstance, (String)"processInstance");
        String string = processInstance.getState();
        if (Intrinsics.areEqual((Object)string, (Object)"EXTERNALLY_TERMINATED")) {
            SourceReference sourceReference = HistoricProcessInstanceEventExtensionsKt.sourceReference(processInstance, this.repositoryService, this.camundaTaskpoolCollectorProperties.getApplicationName());
            String string2 = processInstance.getProcessInstanceId();
            String string3 = processInstance.getBusinessKey();
            String string4 = processInstance.getEndActivityId();
            String string5 = processInstance.getSuperProcessInstanceId() != null ? processInstance.getSuperProcessInstanceId() : (processInstance.getSuperCaseInstanceId() != null ? processInstance.getSuperCaseInstanceId() : null);
            String string6 = processInstance.getDeleteReason();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"processInstanceId");
            endProcessInstanceCommand = (EndProcessInstanceCommand)new CancelProcessInstanceCommand(string2, sourceReference, string3, string5, string4, string6);
        } else if (Intrinsics.areEqual((Object)string, (Object)"INTERNALLY_TERMINATED")) {
            SourceReference sourceReference = HistoricProcessInstanceEventExtensionsKt.sourceReference(processInstance, this.repositoryService, this.camundaTaskpoolCollectorProperties.getApplicationName());
            String string7 = processInstance.getProcessInstanceId();
            String string8 = processInstance.getBusinessKey();
            String string9 = processInstance.getEndActivityId();
            String string10 = processInstance.getSuperProcessInstanceId() != null ? processInstance.getSuperProcessInstanceId() : (processInstance.getSuperCaseInstanceId() != null ? processInstance.getSuperCaseInstanceId() : null);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"processInstanceId");
            endProcessInstanceCommand = (EndProcessInstanceCommand)new FinishProcessInstanceCommand(string7, sourceReference, string8, string10, string9);
        } else {
            Companion.getLogger().debug((Function0)new Function0<Object>(processInstance){
                final /* synthetic */ HistoricProcessInstanceEventEntity $processInstance;
                {
                    this.$processInstance = $processInstance;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Unknown end process instance event received " + this.$processInstance;
                }
            });
            endProcessInstanceCommand = null;
        }
        return endProcessInstanceCommand;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/holunda/polyflow/taskpool/collector/process/instance/ProcessInstanceEventCollectorService$Companion;", "Lmu/KLogging;", "()V", "ORDER", "", "polyflow-camunda-bpm-taskpool-collector"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

