/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.polyflow.taskpool.collector.task;

import io.holunda.camunda.taskpool.api.task.AddCandidateGroupsCommand;
import io.holunda.camunda.taskpool.api.task.AddCandidateUsersCommand;
import io.holunda.camunda.taskpool.api.task.AssignTaskCommand;
import io.holunda.camunda.taskpool.api.task.CompleteTaskCommand;
import io.holunda.camunda.taskpool.api.task.CreateTaskCommand;
import io.holunda.camunda.taskpool.api.task.DeleteCandidateGroupsCommand;
import io.holunda.camunda.taskpool.api.task.DeleteCandidateUsersCommand;
import io.holunda.camunda.taskpool.api.task.DeleteTaskCommand;
import io.holunda.camunda.taskpool.api.task.EngineTaskCommand;
import io.holunda.camunda.taskpool.api.task.SourceReference;
import io.holunda.camunda.taskpool.api.task.UpdateAssignmentTaskCommand;
import io.holunda.camunda.taskpool.api.task.UpdateAttributeTaskCommand;
import io.holunda.camunda.taskpool.api.task.UpdateAttributesHistoricTaskCommand;
import io.holunda.polyflow.taskpool.DelegateTaskExtensionsKt;
import io.holunda.polyflow.taskpool.HistoricScopeInstanceEventExtensionsKt;
import io.holunda.polyflow.taskpool.TaskEntityExtensionsKt;
import io.holunda.polyflow.taskpool.collector.CamundaTaskpoolCollectorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogging;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.impl.history.event.HistoricIdentityLinkLogEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricScopeInstanceEvent;
import org.camunda.bpm.engine.impl.history.event.HistoricTaskInstanceEventEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.task.IdentityLink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0014\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0019H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/holunda/polyflow/taskpool/collector/task/TaskEventCollectorService;", "", "camundaTaskpoolCollectorProperties", "Lio/holunda/polyflow/taskpool/collector/CamundaTaskpoolCollectorProperties;", "repositoryService", "Lorg/camunda/bpm/engine/RepositoryService;", "(Lio/holunda/polyflow/taskpool/collector/CamundaTaskpoolCollectorProperties;Lorg/camunda/bpm/engine/RepositoryService;)V", "getCamundaTaskpoolCollectorProperties", "()Lio/holunda/polyflow/taskpool/collector/CamundaTaskpoolCollectorProperties;", "all", "", "task", "Lorg/camunda/bpm/engine/delegate/DelegateTask;", "assign", "complete", "Lio/holunda/camunda/taskpool/api/task/CompleteTaskCommand;", "create", "Lio/holunda/camunda/taskpool/api/task/CreateTaskCommand;", "delete", "Lio/holunda/camunda/taskpool/api/task/DeleteTaskCommand;", "update", "Lio/holunda/camunda/taskpool/api/task/UpdateAttributeTaskCommand;", "changeEvent", "Lorg/camunda/bpm/engine/impl/history/event/HistoricIdentityLinkLogEventEntity;", "Lio/holunda/camunda/taskpool/api/task/UpdateAttributesHistoricTaskCommand;", "Lorg/camunda/bpm/engine/impl/history/event/HistoricTaskInstanceEventEntity;", "Companion", "polyflow-camunda-bpm-taskpool-collector"})
@SourceDebugExtension(value={"SMAP\nTaskEventCollectorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskEventCollectorService.kt\nio/holunda/polyflow/taskpool/collector/task/TaskEventCollectorService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,205:1\n766#2:206\n857#2,2:207\n1549#2:209\n1620#2,3:210\n766#2:213\n857#2,2:214\n1549#2:216\n1620#2,3:217\n*S KotlinDebug\n*F\n+ 1 TaskEventCollectorService.kt\nio/holunda/polyflow/taskpool/collector/task/TaskEventCollectorService\n*L\n55#1:206\n55#1:207,2\n55#1:209\n55#1:210,3\n56#1:213\n56#1:214,2\n56#1:216\n56#1:217,3\n*E\n"})
public final class TaskEventCollectorService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CamundaTaskpoolCollectorProperties camundaTaskpoolCollectorProperties;
    @NotNull
    private final RepositoryService repositoryService;
    @NotNull
    public static final String NAME = "taskEventCollectorService";
    public static final int ORDER = 2147483547;

    public TaskEventCollectorService(@NotNull CamundaTaskpoolCollectorProperties camundaTaskpoolCollectorProperties, @NotNull RepositoryService repositoryService) {
        Intrinsics.checkNotNullParameter((Object)camundaTaskpoolCollectorProperties, (String)"camundaTaskpoolCollectorProperties");
        Intrinsics.checkNotNullParameter((Object)repositoryService, (String)"repositoryService");
        this.camundaTaskpoolCollectorProperties = camundaTaskpoolCollectorProperties;
        this.repositoryService = repositoryService;
    }

    @NotNull
    public final CamundaTaskpoolCollectorProperties getCamundaTaskpoolCollectorProperties() {
        return this.camundaTaskpoolCollectorProperties;
    }

    @Order(value=2147483537)
    @EventListener
    public final void all(@NotNull DelegateTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (Companion.getLogger().isTraceEnabled()) {
            Companion.getLogger().trace("Received " + task.getEventName() + " event on task with id " + task.getId());
            if (task instanceof TaskEntity) {
                Companion.getLogger().trace("\tProperties: {}", (Object)CollectionsKt.joinToString$default((Iterable)((TaskEntity)task).getPropertyChanges().keySet(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
                Companion.getLogger().trace("\tIdentity links: {}", (Object)CollectionsKt.joinToString$default((Iterable)TaskEntityExtensionsKt.getIdentityLinkChanges((TaskEntity)task), (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Order(value=2147483547)
    @EventListener(condition="#task.eventName.equals('create') && @taskEventCollectorService.camundaTaskpoolCollectorProperties.task.collectTaskEvent('create')")
    @NotNull
    public final CreateTaskCommand create(@NotNull DelegateTask task) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        IdentityLink it;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        String string = task.getId();
        String string2 = task.getAssignee();
        Set set = task.getCandidates();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"task.candidates");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (IdentityLink)element$iv$iv;
            boolean bl = false;
            if (!(it.getGroupId() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (IdentityLink)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getGroupId());
        }
        Set set2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set set3 = task.getCandidates();
        Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"task.candidates");
        Iterable $this$filter$iv2 = set3;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IdentityLink it2 = (IdentityLink)element$iv$iv;
            boolean bl = false;
            if (!(it2.getUserId() != null && Intrinsics.areEqual((Object)it2.getType(), (Object)"candidate"))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IdentityLink it2 = (IdentityLink)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it2.getUserId());
        }
        Set set4 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Date date = task.getCreateTime();
        String string3 = task.getDescription();
        Date date2 = task.getDueDate();
        String string4 = task.getEventName();
        String string5 = task.getName();
        String string6 = task.getOwner();
        int n = task.getPriority();
        String string7 = DelegateTaskExtensionsKt.formKey(task);
        String string8 = task.getTaskDefinitionKey();
        String string9 = task.getExecution().getBusinessKey();
        SourceReference sourceReference = DelegateTaskExtensionsKt.sourceReference(task, this.camundaTaskpoolCollectorProperties.getApplicationName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id");
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"taskDefinitionKey");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"eventName");
        return new CreateTaskCommand(string, sourceReference, string8, string7, 0, string4, string9, null, null, false, string2, set4, set2, date, string3, date2, null, string5, string6, Integer.valueOf(n), 66448, null);
    }

    @Order(value=2147483547)
    @EventListener(condition="#task.eventName.equals('complete') && @taskEventCollectorService.camundaTaskpoolCollectorProperties.task.collectTaskEvent('complete')")
    @NotNull
    public final CompleteTaskCommand complete(@NotNull DelegateTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        String string = task.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"task.id");
        String string2 = task.getEventName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"task.eventName");
        return new CompleteTaskCommand(string, 0, string2, null, 10, null);
    }

    @Order(value=2147483547)
    @EventListener(condition="#task.eventName.equals('assignment') && @taskEventCollectorService.camundaTaskpoolCollectorProperties.task.collectTaskEvent('assignment')")
    public final void assign(@NotNull DelegateTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (Companion.getLogger().isTraceEnabled()) {
            Companion.getLogger().trace((Function0)new Function0<Object>(task){
                final /* synthetic */ DelegateTask $task;
                {
                    this.$task = $task;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Task " + this.$task.getId() + " is assigned to " + this.$task.getAssignee() + ".";
                }
            });
        }
    }

    @Order(value=2147483547)
    @EventListener(condition="#task.eventName.equals('delete') && @taskEventCollectorService.camundaTaskpoolCollectorProperties.task.collectTaskEvent('delete')")
    @NotNull
    public final DeleteTaskCommand delete(@NotNull DelegateTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        String string = task.getId();
        String string2 = task.getDeleteReason();
        String string3 = task.getEventName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"eventName");
        return new DeleteTaskCommand(string, 0, string3, string2, 2, null);
    }

    @Order(value=2147483547)
    @EventListener(condition="#task.eventName.equals('update') && @taskEventCollectorService.camundaTaskpoolCollectorProperties.task.collectTaskEvent('update')")
    @Nullable
    public final UpdateAttributeTaskCommand update(@NotNull DelegateTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        return task instanceof TaskEntity ? (TaskEntityExtensionsKt.isAssigneeChange((TaskEntity)task) ? null : DelegateTaskExtensionsKt.toUpdateCommand(task, this.camundaTaskpoolCollectorProperties.getApplicationName())) : DelegateTaskExtensionsKt.toUpdateCommand(task, this.camundaTaskpoolCollectorProperties.getApplicationName());
    }

    @Order(value=2147483547)
    @EventListener(condition="#changeEvent.eventType.equals('update') && @taskEventCollectorService.camundaTaskpoolCollectorProperties.task.collectHistoryEvent('update')")
    @NotNull
    public final UpdateAttributesHistoricTaskCommand update(@NotNull HistoricTaskInstanceEventEntity changeEvent) {
        Intrinsics.checkNotNullParameter((Object)changeEvent, (String)"changeEvent");
        String string = changeEvent.getTaskId();
        String string2 = changeEvent.getDescription();
        Date date = changeEvent.getDueDate();
        Date date2 = changeEvent.getFollowUpDate();
        String string3 = changeEvent.getName();
        String string4 = changeEvent.getOwner();
        int n = changeEvent.getPriority();
        String string5 = changeEvent.getTaskDefinitionKey();
        SourceReference sourceReference = HistoricScopeInstanceEventExtensionsKt.sourceReference((HistoricScopeInstanceEvent)changeEvent, this.repositoryService, this.camundaTaskpoolCollectorProperties.getApplicationName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"taskId");
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"taskDefinitionKey");
        return new UpdateAttributesHistoricTaskCommand(string, 0, null, sourceReference, string5, null, null, null, false, string2, date, date2, string3, string4, Integer.valueOf(n), 486, null);
    }

    @Order(value=2147483547)
    @EventListener(condition="@taskEventCollectorService.camundaTaskpoolCollectorProperties.task.collectHistoryEvent('add-identity-link') || @taskEventCollectorService.camundaTaskpoolCollectorProperties.task.collectHistoryEvent('delete-identity-link')")
    @Nullable
    public final Object update(@NotNull HistoricIdentityLinkLogEventEntity changeEvent) {
        EngineTaskCommand engineTaskCommand;
        Intrinsics.checkNotNullParameter((Object)changeEvent, (String)"changeEvent");
        if (Intrinsics.areEqual((Object)changeEvent.getOperationType(), (Object)"add") && Intrinsics.areEqual((Object)changeEvent.getType(), (Object)"assignee")) {
            String string = changeEvent.getTaskId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"changeEvent.taskId");
            engineTaskCommand = (EngineTaskCommand)new AssignTaskCommand(string, 0, null, changeEvent.getUserId(), 6, null);
        } else if (Intrinsics.areEqual((Object)changeEvent.getOperationType(), (Object)"delete") && Intrinsics.areEqual((Object)changeEvent.getType(), (Object)"assignee")) {
            String string = changeEvent.getTaskId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"changeEvent.taskId");
            engineTaskCommand = (EngineTaskCommand)new AssignTaskCommand(string, 0, null, null, 6, null);
        } else if (Intrinsics.areEqual((Object)changeEvent.getOperationType(), (Object)"add") && Intrinsics.areEqual((Object)changeEvent.getType(), (Object)"candidate")) {
            UpdateAssignmentTaskCommand updateAssignmentTaskCommand;
            if (changeEvent.getTaskId() != null && changeEvent.getUserId() != null) {
                String string = changeEvent.getTaskId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"changeEvent.taskId");
                updateAssignmentTaskCommand = (UpdateAssignmentTaskCommand)new AddCandidateUsersCommand(string, SetsKt.setOf((Object)changeEvent.getUserId()));
            } else if (changeEvent.getTaskId() != null && changeEvent.getGroupId() != null) {
                String string = changeEvent.getTaskId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"changeEvent.taskId");
                updateAssignmentTaskCommand = (UpdateAssignmentTaskCommand)new AddCandidateGroupsCommand(string, SetsKt.setOf((Object)changeEvent.getGroupId()));
            } else {
                Companion.getLogger().warn("Received unexpected identity link historic update event " + changeEvent.getType() + " " + changeEvent.getOperationType() + " " + changeEvent.getEventType() + " on " + changeEvent.getTaskId());
                updateAssignmentTaskCommand = null;
            }
            engineTaskCommand = (EngineTaskCommand)updateAssignmentTaskCommand;
        } else if (Intrinsics.areEqual((Object)changeEvent.getOperationType(), (Object)"delete") && Intrinsics.areEqual((Object)changeEvent.getType(), (Object)"candidate")) {
            UpdateAssignmentTaskCommand updateAssignmentTaskCommand;
            if (changeEvent.getTaskId() != null && changeEvent.getUserId() != null) {
                String string = changeEvent.getTaskId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"changeEvent.taskId");
                updateAssignmentTaskCommand = (UpdateAssignmentTaskCommand)new DeleteCandidateUsersCommand(string, SetsKt.setOf((Object)changeEvent.getUserId()));
            } else if (changeEvent.getTaskId() != null && changeEvent.getGroupId() != null) {
                String string = changeEvent.getTaskId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"changeEvent.taskId");
                updateAssignmentTaskCommand = (UpdateAssignmentTaskCommand)new DeleteCandidateGroupsCommand(string, SetsKt.setOf((Object)changeEvent.getGroupId()));
            } else {
                Companion.getLogger().warn("Received unexpected identity link historic update event " + changeEvent.getType() + " " + changeEvent.getOperationType() + " " + changeEvent.getEventType() + " on " + changeEvent.getTaskId());
                updateAssignmentTaskCommand = null;
            }
            engineTaskCommand = (EngineTaskCommand)updateAssignmentTaskCommand;
        } else {
            Companion.getLogger().warn("Received unexpected identity link historic update event " + changeEvent.getType() + " " + changeEvent.getOperationType() + " " + changeEvent.getEventType() + " on " + changeEvent.getTaskId());
            engineTaskCommand = null;
        }
        return engineTaskCommand;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/holunda/polyflow/taskpool/collector/task/TaskEventCollectorService$Companion;", "Lmu/KLogging;", "()V", "NAME", "", "ORDER", "", "polyflow-camunda-bpm-taskpool-collector"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

