/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.polyflow.taskpool.collector.process.instance;

import io.holunda.camunda.taskpool.api.process.instance.CancelProcessInstanceCommand;
import io.holunda.camunda.taskpool.api.process.instance.EndProcessInstanceCommand;
import io.holunda.camunda.taskpool.api.process.instance.FinishProcessInstanceCommand;
import io.holunda.camunda.taskpool.api.process.instance.ResumeProcessInstanceCommand;
import io.holunda.camunda.taskpool.api.process.instance.StartProcessInstanceCommand;
import io.holunda.camunda.taskpool.api.process.instance.SuspendProcessInstanceCommand;
import io.holunda.camunda.taskpool.api.process.instance.UpdateProcessInstanceCommand;
import io.holunda.camunda.taskpool.api.task.SourceReference;
import io.holunda.polyflow.taskpool.HistoricProcessInstanceEventExtensionsKt;
import io.holunda.polyflow.taskpool.collector.CamundaTaskpoolCollectorProperties;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.impl.history.event.HistoricProcessInstanceEventEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/holunda/polyflow/taskpool/collector/process/instance/ProcessInstanceEventCollectorService;", "", "camundaTaskpoolCollectorProperties", "Lio/holunda/polyflow/taskpool/collector/CamundaTaskpoolCollectorProperties;", "repositoryService", "Lorg/camunda/bpm/engine/RepositoryService;", "(Lio/holunda/polyflow/taskpool/collector/CamundaTaskpoolCollectorProperties;Lorg/camunda/bpm/engine/RepositoryService;)V", "create", "Lio/holunda/camunda/taskpool/api/process/instance/StartProcessInstanceCommand;", "processInstance", "Lorg/camunda/bpm/engine/impl/history/event/HistoricProcessInstanceEventEntity;", "end", "Lio/holunda/camunda/taskpool/api/process/instance/EndProcessInstanceCommand;", "update", "Lio/holunda/camunda/taskpool/api/process/instance/UpdateProcessInstanceCommand;", "Companion", "polyflow-camunda-bpm-taskpool-collector"})
public final class ProcessInstanceEventCollectorService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CamundaTaskpoolCollectorProperties camundaTaskpoolCollectorProperties;
    @NotNull
    private final RepositoryService repositoryService;
    public static final int ORDER = 2147483547;

    public ProcessInstanceEventCollectorService(@NotNull CamundaTaskpoolCollectorProperties camundaTaskpoolCollectorProperties, @NotNull RepositoryService repositoryService) {
        Intrinsics.checkNotNullParameter((Object)camundaTaskpoolCollectorProperties, (String)"camundaTaskpoolCollectorProperties");
        Intrinsics.checkNotNullParameter((Object)repositoryService, (String)"repositoryService");
        this.camundaTaskpoolCollectorProperties = camundaTaskpoolCollectorProperties;
        this.repositoryService = repositoryService;
    }

    @Order(value=2147483547)
    @EventListener(condition="#processInstance.eventType.equals('start')")
    @NotNull
    public final StartProcessInstanceCommand create(@NotNull HistoricProcessInstanceEventEntity processInstance) {
        Intrinsics.checkNotNullParameter((Object)processInstance, (String)"processInstance");
        SourceReference sourceReference = HistoricProcessInstanceEventExtensionsKt.sourceReference(processInstance, this.repositoryService, this.camundaTaskpoolCollectorProperties.getApplicationName());
        String string = processInstance.getProcessInstanceId();
        String string2 = processInstance.getBusinessKey();
        String string3 = processInstance.getStartActivityId();
        String string4 = processInstance.getStartUserId();
        String string5 = processInstance.getSuperProcessInstanceId() != null ? processInstance.getSuperProcessInstanceId() : (processInstance.getSuperCaseInstanceId() != null ? processInstance.getSuperCaseInstanceId() : null);
        Intrinsics.checkNotNull((Object)string);
        return new StartProcessInstanceCommand(string, sourceReference, string2, string4, string5, string3);
    }

    @Order(value=2147483547)
    @EventListener(condition="#processInstance.eventType.equals('update')")
    @Nullable
    public final UpdateProcessInstanceCommand update(@NotNull HistoricProcessInstanceEventEntity processInstance) {
        UpdateProcessInstanceCommand updateProcessInstanceCommand;
        Intrinsics.checkNotNullParameter((Object)processInstance, (String)"processInstance");
        String string = processInstance.getState();
        if (Intrinsics.areEqual((Object)string, (Object)"SUSPENDED")) {
            SourceReference sourceReference = HistoricProcessInstanceEventExtensionsKt.sourceReference(processInstance, this.repositoryService, this.camundaTaskpoolCollectorProperties.getApplicationName());
            String string2 = processInstance.getProcessInstanceId();
            Intrinsics.checkNotNull((Object)string2);
            updateProcessInstanceCommand = (UpdateProcessInstanceCommand)new SuspendProcessInstanceCommand(string2, sourceReference);
        } else if (Intrinsics.areEqual((Object)string, (Object)"ACTIVE")) {
            SourceReference sourceReference = HistoricProcessInstanceEventExtensionsKt.sourceReference(processInstance, this.repositoryService, this.camundaTaskpoolCollectorProperties.getApplicationName());
            String string3 = processInstance.getProcessInstanceId();
            Intrinsics.checkNotNull((Object)string3);
            updateProcessInstanceCommand = (UpdateProcessInstanceCommand)new ResumeProcessInstanceCommand(string3, sourceReference);
        } else {
            Companion.getLogger().debug((Function0)new Function0<Object>(processInstance){
                final /* synthetic */ HistoricProcessInstanceEventEntity $processInstance;
                {
                    this.$processInstance = $processInstance;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Unknown update process instance event received " + this.$processInstance;
                }
            });
            updateProcessInstanceCommand = null;
        }
        return updateProcessInstanceCommand;
    }

    /*
     * Unable to fully structure code
     */
    @Order(value=2147483547)
    @EventListener(condition="#processInstance.eventType.equals('end')")
    @Nullable
    public final EndProcessInstanceCommand end(@NotNull HistoricProcessInstanceEventEntity processInstance) {
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)processInstance, (String)"processInstance");
                var2_2 = processInstance.getState();
                if (var2_2 == null) break block5;
                switch (var2_2.hashCode()) {
                    case 1383663147: {
                        if (var2_2.equals("COMPLETED")) break;
                        ** break;
                    }
                    case -1661099912: {
                        if (var2_2.equals("INTERNALLY_TERMINATED")) break;
                        ** break;
                    }
                    case 1995188778: {
                        if (!var2_2.equals("EXTERNALLY_TERMINATED")) ** break;
                        var3_3 = HistoricProcessInstanceEventExtensionsKt.sourceReference(processInstance, this.repositoryService, this.camundaTaskpoolCollectorProperties.getApplicationName());
                        var4_5 = processInstance.getProcessInstanceId();
                        var5_7 = processInstance.getBusinessKey();
                        var6_9 = processInstance.getEndActivityId();
                        var7_11 = processInstance.getSuperProcessInstanceId() != null ? processInstance.getSuperProcessInstanceId() : (processInstance.getSuperCaseInstanceId() != null ? processInstance.getSuperCaseInstanceId() : null);
                        var8_13 = processInstance.getDeleteReason();
                        Intrinsics.checkNotNull((Object)var4_5);
                        v0 = (EndProcessInstanceCommand)new CancelProcessInstanceCommand(var4_5, var3_3, var5_7, var7_11, var6_9, var8_13);
                        break block6;
                    }
                }
                var3_4 = HistoricProcessInstanceEventExtensionsKt.sourceReference(processInstance, this.repositoryService, this.camundaTaskpoolCollectorProperties.getApplicationName());
                var4_6 = processInstance.getProcessInstanceId();
                var5_8 = processInstance.getBusinessKey();
                var6_10 = processInstance.getEndActivityId();
                var7_12 = processInstance.getSuperProcessInstanceId() != null ? processInstance.getSuperProcessInstanceId() : (processInstance.getSuperCaseInstanceId() != null ? processInstance.getSuperCaseInstanceId() : null);
                Intrinsics.checkNotNull((Object)var4_6);
                v0 = (EndProcessInstanceCommand)new FinishProcessInstanceCommand(var4_6, var3_4, var5_8, var7_12, var6_10);
                break block6;
            }
            ProcessInstanceEventCollectorService.Companion.getLogger().debug((Function0)new Function0<Object>(processInstance){
                final /* synthetic */ HistoricProcessInstanceEventEntity $processInstance;
                {
                    this.$processInstance = $processInstance;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Unknown end process instance event received " + this.$processInstance;
                }
            });
            v0 = null;
        }
        return v0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/holunda/polyflow/taskpool/collector/process/instance/ProcessInstanceEventCollectorService$Companion;", "Lmu/KLogging;", "()V", "ORDER", "", "polyflow-camunda-bpm-taskpool-collector"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

