/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.polyflow.datapool;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.holunda.polyflow.datapool.DataEntrySenderProperties;
import io.holunda.polyflow.datapool.DataEntrySenderType;
import io.holunda.polyflow.datapool.projector.DataEntryProjectionSupplier;
import io.holunda.polyflow.datapool.projector.DataEntryProjector;
import io.holunda.polyflow.datapool.sender.DataEntryCommandErrorHandler;
import io.holunda.polyflow.datapool.sender.DataEntryCommandSender;
import io.holunda.polyflow.datapool.sender.DataEntryCommandSuccessHandler;
import io.holunda.polyflow.datapool.sender.LoggingCommandErrorHandler;
import io.holunda.polyflow.datapool.sender.LoggingCommandSuccessHandler;
import io.holunda.polyflow.datapool.sender.SimpleDataEntryCommandSender;
import io.holunda.polyflow.spring.ApplicationNameBeanPostProcessor;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@EnableConfigurationProperties(value={DataEntrySenderProperties.class})
@Import(value={ApplicationNameBeanPostProcessor.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J2\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0007J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0007J\b\u0010\u0016\u001a\u00020\u0010H\u0007J\b\u0010\u0017\u001a\u00020\u000eH\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lio/holunda/polyflow/datapool/DataEntrySenderConfiguration;", "", "properties", "Lio/holunda/polyflow/datapool/DataEntrySenderProperties;", "(Lio/holunda/polyflow/datapool/DataEntrySenderProperties;)V", "getProperties", "()Lio/holunda/polyflow/datapool/DataEntrySenderProperties;", "configureSender", "Lio/holunda/polyflow/datapool/sender/DataEntryCommandSender;", "gateway", "Lorg/axonframework/commandhandling/gateway/CommandGateway;", "dataEntryProjector", "Lio/holunda/polyflow/datapool/projector/DataEntryProjector;", "dataEntryCommandSuccessHandler", "Lio/holunda/polyflow/datapool/sender/DataEntryCommandSuccessHandler;", "dataEntryCommandErrorHandler", "Lio/holunda/polyflow/datapool/sender/DataEntryCommandErrorHandler;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "suppliers", "", "Lio/holunda/polyflow/datapool/projector/DataEntryProjectionSupplier;", "loggingDataEntryCommandErrorHandler", "loggingDataEntryCommandSuccessHandler", "polyflow-datapool-sender"})
public final class DataEntrySenderConfiguration {
    @NotNull
    private final DataEntrySenderProperties properties;

    public DataEntrySenderConfiguration(@NotNull DataEntrySenderProperties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.properties = properties;
    }

    @NotNull
    public final DataEntrySenderProperties getProperties() {
        return this.properties;
    }

    @Bean
    @NotNull
    public final DataEntryProjector dataEntryProjector(@NotNull List<? extends DataEntryProjectionSupplier> suppliers) {
        Intrinsics.checkNotNullParameter(suppliers, (String)"suppliers");
        return new DataEntryProjector(suppliers);
    }

    @Bean
    @NotNull
    public final DataEntryCommandSuccessHandler loggingDataEntryCommandSuccessHandler() {
        Logger logger = LoggerFactory.getLogger(DataEntryCommandSender.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        return new LoggingCommandSuccessHandler(logger);
    }

    @Bean
    @NotNull
    public final DataEntryCommandErrorHandler loggingDataEntryCommandErrorHandler() {
        Logger logger = LoggerFactory.getLogger(DataEntryCommandSender.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        return new LoggingCommandErrorHandler(logger);
    }

    @Bean
    @ConditionalOnExpression(value="'${polyflow.integration.sender.data-entry.type}' != 'custom'")
    @NotNull
    public final DataEntryCommandSender configureSender(@NotNull CommandGateway gateway, @NotNull DataEntryProjector dataEntryProjector, @NotNull DataEntryCommandSuccessHandler dataEntryCommandSuccessHandler, @NotNull DataEntryCommandErrorHandler dataEntryCommandErrorHandler, @Qualifier(value="payloadObjectMapper") @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)dataEntryProjector, (String)"dataEntryProjector");
        Intrinsics.checkNotNullParameter((Object)dataEntryCommandSuccessHandler, (String)"dataEntryCommandSuccessHandler");
        Intrinsics.checkNotNullParameter((Object)dataEntryCommandErrorHandler, (String)"dataEntryCommandErrorHandler");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        if (WhenMappings.$EnumSwitchMapping$0[this.properties.getType().ordinal()] != 1) {
            throw new IllegalStateException("Could not initialize sender, used unknown " + this.properties.getType() + " type.");
        }
        return new SimpleDataEntryCommandSender(gateway, this.properties, dataEntryProjector, dataEntryCommandSuccessHandler, dataEntryCommandErrorHandler, objectMapper);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DataEntrySenderType.values().length];
            try {
                nArray[DataEntrySenderType.simple.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

