/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.polyflow.datapool.sender;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.holunda.camunda.taskpool.api.business.AuthorizationChange;
import io.holunda.camunda.taskpool.api.business.CreateOrUpdateDataEntryCommand;
import io.holunda.camunda.taskpool.api.business.DataEntryChange;
import io.holunda.camunda.taskpool.api.business.DataEntryState;
import io.holunda.camunda.taskpool.api.business.DeleteDataEntryCommand;
import io.holunda.camunda.taskpool.api.business.Modification;
import io.holunda.camunda.taskpool.api.business.WithCorrelationsKt;
import io.holunda.camunda.variable.serializer.VariableSerializerKt;
import io.holunda.polyflow.datapool.DataEntrySenderProperties;
import io.holunda.polyflow.datapool.projector.DataEntryProjectionSupplier;
import io.holunda.polyflow.datapool.projector.DataEntryProjector;
import io.holunda.polyflow.datapool.sender.DataEntryCommandErrorHandler;
import io.holunda.polyflow.datapool.sender.DataEntryCommandSender;
import io.holunda.polyflow.datapool.sender.DataEntryCommandSuccessHandler;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.messaging.MetaData;
import org.camunda.bpm.engine.variable.VariableMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016JJ\u0010\u0011\u001a\u00020\u00122\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u00192\n\u0010\u001a\u001a\u00060\u0018j\u0002`\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00182\b\u0010\u001f\u001a\u0004\u0018\u00010\u00182\u0006\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"H\u0016Jt\u0010\u0011\u001a\u00020\u00122\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u00192\n\u0010\u001a\u001a\u00060\u0018j\u0002`\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00182\b\u0010\u001f\u001a\u0004\u0018\u00010\u00182\u0006\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\n\u0010%\u001a\u00060&j\u0002`'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010+\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020,2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lio/holunda/polyflow/datapool/sender/SimpleDataEntryCommandSender;", "Lio/holunda/polyflow/datapool/sender/DataEntryCommandSender;", "gateway", "Lorg/axonframework/commandhandling/gateway/CommandGateway;", "properties", "Lio/holunda/polyflow/datapool/DataEntrySenderProperties;", "dataEntryProjector", "Lio/holunda/polyflow/datapool/projector/DataEntryProjector;", "successHandler", "Lio/holunda/polyflow/datapool/sender/DataEntryCommandSuccessHandler;", "errorHandler", "Lio/holunda/polyflow/datapool/sender/DataEntryCommandErrorHandler;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lorg/axonframework/commandhandling/gateway/CommandGateway;Lio/holunda/polyflow/datapool/DataEntrySenderProperties;Lio/holunda/polyflow/datapool/projector/DataEntryProjector;Lio/holunda/polyflow/datapool/sender/DataEntryCommandSuccessHandler;Lio/holunda/polyflow/datapool/sender/DataEntryCommandErrorHandler;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "logger", "Lorg/slf4j/Logger;", "sendDataEntryChange", "", "command", "Lio/holunda/camunda/taskpool/api/business/CreateOrUpdateDataEntryCommand;", "metaData", "Lorg/axonframework/messaging/MetaData;", "entryType", "", "Lio/holunda/camunda/taskpool/api/business/EntryType;", "entryId", "Lio/holunda/camunda/taskpool/api/business/EntryId;", "payload", "", "name", "description", "type", "state", "Lio/holunda/camunda/taskpool/api/business/DataEntryState;", "modification", "Lio/holunda/camunda/taskpool/api/business/Modification;", "correlations", "Lorg/camunda/bpm/engine/variable/VariableMap;", "Lio/holunda/camunda/taskpool/api/business/CorrelationMap;", "authorizationChanges", "", "Lio/holunda/camunda/taskpool/api/business/AuthorizationChange;", "sendDataEntryDelete", "Lio/holunda/camunda/taskpool/api/business/DeleteDataEntryCommand;", "polyflow-datapool-sender"})
public final class SimpleDataEntryCommandSender
implements DataEntryCommandSender {
    @NotNull
    private final CommandGateway gateway;
    @NotNull
    private final DataEntrySenderProperties properties;
    @NotNull
    private final DataEntryProjector dataEntryProjector;
    @NotNull
    private final DataEntryCommandSuccessHandler successHandler;
    @NotNull
    private final DataEntryCommandErrorHandler errorHandler;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final Logger logger;

    public SimpleDataEntryCommandSender(@NotNull CommandGateway gateway, @NotNull DataEntrySenderProperties properties, @NotNull DataEntryProjector dataEntryProjector, @NotNull DataEntryCommandSuccessHandler successHandler, @NotNull DataEntryCommandErrorHandler errorHandler, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)dataEntryProjector, (String)"dataEntryProjector");
        Intrinsics.checkNotNullParameter((Object)successHandler, (String)"successHandler");
        Intrinsics.checkNotNullParameter((Object)errorHandler, (String)"errorHandler");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.gateway = gateway;
        this.properties = properties;
        this.dataEntryProjector = dataEntryProjector;
        this.successHandler = successHandler;
        this.errorHandler = errorHandler;
        this.objectMapper = objectMapper;
        Logger logger = LoggerFactory.getLogger(DataEntryCommandSender.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @Override
    public void sendDataEntryChange(@NotNull String entryType, @NotNull String entryId, @NotNull Object payload, @NotNull String name, @Nullable String description, @NotNull String type, @NotNull DataEntryState state) {
        Intrinsics.checkNotNullParameter((Object)entryType, (String)"entryType");
        Intrinsics.checkNotNullParameter((Object)entryId, (String)"entryId");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Modification modification = Modification.Companion.now();
        VariableMap variableMap = WithCorrelationsKt.newCorrelations();
        List list = CollectionsKt.emptyList();
        MetaData metaData = MetaData.emptyInstance();
        Intrinsics.checkNotNullExpressionValue((Object)metaData, (String)"emptyInstance(...)");
        this.sendDataEntryChange(entryType, entryId, payload, name, description, type, state, modification, variableMap, list, metaData);
    }

    @Override
    public void sendDataEntryChange(@NotNull String entryType, @NotNull String entryId, @NotNull Object payload, @NotNull String name, @Nullable String description, @NotNull String type, @NotNull DataEntryState state, @NotNull Modification modification, @NotNull VariableMap correlations, @NotNull List<? extends AuthorizationChange> authorizationChanges, @NotNull MetaData metaData) {
        Intrinsics.checkNotNullParameter((Object)entryType, (String)"entryType");
        Intrinsics.checkNotNullParameter((Object)entryId, (String)"entryId");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)modification, (String)"modification");
        Intrinsics.checkNotNullParameter((Object)correlations, (String)"correlations");
        Intrinsics.checkNotNullParameter(authorizationChanges, (String)"authorizationChanges");
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        DataEntryProjectionSupplier dataEntryProjectionSupplier = this.dataEntryProjector.getProjection(entryType);
        Object object = dataEntryProjectionSupplier;
        if (object == null || (object = object.get()) == null || (object = (DataEntryChange)object.apply(entryId, payload)) == null) {
            VariableMap variableMap;
            if (this.properties.getSerializePayload()) {
                variableMap = VariableSerializerKt.serialize((Object)payload, (ObjectMapper)this.objectMapper);
            } else if (payload instanceof VariableMap) {
                variableMap = (VariableMap)payload;
            } else {
                throw new IllegalArgumentException("Property for payload serialization is set to false, expected payload must be VariableMap but it was " + payload.getClass().getCanonicalName());
            }
            VariableMap variableMap2 = variableMap;
            String string = this.properties.getApplicationName();
            object = new DataEntryChange(entryType, entryId, type, string, name, correlations, variableMap2, description, state, modification, authorizationChanges, null, 2048, null);
        }
        CreateOrUpdateDataEntryCommand command = new CreateOrUpdateDataEntryCommand((DataEntryChange)object, null, 2, null);
        this.sendDataEntryChange(command, metaData);
    }

    @Override
    public void sendDataEntryChange(@NotNull CreateOrUpdateDataEntryCommand command, @NotNull MetaData metaData) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        if (this.properties.getEnabled()) {
            CommandMessage message = GenericCommandMessage.asCommandMessage((Object)command).withMetaData((Map)metaData);
            this.gateway.send((Object)message, (arg_0, arg_1) -> SimpleDataEntryCommandSender.sendDataEntryChange$lambda$0(this, arg_0, arg_1));
        } else {
            this.logger.debug("Would have sent change command " + command);
        }
    }

    @Override
    public void sendDataEntryDelete(@NotNull DeleteDataEntryCommand command, @NotNull MetaData metaData) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)metaData, (String)"metaData");
        if (this.properties.getEnabled()) {
            CommandMessage message = GenericCommandMessage.asCommandMessage((Object)command).withMetaData((Map)metaData);
            this.gateway.send((Object)message, (arg_0, arg_1) -> SimpleDataEntryCommandSender.sendDataEntryDelete$lambda$1(this, arg_0, arg_1));
        } else {
            this.logger.debug("Would have sent delete command " + command);
        }
    }

    private static final void sendDataEntryChange$lambda$0(SimpleDataEntryCommandSender this$0, CommandMessage m, CommandResultMessage r) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        if (r.isExceptional()) {
            this$0.errorHandler.apply(m, r);
        } else {
            this$0.successHandler.apply(m, r);
        }
    }

    private static final void sendDataEntryDelete$lambda$1(SimpleDataEntryCommandSender this$0, CommandMessage m, CommandResultMessage r) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        if (r.isExceptional()) {
            this$0.errorHandler.apply(m, r);
        } else {
            this$0.successHandler.apply(m, r);
        }
    }
}

