/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.polyflow.taskpool.sender;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.holunda.camunda.taskpool.api.task.EngineTaskCommand;
import io.holunda.polyflow.taskpool.sender.GenericTaskPublisher;
import io.holunda.polyflow.taskpool.sender.SenderProperties;
import io.holunda.polyflow.taskpool.sender.SenderType;
import io.holunda.polyflow.taskpool.sender.gateway.AxonCommandListGateway;
import io.holunda.polyflow.taskpool.sender.gateway.CommandErrorHandler;
import io.holunda.polyflow.taskpool.sender.gateway.CommandListGateway;
import io.holunda.polyflow.taskpool.sender.gateway.CommandSuccessHandler;
import io.holunda.polyflow.taskpool.sender.gateway.LoggingTaskCommandErrorHandler;
import io.holunda.polyflow.taskpool.sender.gateway.LoggingTaskCommandSuccessHandler;
import io.holunda.polyflow.taskpool.sender.process.definition.ProcessDefinitionCommandSender;
import io.holunda.polyflow.taskpool.sender.process.definition.SimpleProcessDefinitionCommandSender;
import io.holunda.polyflow.taskpool.sender.process.instance.ProcessInstanceCommandSender;
import io.holunda.polyflow.taskpool.sender.process.instance.SimpleProcessInstanceCommandSender;
import io.holunda.polyflow.taskpool.sender.process.variable.ProcessVariableCommandSender;
import io.holunda.polyflow.taskpool.sender.process.variable.SimpleProcessVariableCommandSender;
import io.holunda.polyflow.taskpool.sender.process.variable.TxAwareAccumulatingProcessVariableCommandSender;
import io.holunda.polyflow.taskpool.sender.task.DirectTxAwareAccumulatingEngineTaskCommandSender;
import io.holunda.polyflow.taskpool.sender.task.EngineTaskCommandSender;
import io.holunda.polyflow.taskpool.sender.task.SimpleEngineTaskCommandSender;
import io.holunda.polyflow.taskpool.sender.task.accumulator.ProjectingCommandAccumulator;
import java.util.List;
import javax.annotation.PostConstruct;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={SenderProperties.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\b\u0010\u0013\u001a\u00020\u000eH\u0007J\b\u0010\u0014\u001a\u00020\fH\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\bH\u0007J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\bH\u0007J\u001a\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\b2\b\b\u0001\u0010\u001e\u001a\u00020\u001fH\u0007J\u001a\u0010 \u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\b2\b\b\u0001\u0010\u001e\u001a\u00020\u001fH\u0007J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\bH\u0007J.\u0010#\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0%\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0%0$j\u0002`'2\b\b\u0001\u0010\u001e\u001a\u00020\u001fH\u0007J4\u0010(\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\b2\"\u0010)\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0%\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0%0$j\u0002`'H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lio/holunda/polyflow/taskpool/sender/SenderConfiguration;", "", "senderProperties", "Lio/holunda/polyflow/taskpool/sender/SenderProperties;", "(Lio/holunda/polyflow/taskpool/sender/SenderProperties;)V", "logger", "Lorg/slf4j/Logger;", "defaultCommandListGateway", "Lio/holunda/polyflow/taskpool/sender/gateway/CommandListGateway;", "commandGateway", "Lorg/axonframework/commandhandling/gateway/CommandGateway;", "commandSuccessHandler", "Lio/holunda/polyflow/taskpool/sender/gateway/CommandSuccessHandler;", "commandErrorHandler", "Lio/holunda/polyflow/taskpool/sender/gateway/CommandErrorHandler;", "genericTaskPublisher", "Lio/holunda/polyflow/taskpool/sender/GenericTaskPublisher;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "loggingTaskCommandErrorHandler", "loggingTaskCommandSuccessHandler", "printSenderConfiguration", "", "processDefinitionCommandSender", "Lio/holunda/polyflow/taskpool/sender/process/definition/ProcessDefinitionCommandSender;", "commandListGateway", "processInstanceCommandSender", "Lio/holunda/polyflow/taskpool/sender/process/instance/ProcessInstanceCommandSender;", "processVariableCommandSender", "Lio/holunda/polyflow/taskpool/sender/process/variable/ProcessVariableCommandSender;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "simpleProcessVariableCommandSender", "simpleTaskCommandSender", "Lio/holunda/polyflow/taskpool/sender/task/EngineTaskCommandSender;", "taskCommandAccumulator", "Lkotlin/Function1;", "", "Lio/holunda/camunda/taskpool/api/task/EngineTaskCommand;", "Lio/holunda/polyflow/taskpool/sender/task/accumulator/EngineTaskCommandAccumulator;", "txAwareTaskCommandSender", "accumulator", "polyflow-taskpool-sender"})
public final class SenderConfiguration {
    @NotNull
    private final SenderProperties senderProperties;
    @NotNull
    private final Logger logger;

    public SenderConfiguration(@NotNull SenderProperties senderProperties) {
        Intrinsics.checkNotNullParameter((Object)senderProperties, (String)"senderProperties");
        this.senderProperties = senderProperties;
        Logger logger = LoggerFactory.getLogger(SenderConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(SenderConfiguration::class.java)");
        this.logger = logger;
    }

    @Bean
    @NotNull
    public final GenericTaskPublisher genericTaskPublisher(@NotNull ApplicationEventPublisher applicationEventPublisher) {
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        return new GenericTaskPublisher(applicationEventPublisher);
    }

    @Bean
    @NotNull
    public final Function1<List<? extends EngineTaskCommand>, List<EngineTaskCommand>> taskCommandAccumulator(@Qualifier(value="payloadObjectMapper") @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        return new ProjectingCommandAccumulator(objectMapper, this.senderProperties.getTask().getSerializePayload(), false);
    }

    @Bean
    @ConditionalOnMissingBean(value={CommandListGateway.class})
    @NotNull
    public final CommandListGateway defaultCommandListGateway(@NotNull CommandGateway commandGateway, @NotNull SenderProperties senderProperties, @NotNull CommandSuccessHandler commandSuccessHandler, @NotNull CommandErrorHandler commandErrorHandler) {
        Intrinsics.checkNotNullParameter((Object)commandGateway, (String)"commandGateway");
        Intrinsics.checkNotNullParameter((Object)senderProperties, (String)"senderProperties");
        Intrinsics.checkNotNullParameter((Object)commandSuccessHandler, (String)"commandSuccessHandler");
        Intrinsics.checkNotNullParameter((Object)commandErrorHandler, (String)"commandErrorHandler");
        return new AxonCommandListGateway(commandGateway, senderProperties, commandSuccessHandler, commandErrorHandler);
    }

    @Bean
    @ConditionalOnProperty(value={"polyflow.integration.sender.task.type"}, havingValue="simple", matchIfMissing=false)
    @NotNull
    public final EngineTaskCommandSender simpleTaskCommandSender(@NotNull CommandListGateway commandListGateway) {
        Intrinsics.checkNotNullParameter((Object)commandListGateway, (String)"commandListGateway");
        return new SimpleEngineTaskCommandSender(commandListGateway, this.senderProperties);
    }

    @Bean
    @ConditionalOnProperty(value={"polyflow.integration.sender.task.type"}, havingValue="tx", matchIfMissing=true)
    @NotNull
    public final EngineTaskCommandSender txAwareTaskCommandSender(@NotNull CommandListGateway commandListGateway, @NotNull Function1<? super List<? extends EngineTaskCommand>, ? extends List<? extends EngineTaskCommand>> accumulator) {
        Intrinsics.checkNotNullParameter((Object)commandListGateway, (String)"commandListGateway");
        Intrinsics.checkNotNullParameter(accumulator, (String)"accumulator");
        return new DirectTxAwareAccumulatingEngineTaskCommandSender(commandListGateway, accumulator, this.senderProperties);
    }

    @Bean
    @ConditionalOnProperty(value={"polyflow.integration.sender.process-definition.type"}, havingValue="simple", matchIfMissing=true)
    @NotNull
    public final ProcessDefinitionCommandSender processDefinitionCommandSender(@NotNull CommandListGateway commandListGateway) {
        Intrinsics.checkNotNullParameter((Object)commandListGateway, (String)"commandListGateway");
        if (WhenMappings.$EnumSwitchMapping$0[this.senderProperties.getProcessDefinition().getType().ordinal()] != 1) {
            throw new IllegalStateException("Could not initialize definition sender, used unknown " + this.senderProperties.getProcessDefinition().getType() + " type.");
        }
        return new SimpleProcessDefinitionCommandSender(commandListGateway, this.senderProperties);
    }

    @Bean
    @ConditionalOnProperty(value={"polyflow.integration.sender.process-instance.type"}, havingValue="simple", matchIfMissing=true)
    @NotNull
    public final ProcessInstanceCommandSender processInstanceCommandSender(@NotNull CommandListGateway commandListGateway) {
        Intrinsics.checkNotNullParameter((Object)commandListGateway, (String)"commandListGateway");
        if (WhenMappings.$EnumSwitchMapping$0[this.senderProperties.getProcessInstance().getType().ordinal()] != 1) {
            throw new IllegalStateException("Could not initialize instance sender, used unknown " + this.senderProperties.getProcessInstance().getType() + " type.");
        }
        return new SimpleProcessInstanceCommandSender(commandListGateway, this.senderProperties);
    }

    @Bean
    @ConditionalOnProperty(value={"polyflow.integration.sender.process-variable.type"}, havingValue="simple")
    @NotNull
    public final ProcessVariableCommandSender simpleProcessVariableCommandSender(@NotNull CommandListGateway commandListGateway, @Qualifier(value="payloadObjectMapper") @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)commandListGateway, (String)"commandListGateway");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        return new SimpleProcessVariableCommandSender(commandListGateway, this.senderProperties, objectMapper);
    }

    @Bean
    @ConditionalOnProperty(value={"polyflow.integration.sender.process-variable.type"}, havingValue="tx", matchIfMissing=true)
    @NotNull
    public final ProcessVariableCommandSender processVariableCommandSender(@NotNull CommandListGateway commandListGateway, @Qualifier(value="payloadObjectMapper") @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)commandListGateway, (String)"commandListGateway");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        return new TxAwareAccumulatingProcessVariableCommandSender(commandListGateway, this.senderProperties, objectMapper);
    }

    @PostConstruct
    public final void printSenderConfiguration() {
        if (this.senderProperties.getTask().getEnabled()) {
            this.logger.info("SENDER-011: Taskpool task commands will be distributed over command bus.");
        } else {
            this.logger.info("SENDER-012: Taskpool task command distribution is disabled by property.");
        }
        if (this.senderProperties.getProcessDefinition().getEnabled()) {
            this.logger.info("SENDER-013: Taskpool process definition commands will be distributed over command bus.");
        } else {
            this.logger.info("SENDER-014: Taskpool process definition command distribution is disabled by property.");
        }
        if (this.senderProperties.getProcessInstance().getEnabled()) {
            this.logger.info("SENDER-015: Taskpool process instance commands will be distributed over command bus.");
        } else {
            this.logger.info("SENDER-016: Taskpool process instance command distribution is disabled by property.");
        }
        if (this.senderProperties.getProcessVariable().getEnabled()) {
            this.logger.info("SENDER-017: Taskpool process variable commands will be distributed over command bus.");
        } else {
            this.logger.info("SENDER-018: Taskpool process variable command distribution is disabled by property.");
        }
    }

    @Bean
    @ConditionalOnMissingBean(value={CommandSuccessHandler.class})
    @NotNull
    public final CommandSuccessHandler loggingTaskCommandSuccessHandler() {
        return new LoggingTaskCommandSuccessHandler(this.logger);
    }

    @Bean
    @ConditionalOnMissingBean(value={CommandErrorHandler.class})
    @NotNull
    public final CommandErrorHandler loggingTaskCommandErrorHandler() {
        return new LoggingTaskCommandErrorHandler(this.logger);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SenderType.values().length];
            try {
                nArray[SenderType.simple.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

