/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.polyflow.taskpool.sender.gateway;

import io.holunda.polyflow.taskpool.sender.SenderProperties;
import io.holunda.polyflow.taskpool.sender.gateway.CommandErrorHandler;
import io.holunda.polyflow.taskpool.sender.gateway.CommandListGateway;
import io.holunda.polyflow.taskpool.sender.gateway.CommandSuccessHandler;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/holunda/polyflow/taskpool/sender/gateway/AxonCommandListGateway;", "Lio/holunda/polyflow/taskpool/sender/gateway/CommandListGateway;", "commandGateway", "Lorg/axonframework/commandhandling/gateway/CommandGateway;", "senderProperties", "Lio/holunda/polyflow/taskpool/sender/SenderProperties;", "commandSuccessHandler", "Lio/holunda/polyflow/taskpool/sender/gateway/CommandSuccessHandler;", "commandErrorHandler", "Lio/holunda/polyflow/taskpool/sender/gateway/CommandErrorHandler;", "(Lorg/axonframework/commandhandling/gateway/CommandGateway;Lio/holunda/polyflow/taskpool/sender/SenderProperties;Lio/holunda/polyflow/taskpool/sender/gateway/CommandSuccessHandler;Lio/holunda/polyflow/taskpool/sender/gateway/CommandErrorHandler;)V", "sendToGateway", "", "commands", "", "", "Companion", "polyflow-taskpool-sender"})
public final class AxonCommandListGateway
implements CommandListGateway {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommandGateway commandGateway;
    @NotNull
    private final SenderProperties senderProperties;
    @NotNull
    private final CommandSuccessHandler commandSuccessHandler;
    @NotNull
    private final CommandErrorHandler commandErrorHandler;

    public AxonCommandListGateway(@NotNull CommandGateway commandGateway, @NotNull SenderProperties senderProperties, @NotNull CommandSuccessHandler commandSuccessHandler, @NotNull CommandErrorHandler commandErrorHandler) {
        Intrinsics.checkNotNullParameter((Object)commandGateway, (String)"commandGateway");
        Intrinsics.checkNotNullParameter((Object)senderProperties, (String)"senderProperties");
        Intrinsics.checkNotNullParameter((Object)commandSuccessHandler, (String)"commandSuccessHandler");
        Intrinsics.checkNotNullParameter((Object)commandErrorHandler, (String)"commandErrorHandler");
        this.commandGateway = commandGateway;
        this.senderProperties = senderProperties;
        this.commandSuccessHandler = commandSuccessHandler;
        this.commandErrorHandler = commandErrorHandler;
    }

    @Override
    public void sendToGateway(@NotNull List<? extends Object> commands) {
        Intrinsics.checkNotNullParameter(commands, (String)"commands");
        if (!((Collection)commands).isEmpty()) {
            Object nextCommand = CollectionsKt.first(commands);
            List<? extends Object> remainingCommands = commands.subList(1, commands.size());
            if (this.senderProperties.getEnabled()) {
                this.commandGateway.send(nextCommand, (arg_0, arg_1) -> AxonCommandListGateway.sendToGateway$lambda$0(this, remainingCommands, arg_0, arg_1));
            } else {
                Companion.getLogger().debug("SENDER-001: Sending command over gateway disabled by property. Would have sent command " + nextCommand);
                this.sendToGateway(remainingCommands);
            }
        }
    }

    private static final void sendToGateway$lambda$0(AxonCommandListGateway this$0, List $remainingCommands, CommandMessage commandMessage, CommandResultMessage commandResultMessage) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$remainingCommands, (String)"$remainingCommands");
        Intrinsics.checkNotNullParameter((Object)commandMessage, (String)"commandMessage");
        Intrinsics.checkNotNullParameter((Object)commandResultMessage, (String)"commandResultMessage");
        if (commandResultMessage.isExceptional()) {
            this$0.commandErrorHandler.apply(commandMessage, commandResultMessage);
        } else {
            this$0.commandSuccessHandler.apply(commandMessage, commandResultMessage);
        }
        this$0.sendToGateway($remainingCommands);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/holunda/polyflow/taskpool/sender/gateway/AxonCommandListGateway$Companion;", "Lmu/KLogging;", "()V", "polyflow-taskpool-sender"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

