/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.polyflow.view.query.data;

import io.holunda.polyflow.view.DataEntry;
import io.holunda.polyflow.view.auth.User;
import io.holunda.polyflow.view.filter.DataEntryPredicateWrapper;
import io.holunda.polyflow.view.filter.FilterKt;
import io.holunda.polyflow.view.query.FilterQuery;
import io.holunda.polyflow.view.query.PageableSortableQuery;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B=\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0002H\u0016J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000f\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u00c6\u0003JC\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u00c6\u0001J\u0013\u0010&\u001a\u00020\u001e2\b\u0010'\u001a\u0004\u0018\u00010(H\u00d6\u0003J\t\u0010)\u001a\u00020\u0007H\u00d6\u0001J\t\u0010*\u001a\u00020\nH\u00d6\u0001R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006+"}, d2={"Lio/holunda/polyflow/view/query/data/DataEntriesForUserQuery;", "Lio/holunda/polyflow/view/query/FilterQuery;", "Lio/holunda/polyflow/view/DataEntry;", "Lio/holunda/polyflow/view/query/PageableSortableQuery;", "user", "Lio/holunda/polyflow/view/auth/User;", "page", "", "size", "sort", "", "filters", "", "(Lio/holunda/polyflow/view/auth/User;IILjava/lang/String;Ljava/util/List;)V", "getFilters", "()Ljava/util/List;", "getPage", "()I", "predicates", "Lio/holunda/polyflow/view/filter/DataEntryPredicateWrapper;", "getPredicates", "()Lio/holunda/polyflow/view/filter/DataEntryPredicateWrapper;", "predicates$delegate", "Lkotlin/Lazy;", "getSize", "getSort", "()Ljava/lang/String;", "getUser", "()Lio/holunda/polyflow/view/auth/User;", "applyFilter", "", "element", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "toString", "polyflow-view-api"})
@SourceDebugExtension(value={"SMAP\nDataEntriesForUserQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataEntriesForUserQuery.kt\nio/holunda/polyflow/view/query/data/DataEntriesForUserQuery\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,40:1\n1747#2,3:41\n*S KotlinDebug\n*F\n+ 1 DataEntriesForUserQuery.kt\nio/holunda/polyflow/view/query/data/DataEntriesForUserQuery\n*L\n37#1:41,3\n*E\n"})
public final class DataEntriesForUserQuery
implements FilterQuery<DataEntry>,
PageableSortableQuery {
    @NotNull
    private final User user;
    private final int page;
    private final int size;
    @Nullable
    private final String sort;
    @NotNull
    private final List<String> filters;
    @NotNull
    private final Lazy predicates$delegate;

    public DataEntriesForUserQuery(@NotNull User user, int page, int size, @Nullable String sort, @NotNull List<String> filters) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        this.user = user;
        this.page = page;
        this.size = size;
        this.sort = sort;
        this.filters = filters;
        this.predicates$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DataEntryPredicateWrapper>(this){
            final /* synthetic */ DataEntriesForUserQuery this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DataEntryPredicateWrapper invoke() {
                return FilterKt.createDataEntryPredicates(FilterKt.toCriteria(this.this$0.getFilters()));
            }
        }));
    }

    public /* synthetic */ DataEntriesForUserQuery(User user, int n, int n2, String string, List list, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = Integer.MAX_VALUE;
        }
        if ((n3 & 8) != 0) {
            string = null;
        }
        if ((n3 & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(user, n, n2, string, list);
    }

    @NotNull
    public final User getUser() {
        return this.user;
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    @Nullable
    public String getSort() {
        return this.sort;
    }

    @NotNull
    public final List<String> getFilters() {
        return this.filters;
    }

    private final DataEntryPredicateWrapper getPredicates() {
        Lazy lazy = this.predicates$delegate;
        return (DataEntryPredicateWrapper)lazy.getValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean applyFilter(@NotNull DataEntry element) {
        String candidateGroup;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!FilterKt.filterByPredicate(element, this.getPredicates())) return false;
        if (element.getAuthorizedUsers().contains(this.user.getUsername())) return true;
        Iterable $this$any$iv = element.getAuthorizedGroups();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            candidateGroup = (String)element$iv;
            boolean bl = false;
        } while (!this.user.getGroups().contains(candidateGroup));
        return true;
    }

    @Override
    public <C extends KClass<?>> void sanitizeSort(@NotNull C clazz) {
        PageableSortableQuery.DefaultImpls.sanitizeSort((PageableSortableQuery)this, clazz);
    }

    @Override
    public void sanitizeSort(@NotNull Set<String> fieldNames) {
        PageableSortableQuery.DefaultImpls.sanitizeSort((PageableSortableQuery)this, fieldNames);
    }

    @NotNull
    public final User component1() {
        return this.user;
    }

    public final int component2() {
        return this.page;
    }

    public final int component3() {
        return this.size;
    }

    @Nullable
    public final String component4() {
        return this.sort;
    }

    @NotNull
    public final List<String> component5() {
        return this.filters;
    }

    @NotNull
    public final DataEntriesForUserQuery copy(@NotNull User user, int page, int size, @Nullable String sort, @NotNull List<String> filters) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        return new DataEntriesForUserQuery(user, page, size, sort, filters);
    }

    public static /* synthetic */ DataEntriesForUserQuery copy$default(DataEntriesForUserQuery dataEntriesForUserQuery, User user, int n, int n2, String string, List list, int n3, Object object) {
        if ((n3 & 1) != 0) {
            user = dataEntriesForUserQuery.user;
        }
        if ((n3 & 2) != 0) {
            n = dataEntriesForUserQuery.page;
        }
        if ((n3 & 4) != 0) {
            n2 = dataEntriesForUserQuery.size;
        }
        if ((n3 & 8) != 0) {
            string = dataEntriesForUserQuery.sort;
        }
        if ((n3 & 0x10) != 0) {
            list = dataEntriesForUserQuery.filters;
        }
        return dataEntriesForUserQuery.copy(user, n, n2, string, list);
    }

    @NotNull
    public String toString() {
        return "DataEntriesForUserQuery(user=" + this.user + ", page=" + this.page + ", size=" + this.size + ", sort=" + this.sort + ", filters=" + this.filters + ")";
    }

    public int hashCode() {
        int result = this.user.hashCode();
        result = result * 31 + Integer.hashCode(this.page);
        result = result * 31 + Integer.hashCode(this.size);
        result = result * 31 + (this.sort == null ? 0 : this.sort.hashCode());
        result = result * 31 + ((Object)this.filters).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DataEntriesForUserQuery)) {
            return false;
        }
        DataEntriesForUserQuery dataEntriesForUserQuery = (DataEntriesForUserQuery)other;
        if (!Intrinsics.areEqual((Object)this.user, (Object)dataEntriesForUserQuery.user)) {
            return false;
        }
        if (this.page != dataEntriesForUserQuery.page) {
            return false;
        }
        if (this.size != dataEntriesForUserQuery.size) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sort, (Object)dataEntriesForUserQuery.sort)) {
            return false;
        }
        return Intrinsics.areEqual(this.filters, dataEntriesForUserQuery.filters);
    }
}

