/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.polyflow.view.jpa;

import io.holunda.camunda.taskpool.api.process.definition.ProcessDefinitionRegisteredEvent;
import io.holunda.polyflow.view.ProcessDefinition;
import io.holunda.polyflow.view.jpa.JpaPolyflowViewProcessDefinitionService;
import io.holunda.polyflow.view.jpa.PolyflowJpaViewProperties;
import io.holunda.polyflow.view.jpa.StoredItem;
import io.holunda.polyflow.view.jpa.auth.AuthorizationPrincipal;
import io.holunda.polyflow.view.jpa.process.ConverterExtKt;
import io.holunda.polyflow.view.jpa.process.ProcessDefinitionEntity;
import io.holunda.polyflow.view.jpa.process.ProcessDefinitionRepository;
import io.holunda.polyflow.view.jpa.update.QueryEmitterExtKt;
import io.holunda.polyflow.view.query.process.ProcessDefinitionApi;
import io.holunda.polyflow.view.query.process.ProcessDefinitionsStartableByUserQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogging;
import org.axonframework.config.ProcessingGroup;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.queryhandling.QueryHandler;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@ProcessingGroup(value="io.holunda.polyflow.view.jpa.service.process.definition")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0012J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0018\u001a\u00020\u001bH\u0017R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lio/holunda/polyflow/view/jpa/JpaPolyflowViewProcessDefinitionService;", "Lio/holunda/polyflow/view/query/process/ProcessDefinitionApi;", "processDefinitionRepository", "Lio/holunda/polyflow/view/jpa/process/ProcessDefinitionRepository;", "queryUpdateEmitter", "Lorg/axonframework/queryhandling/QueryUpdateEmitter;", "polyflowJpaViewProperties", "Lio/holunda/polyflow/view/jpa/PolyflowJpaViewProperties;", "(Lio/holunda/polyflow/view/jpa/process/ProcessDefinitionRepository;Lorg/axonframework/queryhandling/QueryUpdateEmitter;Lio/holunda/polyflow/view/jpa/PolyflowJpaViewProperties;)V", "getPolyflowJpaViewProperties", "()Lio/holunda/polyflow/view/jpa/PolyflowJpaViewProperties;", "getProcessDefinitionRepository", "()Lio/holunda/polyflow/view/jpa/process/ProcessDefinitionRepository;", "getQueryUpdateEmitter", "()Lorg/axonframework/queryhandling/QueryUpdateEmitter;", "emitProcessDefinitionUpdate", "", "entity", "Lio/holunda/polyflow/view/jpa/process/ProcessDefinitionEntity;", "isDisabledByProperty", "", "on", "event", "Lio/holunda/camunda/taskpool/api/process/definition/ProcessDefinitionRegisteredEvent;", "query", "", "Lio/holunda/polyflow/view/ProcessDefinition;", "Lio/holunda/polyflow/view/query/process/ProcessDefinitionsStartableByUserQuery;", "Companion", "polyflow-view-jpa"})
@SourceDebugExtension(value={"SMAP\nJpaPolyflowViewProcessDefinitionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpaPolyflowViewProcessDefinitionService.kt\nio/holunda/polyflow/view/jpa/JpaPolyflowViewProcessDefinitionService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1549#2:73\n1620#2,3:74\n1549#2:77\n1620#2,3:78\n*S KotlinDebug\n*F\n+ 1 JpaPolyflowViewProcessDefinitionService.kt\nio/holunda/polyflow/view/jpa/JpaPolyflowViewProcessDefinitionService\n*L\n41#1:73\n41#1:74,3\n42#1:77\n42#1:78,3\n*E\n"})
public class JpaPolyflowViewProcessDefinitionService
implements ProcessDefinitionApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProcessDefinitionRepository processDefinitionRepository;
    @NotNull
    private final QueryUpdateEmitter queryUpdateEmitter;
    @NotNull
    private final PolyflowJpaViewProperties polyflowJpaViewProperties;
    @NotNull
    public static final String PROCESSING_GROUP = "io.holunda.polyflow.view.jpa.service.process.definition";

    public JpaPolyflowViewProcessDefinitionService(@NotNull ProcessDefinitionRepository processDefinitionRepository, @NotNull QueryUpdateEmitter queryUpdateEmitter, @NotNull PolyflowJpaViewProperties polyflowJpaViewProperties) {
        Intrinsics.checkNotNullParameter((Object)processDefinitionRepository, (String)"processDefinitionRepository");
        Intrinsics.checkNotNullParameter((Object)queryUpdateEmitter, (String)"queryUpdateEmitter");
        Intrinsics.checkNotNullParameter((Object)polyflowJpaViewProperties, (String)"polyflowJpaViewProperties");
        this.processDefinitionRepository = processDefinitionRepository;
        this.queryUpdateEmitter = queryUpdateEmitter;
        this.polyflowJpaViewProperties = polyflowJpaViewProperties;
    }

    @NotNull
    public ProcessDefinitionRepository getProcessDefinitionRepository() {
        return this.processDefinitionRepository;
    }

    @NotNull
    public QueryUpdateEmitter getQueryUpdateEmitter() {
        return this.queryUpdateEmitter;
    }

    @NotNull
    public PolyflowJpaViewProperties getPolyflowJpaViewProperties() {
        return this.polyflowJpaViewProperties;
    }

    @QueryHandler
    @NotNull
    public List<ProcessDefinition> query(@NotNull ProcessDefinitionsStartableByUserQuery query2) {
        ProcessDefinitionEntity it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        Iterable iterable = query2.getUser().getGroups();
        Collection<ProcessDefinition> collection = SetsKt.setOf((Object)AuthorizationPrincipal.Companion.user(query2.getUser().getUsername()));
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(AuthorizationPrincipal.Companion.group((String)((Object)it)));
        }
        Set authorizedPrincipals = SetsKt.plus((Set)collection, (Iterable)((List)destination$iv$iv));
        List list = this.getProcessDefinitionRepository().findAll(ProcessDefinitionRepository.Companion.isStarterAuthorizedFor(authorizedPrincipals));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"processDefinitionReposit\u2026or(authorizedPrincipals))");
        $this$map$iv = list;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ProcessDefinitionEntity)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(ConverterExtKt.toProcessDefinition(it));
        }
        return (List)destination$iv$iv;
    }

    @EventHandler
    public void on(@NotNull ProcessDefinitionRegisteredEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isDisabledByProperty()) {
            return;
        }
        Object object = this.getProcessDefinitionRepository().save(ConverterExtKt.toEntity(event));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"processDefinitionReposit\u2026   event.toEntity()\n    )");
        ProcessDefinitionEntity entity2 = (ProcessDefinitionEntity)object;
        this.emitProcessDefinitionUpdate(entity2);
    }

    private void emitProcessDefinitionUpdate(ProcessDefinitionEntity entity2) {
        QueryEmitterExtKt.updateProcessDefinitionQuery(this.getQueryUpdateEmitter(), ConverterExtKt.toProcessDefinition(entity2));
    }

    private boolean isDisabledByProperty() {
        boolean bl;
        boolean it = bl = !this.getPolyflowJpaViewProperties().getStoredItems().contains((Object)StoredItem.PROCESS_DEFINITION);
        boolean bl2 = false;
        if (it) {
            Companion.getLogger().debug((Function0)isDisabledByProperty.1.1.INSTANCE);
        }
        return bl;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/holunda/polyflow/view/jpa/JpaPolyflowViewProcessDefinitionService$Companion;", "Lmu/KLogging;", "()V", "PROCESSING_GROUP", "", "polyflow-view-jpa"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

