/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.camunda.bpm.extension.jgiven;

import com.tngtech.jgiven.Stage;
import com.tngtech.jgiven.annotation.As;
import com.tngtech.jgiven.annotation.ExpectedScenarioState;
import com.tngtech.jgiven.annotation.Hidden;
import com.tngtech.jgiven.annotation.Quoted;
import com.tngtech.jgiven.annotation.ScenarioState;
import io.holunda.camunda.bpm.extension.jgiven.JGivenProcessStage;
import io.holunda.camunda.bpm.extension.jgiven.formatter.QuotedVarargs;
import io.toolisticon.testing.jgiven.JGivenKotlinKt;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.impl.persistence.entity.TimerEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.assertions.bpmn.BpmnAwareTests;
import org.camunda.bpm.engine.test.assertions.bpmn.JobAssert;
import org.camunda.bpm.engine.test.assertions.bpmn.ProcessInstanceAssert;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.jetbrains.annotations.NotNull;

@JGivenProcessStage
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0017\u0018\u0000*\u0014\b\u0000\u0010\u0001*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0000*\u000e\b\u0001\u0010\u0002*\b\u0012\u0004\u0012\u00020\u00040\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\u0013\u001a\u00028\u00002\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0017\u00a2\u0006\u0002\u0010\u0016J!\u0010\u0017\u001a\u00028\u00002\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0017\u00a2\u0006\u0002\u0010\u001aJ+\u0010\u0017\u001a\u00028\u00002\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0017\u00a2\u0006\u0002\u0010\u001dJ\r\u0010\u001e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001fJ!\u0010\u001e\u001a\u00028\u00002\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150!\"\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\"J!\u0010#\u001a\u00028\u00002\b\b\u0001\u0010$\u001a\u00020\u00152\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0017\u00a2\u0006\u0002\u0010\u001aJ\r\u0010%\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001fJ\r\u0010&\u001a\u00028\u0000H\u0017\u00a2\u0006\u0002\u0010\u001fJ!\u0010&\u001a\u00028\u00002\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150!\"\u00020\u0015H\u0017\u00a2\u0006\u0002\u0010\"J#\u0010'\u001a\u00028\u00002\u0014\b\u0001\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150!\"\u00020\u0015H\u0017\u00a2\u0006\u0002\u0010\"J#\u0010)\u001a\u00028\u00002\u0014\b\u0001\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150!\"\u00020\u0015H\u0017\u00a2\u0006\u0002\u0010\"J\u0017\u0010*\u001a\u00028\u00002\b\b\u0001\u0010+\u001a\u00020\u0015H\u0017\u00a2\u0006\u0002\u0010\u0016J\r\u0010,\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001fJ#\u0010-\u001a\u00028\u00002\u0014\b\u0001\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150!\"\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\"J#\u0010.\u001a\u00028\u00002\u0014\b\u0001\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150!\"\u00020\u0015H\u0017\u00a2\u0006\u0002\u0010\"J\u0017\u0010.\u001a\u00028\u00002\b\b\u0001\u0010 \u001a\u00020\u0015H\u0017\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010/\u001a\u00028\u00002\u0006\u00100\u001a\u000201H\u0017\u00a2\u0006\u0002\u00102J\u0015\u00103\u001a\u00028\u00002\u0006\u00104\u001a\u000205H\u0017\u00a2\u0006\u0002\u00106J\u0015\u00107\u001a\u00028\u00002\u0006\u00104\u001a\u000205H\u0017\u00a2\u0006\u0002\u00106J\u0015\u00108\u001a\u00028\u00002\u0006\u00104\u001a\u000205H\u0017\u00a2\u0006\u0002\u00106J\u0015\u00109\u001a\u00028\u00002\u0006\u00104\u001a\u000205H\u0017\u00a2\u0006\u0002\u00106J\u0017\u0010:\u001a\u00028\u00002\b\b\u0001\u0010;\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0017\u0010<\u001a\u00028\u00002\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0017\u00a2\u0006\u0002\u0010=J!\u0010<\u001a\u00028\u00002\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0003\u0010\u001b\u001a\u00020\u001cH\u0017\u00a2\u0006\u0002\u0010>J\u001d\u0010?\u001a\u00028\u00002\u000e\b\u0001\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00150!H\u0016\u00a2\u0006\u0002\u0010\"J\u001d\u0010A\u001a\u00028\u00002\u000e\b\u0001\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00150!H\u0016\u00a2\u0006\u0002\u0010\"J!\u0010C\u001a\u00028\u00002\b\b\u0002\u0010D\u001a\u0002052\b\b\u0002\u0010E\u001a\u000205H\u0017\u00a2\u0006\u0002\u0010FJ\u001d\u0010G\u001a\u00028\u00002\u0006\u0010H\u001a\u00020\u00152\u0006\u0010I\u001a\u00020JH\u0016\u00a2\u0006\u0002\u0010KJ\u001d\u0010L\u001a\u00028\u00002\u0006\u0010H\u001a\u00020\u00152\u0006\u0010M\u001a\u00020JH\u0016\u00a2\u0006\u0002\u0010KJ\u0017\u0010N\u001a\u00028\u00002\b\b\u0001\u0010O\u001a\u00020\u0015H\u0017\u00a2\u0006\u0002\u0010\u0016J!\u0010P\u001a\u00028\u00002\b\b\u0001\u0010O\u001a\u00020\u00152\b\b\u0001\u0010Q\u001a\u00020RH\u0017\u00a2\u0006\u0002\u0010SJ\u001d\u0010T\u001a\u00028\u00002\u000e\b\u0001\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00150!H\u0017\u00a2\u0006\u0002\u0010\"R\u001e\u0010\u0007\u001a\u00020\b8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR \u0010\r\u001a\u00028\u00018\u0016@\u0016X\u0097.\u00a2\u0006\u0010\n\u0002\u0010\u0012\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006V"}, d2={"Lio/holunda/camunda/bpm/extension/jgiven/ProcessStage;", "SELF", "PROCESS_BEAN", "Ljava/util/function/Supplier;", "Lorg/camunda/bpm/engine/runtime/ProcessInstance;", "Lcom/tngtech/jgiven/Stage;", "()V", "camunda", "Lorg/camunda/bpm/engine/ProcessEngine;", "getCamunda", "()Lorg/camunda/bpm/engine/ProcessEngine;", "setCamunda", "(Lorg/camunda/bpm/engine/ProcessEngine;)V", "processInstanceSupplier", "getProcessInstanceSupplier", "()Ljava/util/function/Supplier;", "setProcessInstanceSupplier", "(Ljava/util/function/Supplier;)V", "Ljava/util/function/Supplier;", "external_task_exists", "topicName", "", "(Ljava/lang/String;)Lio/holunda/camunda/bpm/extension/jgiven/ProcessStage;", "external_task_is_completed", "variables", "Lorg/camunda/bpm/engine/variable/VariableMap;", "(Ljava/lang/String;Lorg/camunda/bpm/engine/variable/VariableMap;)Lio/holunda/camunda/bpm/extension/jgiven/ProcessStage;", "isAsyncAfter", "", "(Ljava/lang/String;Lorg/camunda/bpm/engine/variable/VariableMap;Z)Lio/holunda/camunda/bpm/extension/jgiven/ProcessStage;", "job_is_executed", "()Lio/holunda/camunda/bpm/extension/jgiven/ProcessStage;", "activityId", "", "([Ljava/lang/String;)Lio/holunda/camunda/bpm/extension/jgiven/ProcessStage;", "message_is_received", "messageName", "no_job_is_executed", "process_continues", "process_has_not_passed", "elements", "process_has_passed", "process_is_deployed", "processDefinitionKey", "process_is_finished", "process_waits_for", "process_waits_in", "task_has_follow_up_date_after", "followUpDatePeriod", "Ljava/time/Period;", "(Ljava/time/Period;)Lio/holunda/camunda/bpm/extension/jgiven/ProcessStage;", "task_has_priority", "priority", "", "(I)Lio/holunda/camunda/bpm/extension/jgiven/ProcessStage;", "task_has_priority_greater_than", "task_has_priority_less_than", "task_has_priority_other_than", "task_is_assigned_to_user", "user", "task_is_completed_with_variables", "(Lorg/camunda/bpm/engine/variable/VariableMap;)Lio/holunda/camunda/bpm/extension/jgiven/ProcessStage;", "(Lorg/camunda/bpm/engine/variable/VariableMap;Z)Lio/holunda/camunda/bpm/extension/jgiven/ProcessStage;", "task_is_visible_to_groups", "groups", "task_is_visible_to_users", "users", "task_priority_is_between", "lower", "upper", "(II)Lio/holunda/camunda/bpm/extension/jgiven/ProcessStage;", "time_passes", "timerActivityId", "targetTime", "Ljava/util/Date;", "(Ljava/lang/String;Ljava/util/Date;)Lio/holunda/camunda/bpm/extension/jgiven/ProcessStage;", "timer_is_waiting_until", "expectedDate", "variable_is_not_present", "variableName", "variable_is_set", "value", "", "(Ljava/lang/String;Ljava/lang/Object;)Lio/holunda/camunda/bpm/extension/jgiven/ProcessStage;", "variables_are_not_present", "variableNames", "camunda-bpm-jgiven"})
public class ProcessStage<SELF extends ProcessStage<SELF, PROCESS_BEAN>, PROCESS_BEAN extends Supplier<ProcessInstance>>
extends Stage<SELF> {
    @ExpectedScenarioState(required=true)
    public ProcessEngine camunda;
    @ScenarioState
    public PROCESS_BEAN processInstanceSupplier;

    @NotNull
    public ProcessEngine getCamunda() {
        ProcessEngine processEngine = this.camunda;
        if (processEngine != null) {
            return processEngine;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"camunda");
        return null;
    }

    public void setCamunda(@NotNull ProcessEngine processEngine) {
        Intrinsics.checkNotNullParameter((Object)processEngine, (String)"<set-?>");
        this.camunda = processEngine;
    }

    @NotNull
    public PROCESS_BEAN getProcessInstanceSupplier() {
        PROCESS_BEAN PROCESS_BEAN = this.processInstanceSupplier;
        if (PROCESS_BEAN != null) {
            return PROCESS_BEAN;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"processInstanceSupplier");
        return null;
    }

    public void setProcessInstanceSupplier(@NotNull PROCESS_BEAN PROCESS_BEAN) {
        Intrinsics.checkNotNullParameter(PROCESS_BEAN, (String)"<set-?>");
        this.processInstanceSupplier = PROCESS_BEAN;
    }

    @As(value="process waits in $")
    @NotNull
    public SELF process_waits_in(@Quoted @NotNull String activityId) {
        Intrinsics.checkNotNullParameter((Object)activityId, (String)"activityId");
        Stage $this$step$iv = this;
        boolean $i$f$step = false;
        Stage stage = JGivenKotlinKt.getSelf((Stage)$this$step$iv);
        ProcessStage $this$process_waits_in_u24lambda_u240 = (ProcessStage)stage;
        boolean bl = false;
        String[] stringArray = new String[]{activityId};
        BpmnAwareTests.assertThat((ProcessInstance)((ProcessInstance)$this$process_waits_in_u24lambda_u240.getProcessInstanceSupplier().get())).isWaitingAt(stringArray);
        return (SELF)((Object)((ProcessStage)stage));
    }

    /*
     * WARNING - void declaration
     */
    @As(value="process waits in activities $")
    @NotNull
    public SELF process_waits_in(String ... activityId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)activityId, (String)"activityId");
        Stage $this$step$iv = this;
        boolean $i$f$step = false;
        Stage stage = JGivenKotlinKt.getSelf((Stage)$this$step$iv);
        ProcessStage $this$process_waits_in_u24lambda_u243 = (ProcessStage)stage;
        boolean bl = false;
        if (!(!(activityId.length == 0))) {
            boolean $i$a$-require-ProcessStage$process_waits_in$2$22 = false;
            String $i$a$-require-ProcessStage$process_waits_in$2$22 = "At least one activity id must be provided";
            throw new IllegalArgumentException($i$a$-require-ProcessStage$process_waits_in$2$22.toString());
        }
        String[] $this$map$iv = activityId;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var15_17 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Job job = BpmnAwareTests.job((String)it);
            collection.add((JobAssert)((JobAssert)BpmnAwareTests.assertThat((Job)job).as("Expecting the process to be waiting in activity '" + (String)it + "', but it was not.", new Object[0])).isNotNull());
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return (SELF)((Object)((ProcessStage)stage));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public SELF process_waits_for(String ... activityId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)activityId, (String)"activityId");
        Stage $this$step$iv = this;
        boolean $i$f$step = false;
        Stage stage = JGivenKotlinKt.getSelf((Stage)$this$step$iv);
        ProcessStage $this$process_waits_for_u24lambda_u246 = (ProcessStage)stage;
        boolean bl = false;
        if (!(!(activityId.length == 0))) {
            boolean $i$a$-require-ProcessStage$process_waits_for$1$22 = false;
            String $i$a$-require-ProcessStage$process_waits_for$1$22 = "At least one activity id must be provided";
            throw new IllegalArgumentException($i$a$-require-ProcessStage$process_waits_for$1$22.toString());
        }
        List list = BpmnAwareTests.runtimeService().createEventSubscriptionQuery().list();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"runtimeService().createE\u2026ubscriptionQuery().list()");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EventSubscription eventSubscription = (EventSubscription)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getActivityId());
        }
        List activityIdOfActiveEventSubscriptions = (List)destination$iv$iv;
        ((ListAssert)Assertions.assertThat((List)activityIdOfActiveEventSubscriptions).as("Expecting the process to wait for events in activity " + ArraysKt.joinToString$default((Object[])activityId, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ", but it was waiting in " + CollectionsKt.joinToString$default((Iterable)activityIdOfActiveEventSubscriptions, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null), new Object[0])).containsExactlyInAnyOrder((Object[])Arrays.copyOf(activityId, activityId.length));
        return (SELF)((Object)((ProcessStage)stage));
    }

    @As(value="process continues")
    @NotNull
    public SELF process_continues() {
        Stage $this$step$iv = this;
        boolean $i$f$step = false;
        Stage stage = JGivenKotlinKt.getSelf((Stage)$this$step$iv);
        ProcessStage $this$process_continues_u24lambda_u247 = (ProcessStage)stage;
        boolean bl = false;
        $this$process_continues_u24lambda_u247.job_is_executed();
        return (SELF)((Object)((ProcessStage)stage));
    }

    @As(value="process continues")
    @NotNull
    public SELF process_continues(String ... activityId) {
        Intrinsics.checkNotNullParameter((Object)activityId, (String)"activityId");
        return this.job_is_executed(Arrays.copyOf(activityId, activityId.length));
    }

    @As(value="process $ is deployed")
    @NotNull
    public SELF process_is_deployed(@Quoted @NotNull String processDefinitionKey) {
        Intrinsics.checkNotNullParameter((Object)processDefinitionKey, (String)"processDefinitionKey");
        Stage $this$step$iv = this;
        boolean $i$f$step = false;
        Stage stage = JGivenKotlinKt.getSelf((Stage)$this$step$iv);
        ProcessStage $this$process_is_deployed_u24lambda_u248 = (ProcessStage)stage;
        boolean bl = false;
        BpmnAwareTests.assertThat((ProcessDefinition)((ProcessDefinition)$this$process_is_deployed_u24lambda_u248.getCamunda().getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).latestVersion().singleResult())).isNotNull();
        return (SELF)((Object)((ProcessStage)stage));
    }

    @NotNull
    public SELF process_is_finished() {
        Stage $this$step$iv = this;
        boolean $i$f$step = false;
        Stage stage = JGivenKotlinKt.getSelf((Stage)$this$step$iv);
        ProcessStage $this$process_is_finished_u24lambda_u249 = (ProcessStage)stage;
        boolean bl = false;
        BpmnAwareTests.assertThat((ProcessInstance)((ProcessInstance)$this$process_is_finished_u24lambda_u249.getProcessInstanceSupplier().get())).isEnded();
        return (SELF)((Object)((ProcessStage)stage));
    }

    @As(value="process has passed element(s) $")
    @NotNull
    public SELF process_has_passed(String ... elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        Stage $this$step$iv = this;
        boolean $i$f$step = false;
        Stage stage = JGivenKotlinKt.getSelf((Stage)$this$step$iv);
        ProcessStage $this$process_has_passed_u24lambda_u2410 = (ProcessStage)stage;
        boolean bl = false;
        BpmnAwareTests.assertThat((ProcessInstance)((ProcessInstance)$this$process_has_passed_u24lambda_u2410.getProcessInstanceSupplier().get())).hasPassedInOrder(Arrays.copyOf(elements, elements.length));
        return (SELF)((Object)((ProcessStage)stage));
    }

    @As(value="process has not passed element(s) $")
    @NotNull
    public SELF process_has_not_passed(String ... elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        Stage $this$step$iv = this;
        boolean $i$f$step = false;
        Stage stage = JGivenKotlinKt.getSelf((Stage)$this$step$iv);
        ProcessStage $this$process_has_not_passed_u24lambda_u2411 = (ProcessStage)stage;
        boolean bl = false;
        BpmnAwareTests.assertThat((ProcessInstance)((ProcessInstance)$this$process_has_not_passed_u24lambda_u2411.getProcessInstanceSupplier().get())).hasNotPassed(Arrays.copyOf(elements, elements.length));
        return (SELF)((Object)((ProcessStage)stage));
    }

    @NotNull
    public SELF task_is_assigned_to_user(@Quoted @NotNull String user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Stage $this$step$iv = this;
        boolean $i$f$step = false;
        Stage stage = JGivenKotlinKt.getSelf((Stage)$this$step$iv);
        ProcessStage $this$task_is_assigned_to_user_u24lambda_u2412 = (ProcessStage)stage;
        boolean bl = false;
        BpmnAwareTests.assertThat((Task)BpmnAwareTests.task()).isAssignedTo(user);
        return (SELF)((Object)((ProcessStage)stage));
    }

    @NotNull
    public SELF task_is_visible_to_users(@QuotedVarargs @NotNull String[] users) {
        Intrinsics.checkNotNullParameter((Object)users, (String)"users");
        Stage $this$step$iv = this;
        boolean $i$f$step = false;
        Stage stage = JGivenKotlinKt.getSelf((Stage)$this$step$iv);
        ProcessStage $this$task_is_visible_to_users_u24lambda_u2414 = (ProcessStage)stage;
        boolean bl = false;
        Task task = BpmnAwareTests.task();
        String[] $this$forEach$iv = users;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String user = element$iv = $this$forEach$iv[i];
            boolean bl2 = false;
            BpmnAwareTests.assertThat((Task)task).hasCandidateUser(user);
        }
        return (SELF)((Object)((ProcessStage)stage));
    }

    @NotNull
    public SELF task_is_visible_to_groups(@QuotedVarargs @NotNull String[] groups) {
        Intrinsics.checkNotNullParameter((Object)groups, (String)"groups");
        Stage $this$step$iv = this;
        boolean $i$f$step = false;
        Stage stage = JGivenKotlinKt.getSelf((Stage)$this$step$iv);
        ProcessStage $this$task_is_visible_to_groups_u24lambda_u2416 = (ProcessStage)stage;
        boolean bl = false;
        Task task = BpmnAwareTests.task();
        String[] $this$forEach$iv = groups;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String group = element$iv = $this$forEach$iv[i];
            boolean bl2 = false;
            BpmnAwareTests.assertThat((Task)task).hasCandidateGroup(group);
        }
        return (SELF)((Object)((ProcessStage)stage));
    }

    @As(value="task's follow-up date is $ after its creation")
    @NotNull
    public SELF task_has_follow_up_date_after(@NotNull Period followUpDatePeriod) {
        Intrinsics.checkNotNullParameter((Object)followUpDatePeriod, (String)"followUpDatePeriod");
        Stage $this$step$iv = this;
        boolean $i$f$step = false;
        Stage stage = JGivenKotlinKt.getSelf((Stage)$this$step$iv);
        ProcessStage $this$task_has_follow_up_date_after_u24lambda_u2417 = (ProcessStage)stage;
        boolean bl = false;
        Assertions.assertThat((Date)BpmnAwareTests.task().getFollowUpDate()).isInSameSecondWindowAs(Date.from(BpmnAwareTests.task().getCreateTime().toInstant().plus(followUpDatePeriod)));
        return (SELF)((Object)((ProcessStage)stage));
    }

    @As(value="task's priority is $")
    @NotNull
    public SELF task_has_priority(int priority) {
        Stage $this$step$iv = this;
        boolean $i$f$step = false;
        Stage stage = JGivenKotlinKt.getSelf((Stage)$this$step$iv);
        ProcessStage $this$task_has_priority_u24lambda_u2418 = (ProcessStage)stage;
        boolean bl = false;
        Object[] objectArray = new Object[]{priority, BpmnAwareTests.task().getPriority()};
        ((AbstractIntegerAssert)Assertions.assertThat((int)BpmnAwareTests.task().getPriority()).as("Expecting task priority to be %d, but it was %d.", objectArray)).isEqualTo(priority);
        return (SELF)((Object)((ProcessStage)stage));
    }

    @As(value="task's priority is not $")
    @NotNull
    public SELF task_has_priority_other_than(int priority) {
        Stage $this$step$iv = this;
        boolean $i$f$step = false;
        Stage stage = JGivenKotlinKt.getSelf((Stage)$this$step$iv);
        ProcessStage $this$task_has_priority_other_than_u24lambda_u2419 = (ProcessStage)stage;
        boolean bl = false;
        Object[] objectArray = new Object[]{priority, BpmnAwareTests.task().getPriority()};
        ((AbstractIntegerAssert)Assertions.assertThat((int)BpmnAwareTests.task().getPriority()).as("Expecting task priority to not equal to %d, but it was %d.", objectArray)).isNotEqualTo(priority);
        return (SELF)((Object)((ProcessStage)stage));
    }

    @As(value="task's priority is greater than $")
    @NotNull
    public SELF task_has_priority_greater_than(int priority) {
        Stage $this$step$iv = this;
        boolean $i$f$step = false;
        Stage stage = JGivenKotlinKt.getSelf((Stage)$this$step$iv);
        ProcessStage $this$task_has_priority_greater_than_u24lambda_u2420 = (ProcessStage)stage;
        boolean bl = false;
        Object[] objectArray = new Object[]{priority, BpmnAwareTests.task().getPriority()};
        ((AbstractIntegerAssert)Assertions.assertThat((int)BpmnAwareTests.task().getPriority()).as("Expecting task priority to be greater than %d, but it was %d.", objectArray)).isGreaterThan(priority);
        return (SELF)((Object)((ProcessStage)stage));
    }

    @As(value="task's priority is less than $")
    @NotNull
    public SELF task_has_priority_less_than(int priority) {
        Stage $this$step$iv = this;
        boolean $i$f$step = false;
        Stage stage = JGivenKotlinKt.getSelf((Stage)$this$step$iv);
        ProcessStage $this$task_has_priority_less_than_u24lambda_u2421 = (ProcessStage)stage;
        boolean bl = false;
        Object[] objectArray = new Object[]{priority, BpmnAwareTests.task().getPriority()};
        ((AbstractIntegerAssert)Assertions.assertThat((int)BpmnAwareTests.task().getPriority()).as("Expecting task priority to be less than %d, but it was %d.", objectArray)).isLessThan(priority);
        return (SELF)((Object)((ProcessStage)stage));
    }

    @As(value="task's priority is between $lower and $upper")
    @NotNull
    public SELF task_priority_is_between(int lower, int upper) {
        Stage $this$step$iv = this;
        boolean $i$f$step = false;
        Stage stage = JGivenKotlinKt.getSelf((Stage)$this$step$iv);
        ProcessStage $this$task_priority_is_between_u24lambda_u2422 = (ProcessStage)stage;
        boolean bl = false;
        Object[] objectArray = new Object[]{lower, upper, BpmnAwareTests.task().getPriority()};
        ((AbstractIntegerAssert)Assertions.assertThat((int)BpmnAwareTests.task().getPriority()).as("Expecting task priority to be between %d and %d, but it was %d.", objectArray)).isBetween(Integer.valueOf(lower), Integer.valueOf(upper));
        return (SELF)((Object)((ProcessStage)stage));
    }

    public static /* synthetic */ ProcessStage task_priority_is_between$default(ProcessStage processStage, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: task_priority_is_between");
        }
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = 100;
        }
        return processStage.task_priority_is_between(n, n2);
    }

    @As(value="variable $variableName is set to $value")
    @NotNull
    public SELF variable_is_set(@Quoted @NotNull String variableName, @Quoted @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Stage $this$step$iv = this;
        boolean $i$f$step = false;
        Stage stage = JGivenKotlinKt.getSelf((Stage)$this$step$iv);
        ProcessStage $this$variable_is_set_u24lambda_u2423 = (ProcessStage)stage;
        boolean bl = false;
        String[] stringArray = new String[]{variableName};
        BpmnAwareTests.assertThat((ProcessInstance)((ProcessInstance)$this$variable_is_set_u24lambda_u2423.getProcessInstanceSupplier().get())).hasVariables(stringArray);
        BpmnAwareTests.assertThat((ProcessInstance)((ProcessInstance)$this$variable_is_set_u24lambda_u2423.getProcessInstanceSupplier().get())).variables().containsEntry((Object)variableName, value);
        return (SELF)((Object)((ProcessStage)stage));
    }

    @As(value="variable $ is not present")
    @NotNull
    public SELF variable_is_not_present(@QuotedVarargs @NotNull String variableName) {
        Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
        Stage $this$step$iv = this;
        boolean $i$f$step = false;
        Stage stage = JGivenKotlinKt.getSelf((Stage)$this$step$iv);
        ProcessStage $this$variable_is_not_present_u24lambda_u2424 = (ProcessStage)stage;
        boolean bl = false;
        Object[] objectArray = new String[]{variableName};
        ((ProcessInstanceAssert)BpmnAwareTests.assertThat((ProcessInstance)((ProcessInstance)$this$variable_is_not_present_u24lambda_u2424.getProcessInstanceSupplier().get())).as("variable " + variableName + " should not be present", new Object[0])).variables().doesNotContainKeys(objectArray);
        return (SELF)((Object)((ProcessStage)stage));
    }

    @As(value="variables $ are not present")
    @NotNull
    public SELF variables_are_not_present(@QuotedVarargs @NotNull String[] variableNames) {
        Intrinsics.checkNotNullParameter((Object)variableNames, (String)"variableNames");
        Stage $this$step$iv = this;
        boolean $i$f$step = false;
        Stage stage = JGivenKotlinKt.getSelf((Stage)$this$step$iv);
        ProcessStage $this$variables_are_not_present_u24lambda_u2425 = (ProcessStage)stage;
        boolean bl = false;
        ((ProcessInstanceAssert)BpmnAwareTests.assertThat((ProcessInstance)((ProcessInstance)$this$variables_are_not_present_u24lambda_u2425.getProcessInstanceSupplier().get())).as("variables " + ArraysKt.joinToString$default((Object[])variableNames, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + " should not be present", new Object[0])).variables().doesNotContainKeys((Object[])Arrays.copyOf(variableNames, variableNames.length));
        return (SELF)((Object)((ProcessStage)stage));
    }

    @As(value="task is completed with variables $")
    @NotNull
    public SELF task_is_completed_with_variables(@NotNull VariableMap variables) {
        Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
        Stage $this$step$iv = this;
        boolean $i$f$step = false;
        Stage stage = JGivenKotlinKt.getSelf((Stage)$this$step$iv);
        ProcessStage $this$task_is_completed_with_variables_u24lambda_u2426 = (ProcessStage)stage;
        boolean bl = false;
        $this$task_is_completed_with_variables_u24lambda_u2426.task_is_completed_with_variables(variables, false);
        return (SELF)((Object)((ProcessStage)stage));
    }

    public static /* synthetic */ ProcessStage task_is_completed_with_variables$default(ProcessStage processStage, VariableMap variableMap, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: task_is_completed_with_variables");
        }
        if ((n & 1) != 0) {
            VariableMap variableMap2 = Variables.createVariables();
            Intrinsics.checkNotNullExpressionValue((Object)variableMap2, (String)"createVariables()");
            variableMap = variableMap2;
        }
        return processStage.task_is_completed_with_variables(variableMap);
    }

    @As(value="task is completed with variables $")
    @NotNull
    public SELF task_is_completed_with_variables(@NotNull VariableMap variables, @Hidden boolean isAsyncAfter) {
        Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
        Stage $this$step$iv = this;
        boolean $i$f$step = false;
        Stage stage = JGivenKotlinKt.getSelf((Stage)$this$step$iv);
        ProcessStage $this$task_is_completed_with_variables_u24lambda_u2427 = (ProcessStage)stage;
        boolean bl = false;
        String taskDefinitionKey = BpmnAwareTests.task().getTaskDefinitionKey();
        BpmnAwareTests.taskService().complete(BpmnAwareTests.task().getId(), (Map)variables);
        if (isAsyncAfter) {
            String[] stringArray = new String[]{taskDefinitionKey};
            ((ProcessInstanceAssert)BpmnAwareTests.assertThat((ProcessInstance)((ProcessInstance)$this$task_is_completed_with_variables_u24lambda_u2427.getProcessInstanceSupplier().get())).as("Expecting the task to be marked as async after and continue on complete.", new Object[0])).isWaitingAt(stringArray);
            stringArray = new String[1];
            Intrinsics.checkNotNullExpressionValue((Object)taskDefinitionKey, (String)"taskDefinitionKey");
            stringArray[0] = taskDefinitionKey;
            $this$task_is_completed_with_variables_u24lambda_u2427.job_is_executed(stringArray);
        }
        return (SELF)((Object)((ProcessStage)stage));
    }

    public static /* synthetic */ ProcessStage task_is_completed_with_variables$default(ProcessStage processStage, VariableMap variableMap, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: task_is_completed_with_variables");
        }
        if ((n & 1) != 0) {
            VariableMap variableMap2 = Variables.createVariables();
            Intrinsics.checkNotNullExpressionValue((Object)variableMap2, (String)"createVariables()");
            variableMap = variableMap2;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return processStage.task_is_completed_with_variables(variableMap, bl);
    }

    @NotNull
    public SELF no_job_is_executed() {
        Stage $this$step$iv = this;
        boolean $i$f$step = false;
        Stage stage = JGivenKotlinKt.getSelf((Stage)$this$step$iv);
        ProcessStage $this$no_job_is_executed_u24lambda_u2428 = (ProcessStage)stage;
        boolean bl = false;
        return (SELF)((Object)((ProcessStage)stage));
    }

    @NotNull
    public SELF job_is_executed() {
        Stage $this$step$iv = this;
        boolean $i$f$step = false;
        Stage stage = JGivenKotlinKt.getSelf((Stage)$this$step$iv);
        ProcessStage $this$job_is_executed_u24lambda_u2429 = (ProcessStage)stage;
        boolean bl = false;
        BpmnAwareTests.assertThat((ProcessInstance)((ProcessInstance)$this$job_is_executed_u24lambda_u2429.getProcessInstanceSupplier().get())).isNotNull();
        BpmnAwareTests.execute((Job)BpmnAwareTests.job());
        return (SELF)((Object)((ProcessStage)stage));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public SELF job_is_executed(String ... activityId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)activityId, (String)"activityId");
        Stage $this$step$iv = this;
        boolean $i$f$step = false;
        Stage stage = JGivenKotlinKt.getSelf((Stage)$this$step$iv);
        ProcessStage $this$job_is_executed_u24lambda_u2432 = (ProcessStage)stage;
        boolean bl = false;
        if (!(!(activityId.length == 0))) {
            boolean $i$a$-require-ProcessStage$job_is_executed$2$22 = false;
            String $i$a$-require-ProcessStage$job_is_executed$2$22 = "At least one activity id must be provided";
            throw new IllegalArgumentException($i$a$-require-ProcessStage$job_is_executed$2$22.toString());
        }
        String[] $this$map$iv = activityId;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var15_17 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Job job = BpmnAwareTests.job((String)it);
            ((JobAssert)BpmnAwareTests.assertThat((Job)job).as("Expecting the process to be waiting in activity '" + (String)it + "', but it was not.", new Object[0])).isNotNull();
            BpmnAwareTests.execute((Job)job);
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return (SELF)((Object)((ProcessStage)stage));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public SELF timer_is_waiting_until(@NotNull String timerActivityId, @NotNull Date expectedDate) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)timerActivityId, (String)"timerActivityId");
        Intrinsics.checkNotNullParameter((Object)expectedDate, (String)"expectedDate");
        Stage $this$step$iv = this;
        boolean $i$f$step = false;
        Stage stage = JGivenKotlinKt.getSelf((Stage)$this$step$iv);
        ProcessStage $this$timer_is_waiting_until_u24lambda_u2434 = (ProcessStage)stage;
        boolean bl = false;
        Date truncatedToMinutes = Date.from(expectedDate.toInstant().truncatedTo(ChronoUnit.MINUTES));
        String[] stringArray = new String[]{timerActivityId};
        List list = BpmnAwareTests.managementService().createJobDefinitionQuery().activityIdIn(stringArray).list();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"managementService()\n    \u2026ActivityId)\n      .list()");
        Iterable iterable = list;
        boolean $i$f$mapNotNull = false;
        void var11_12 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Job it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            JobDefinition jobDefinition = (JobDefinition)element$iv$iv;
            boolean bl3 = false;
            if ((Job)BpmnAwareTests.managementService().createJobQuery().jobDefinitionId(jobDefinition.getId()).singleResult() == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$mapNotNullTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TimerEntity)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List timerJobs = (List)destination$iv$iv;
        ((ListAssert)Assertions.assertThat((List)timerJobs).as("Expected one instance waiting in " + timerActivityId + ", but found " + timerJobs.size() + ".", new Object[0])).hasSize(1);
        BpmnAwareTests.assertThat((Job)((Job)timerJobs.get(0))).hasDueDate(truncatedToMinutes);
        return (SELF)((Object)((ProcessStage)stage));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public SELF time_passes(@NotNull String timerActivityId, @NotNull Date targetTime) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)timerActivityId, (String)"timerActivityId");
        Intrinsics.checkNotNullParameter((Object)targetTime, (String)"targetTime");
        Stage $this$step$iv = this;
        boolean $i$f$step = false;
        Stage stage = JGivenKotlinKt.getSelf((Stage)$this$step$iv);
        ProcessStage $this$time_passes_u24lambda_u2436 = (ProcessStage)stage;
        boolean bl = false;
        ClockUtil.setCurrentTime((Date)targetTime);
        String[] stringArray = new String[]{timerActivityId};
        List list = BpmnAwareTests.managementService().createJobDefinitionQuery().activityIdIn(stringArray).list();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"managementService()\n    \u2026ActivityId)\n      .list()");
        String[] stringArray2 = (String[])list;
        boolean $i$f$mapNotNull = false;
        void var10_11 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Job it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            JobDefinition jobDefinition = (JobDefinition)element$iv$iv;
            boolean bl3 = false;
            if ((Job)BpmnAwareTests.managementService().createJobQuery().jobDefinitionId(jobDefinition.getId()).singleResult() == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$mapNotNullTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TimerEntity)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List timerJobs = (List)destination$iv$iv;
        ((ListAssert)Assertions.assertThat((List)timerJobs).as("Expected one instance waiting in " + timerActivityId + ", but found " + timerJobs.size() + ".", new Object[0])).hasSize(1);
        stringArray2 = new String[]{timerActivityId};
        $this$time_passes_u24lambda_u2436.job_is_executed(stringArray2);
        return (SELF)((Object)((ProcessStage)stage));
    }

    @As(value="external task exists on topic $topicName")
    @NotNull
    public SELF external_task_exists(@Quoted @NotNull String topicName) {
        Intrinsics.checkNotNullParameter((Object)topicName, (String)"topicName");
        Stage $this$step$iv = this;
        boolean $i$f$step = false;
        Stage stage = JGivenKotlinKt.getSelf((Stage)$this$step$iv);
        ProcessStage $this$external_task_exists_u24lambda_u2437 = (ProcessStage)stage;
        boolean bl = false;
        List externalTasks = $this$external_task_exists_u24lambda_u2437.getCamunda().getExternalTaskService().createExternalTaskQuery().topicName(topicName).list();
        Assertions.assertThat((List)externalTasks).isNotEmpty();
        return (SELF)((Object)((ProcessStage)stage));
    }

    @As(value="external task on topic $topicName is completed with variables $variables")
    @NotNull
    public SELF external_task_is_completed(@Quoted @NotNull String topicName, @NotNull VariableMap variables) {
        Intrinsics.checkNotNullParameter((Object)topicName, (String)"topicName");
        Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
        Stage $this$step$iv = this;
        boolean $i$f$step = false;
        Stage stage = JGivenKotlinKt.getSelf((Stage)$this$step$iv);
        ProcessStage $this$external_task_is_completed_u24lambda_u2438 = (ProcessStage)stage;
        boolean bl = false;
        $this$external_task_is_completed_u24lambda_u2438.external_task_is_completed(topicName, variables, false);
        return (SELF)((Object)((ProcessStage)stage));
    }

    public static /* synthetic */ ProcessStage external_task_is_completed$default(ProcessStage processStage, String string, VariableMap variableMap, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: external_task_is_completed");
        }
        if ((n & 2) != 0) {
            VariableMap variableMap2 = Variables.createVariables();
            Intrinsics.checkNotNullExpressionValue((Object)variableMap2, (String)"createVariables()");
            variableMap = variableMap2;
        }
        return processStage.external_task_is_completed(string, variableMap);
    }

    /*
     * WARNING - void declaration
     */
    @As(value="external task on topic $topicName is completed with variables $variables")
    @NotNull
    public SELF external_task_is_completed(@Quoted @NotNull String topicName, @NotNull VariableMap variables, boolean isAsyncAfter) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)topicName, (String)"topicName");
        Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
        Stage $this$step$iv = this;
        boolean $i$f$step = false;
        Stage stage = JGivenKotlinKt.getSelf((Stage)$this$step$iv);
        ProcessStage $this$external_task_is_completed_u24lambda_u2440 = (ProcessStage)stage;
        boolean bl = false;
        List list = $this$external_task_is_completed_u24lambda_u2440.getCamunda().getExternalTaskService().fetchAndLock(10, "test-worker").topic(topicName, 1000L).execute();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"camunda\n      .externalT\u2026, 1_000)\n      .execute()");
        Iterable iterable = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LockedExternalTask it = (LockedExternalTask)element$iv;
            boolean bl2 = false;
            $this$external_task_is_completed_u24lambda_u2440.getCamunda().getExternalTaskService().complete(it.getId(), "test-worker", (Map)variables);
        }
        if (isAsyncAfter) {
            $this$external_task_is_completed_u24lambda_u2440.process_continues();
        }
        return (SELF)((Object)((ProcessStage)stage));
    }

    public static /* synthetic */ ProcessStage external_task_is_completed$default(ProcessStage processStage, String string, VariableMap variableMap, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: external_task_is_completed");
        }
        if ((n & 2) != 0) {
            VariableMap variableMap2 = Variables.createVariables();
            Intrinsics.checkNotNullExpressionValue((Object)variableMap2, (String)"createVariables()");
            variableMap = variableMap2;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return processStage.external_task_is_completed(string, variableMap, bl);
    }

    @As(value="message $messageName is received setting variables $variables")
    @NotNull
    public SELF message_is_received(@Quoted @NotNull String messageName, @NotNull VariableMap variables) {
        Intrinsics.checkNotNullParameter((Object)messageName, (String)"messageName");
        Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
        Stage $this$step$iv = this;
        boolean $i$f$step = false;
        Stage stage = JGivenKotlinKt.getSelf((Stage)$this$step$iv);
        ProcessStage $this$message_is_received_u24lambda_u2441 = (ProcessStage)stage;
        boolean bl = false;
        Assertions.assertThat((long)$this$message_is_received_u24lambda_u2441.getCamunda().getRuntimeService().createEventSubscriptionQuery().processInstanceId(((ProcessInstance)$this$message_is_received_u24lambda_u2441.getProcessInstanceSupplier().get()).getProcessInstanceId()).eventType("message").eventName(messageName).count()).isEqualTo(1L);
        $this$message_is_received_u24lambda_u2441.getCamunda().getRuntimeService().createMessageCorrelation(messageName).setVariables((Map)variables).correlate();
        return (SELF)((Object)((ProcessStage)stage));
    }

    public static /* synthetic */ ProcessStage message_is_received$default(ProcessStage processStage, String string, VariableMap variableMap, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: message_is_received");
        }
        if ((n & 2) != 0) {
            VariableMap variableMap2 = Variables.createVariables();
            Intrinsics.checkNotNullExpressionValue((Object)variableMap2, (String)"createVariables()");
            variableMap = variableMap2;
        }
        return processStage.message_is_received(string, variableMap);
    }
}

