/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.view;

import android.content.Context;
import android.view.ActionMode;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import androidx.annotation.RestrictTo;
import androidx.appcompat.view.ActionMode;
import androidx.appcompat.view.menu.MenuItemWrapperICS;
import androidx.appcompat.view.menu.MenuWrapperICS;
import androidx.collection.SimpleArrayMap;
import androidx.core.internal.view.SupportMenu;
import androidx.core.internal.view.SupportMenuItem;
import java.util.ArrayList;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class SupportActionModeWrapper
extends android.view.ActionMode {
    final Context mContext;
    final ActionMode mWrappedObject;

    public SupportActionModeWrapper(Context context, ActionMode supportActionMode) {
        this.mContext = context;
        this.mWrappedObject = supportActionMode;
    }

    public Object getTag() {
        return this.mWrappedObject.getTag();
    }

    public void setTag(Object tag) {
        this.mWrappedObject.setTag(tag);
    }

    public void setTitle(CharSequence title) {
        this.mWrappedObject.setTitle(title);
    }

    public void setSubtitle(CharSequence subtitle) {
        this.mWrappedObject.setSubtitle(subtitle);
    }

    public void invalidate() {
        this.mWrappedObject.invalidate();
    }

    public void finish() {
        this.mWrappedObject.finish();
    }

    public Menu getMenu() {
        return new MenuWrapperICS(this.mContext, (SupportMenu)this.mWrappedObject.getMenu());
    }

    public CharSequence getTitle() {
        return this.mWrappedObject.getTitle();
    }

    public void setTitle(int resId) {
        this.mWrappedObject.setTitle(resId);
    }

    public CharSequence getSubtitle() {
        return this.mWrappedObject.getSubtitle();
    }

    public void setSubtitle(int resId) {
        this.mWrappedObject.setSubtitle(resId);
    }

    public View getCustomView() {
        return this.mWrappedObject.getCustomView();
    }

    public void setCustomView(View view) {
        this.mWrappedObject.setCustomView(view);
    }

    public MenuInflater getMenuInflater() {
        return this.mWrappedObject.getMenuInflater();
    }

    public boolean getTitleOptionalHint() {
        return this.mWrappedObject.getTitleOptionalHint();
    }

    public void setTitleOptionalHint(boolean titleOptional) {
        this.mWrappedObject.setTitleOptionalHint(titleOptional);
    }

    public boolean isTitleOptional() {
        return this.mWrappedObject.isTitleOptional();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static class CallbackWrapper
    implements ActionMode.Callback {
        final ActionMode.Callback mWrappedCallback;
        final Context mContext;
        final ArrayList<SupportActionModeWrapper> mActionModes;
        final SimpleArrayMap<Menu, Menu> mMenus;

        public CallbackWrapper(Context context, ActionMode.Callback supportCallback) {
            this.mContext = context;
            this.mWrappedCallback = supportCallback;
            this.mActionModes = new ArrayList();
            this.mMenus = new SimpleArrayMap();
        }

        @Override
        public boolean onCreateActionMode(ActionMode mode, Menu menu2) {
            return this.mWrappedCallback.onCreateActionMode(this.getActionModeWrapper(mode), this.getMenuWrapper(menu2));
        }

        @Override
        public boolean onPrepareActionMode(ActionMode mode, Menu menu2) {
            return this.mWrappedCallback.onPrepareActionMode(this.getActionModeWrapper(mode), this.getMenuWrapper(menu2));
        }

        @Override
        public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
            return this.mWrappedCallback.onActionItemClicked(this.getActionModeWrapper(mode), (MenuItem)new MenuItemWrapperICS(this.mContext, (SupportMenuItem)item));
        }

        @Override
        public void onDestroyActionMode(ActionMode mode) {
            this.mWrappedCallback.onDestroyActionMode(this.getActionModeWrapper(mode));
        }

        private Menu getMenuWrapper(Menu menu2) {
            Menu wrapper = (Menu)this.mMenus.get((Object)menu2);
            if (wrapper == null) {
                wrapper = new MenuWrapperICS(this.mContext, (SupportMenu)menu2);
                this.mMenus.put((Object)menu2, (Object)wrapper);
            }
            return wrapper;
        }

        public android.view.ActionMode getActionModeWrapper(ActionMode mode) {
            int count = this.mActionModes.size();
            for (int i = 0; i < count; ++i) {
                SupportActionModeWrapper wrapper = this.mActionModes.get(i);
                if (wrapper == null || wrapper.mWrappedObject != mode) continue;
                return wrapper;
            }
            SupportActionModeWrapper wrapper = new SupportActionModeWrapper(this.mContext, mode);
            this.mActionModes.add(wrapper);
            return wrapper;
        }
    }
}

