/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.os.CancellationSignal;
import androidx.core.view.ViewCompat;
import androidx.fragment.R;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentStateManager;
import androidx.fragment.app.SpecialEffectsControllerFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

abstract class SpecialEffectsController {
    private final ViewGroup mContainer;
    final ArrayList<Operation> mPendingOperations = new ArrayList();
    final ArrayList<Operation> mRunningOperations = new ArrayList();
    boolean mOperationDirectionIsPop = false;
    boolean mIsContainerPostponed = false;

    @NonNull
    static SpecialEffectsController getOrCreateController(@NonNull ViewGroup container, @NonNull FragmentManager fragmentManager) {
        SpecialEffectsControllerFactory factory = fragmentManager.getSpecialEffectsControllerFactory();
        return SpecialEffectsController.getOrCreateController(container, factory);
    }

    @NonNull
    static SpecialEffectsController getOrCreateController(@NonNull ViewGroup container, @NonNull SpecialEffectsControllerFactory factory) {
        Object controller = container.getTag(R.id.special_effects_controller_view_tag);
        if (controller instanceof SpecialEffectsController) {
            return (SpecialEffectsController)controller;
        }
        SpecialEffectsController newController = factory.createController(container);
        container.setTag(R.id.special_effects_controller_view_tag, (Object)newController);
        return newController;
    }

    SpecialEffectsController(@NonNull ViewGroup container) {
        this.mContainer = container;
    }

    @NonNull
    public ViewGroup getContainer() {
        return this.mContainer;
    }

    @Nullable
    Operation.LifecycleImpact getAwaitingCompletionLifecycleImpact(@NonNull FragmentStateManager fragmentStateManager) {
        Operation runningOperation;
        Operation.LifecycleImpact lifecycleImpact = null;
        Operation pendingOperation = this.findPendingOperation(fragmentStateManager.getFragment());
        if (pendingOperation != null) {
            lifecycleImpact = pendingOperation.getLifecycleImpact();
        }
        if ((runningOperation = this.findRunningOperation(fragmentStateManager.getFragment())) != null && (lifecycleImpact == null || lifecycleImpact == Operation.LifecycleImpact.NONE)) {
            return runningOperation.getLifecycleImpact();
        }
        return lifecycleImpact;
    }

    @Nullable
    private Operation findPendingOperation(@NonNull Fragment fragment) {
        for (Operation operation : this.mPendingOperations) {
            if (!operation.getFragment().equals(fragment) || operation.isCanceled()) continue;
            return operation;
        }
        return null;
    }

    @Nullable
    private Operation findRunningOperation(@NonNull Fragment fragment) {
        for (Operation operation : this.mRunningOperations) {
            if (!operation.getFragment().equals(fragment) || operation.isCanceled()) continue;
            return operation;
        }
        return null;
    }

    void enqueueAdd(@NonNull Operation.State finalState, @NonNull FragmentStateManager fragmentStateManager) {
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Enqueuing add operation for fragment " + fragmentStateManager.getFragment()));
        }
        this.enqueue(finalState, Operation.LifecycleImpact.ADDING, fragmentStateManager);
    }

    void enqueueShow(@NonNull FragmentStateManager fragmentStateManager) {
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Enqueuing show operation for fragment " + fragmentStateManager.getFragment()));
        }
        this.enqueue(Operation.State.VISIBLE, Operation.LifecycleImpact.NONE, fragmentStateManager);
    }

    void enqueueHide(@NonNull FragmentStateManager fragmentStateManager) {
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Enqueuing hide operation for fragment " + fragmentStateManager.getFragment()));
        }
        this.enqueue(Operation.State.GONE, Operation.LifecycleImpact.NONE, fragmentStateManager);
    }

    void enqueueRemove(@NonNull FragmentStateManager fragmentStateManager) {
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Enqueuing remove operation for fragment " + fragmentStateManager.getFragment()));
        }
        this.enqueue(Operation.State.REMOVED, Operation.LifecycleImpact.REMOVING, fragmentStateManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(@NonNull Operation.State finalState, @NonNull Operation.LifecycleImpact lifecycleImpact, @NonNull FragmentStateManager fragmentStateManager) {
        ArrayList<Operation> arrayList = this.mPendingOperations;
        synchronized (arrayList) {
            CancellationSignal signal = new CancellationSignal();
            Operation existingOperation = this.findPendingOperation(fragmentStateManager.getFragment());
            if (existingOperation != null) {
                existingOperation.mergeWith(finalState, lifecycleImpact);
                return;
            }
            final FragmentStateManagerOperation operation = new FragmentStateManagerOperation(finalState, lifecycleImpact, fragmentStateManager, signal);
            this.mPendingOperations.add(operation);
            operation.addCompletionListener(new Runnable(){

                @Override
                public void run() {
                    if (SpecialEffectsController.this.mPendingOperations.contains(operation)) {
                        operation.getFinalState().applyState(operation.getFragment().mView);
                    }
                }
            });
            operation.addCompletionListener(new Runnable(){

                @Override
                public void run() {
                    SpecialEffectsController.this.mPendingOperations.remove(operation);
                    SpecialEffectsController.this.mRunningOperations.remove(operation);
                }
            });
        }
    }

    void updateOperationDirection(boolean isPop) {
        this.mOperationDirectionIsPop = isPop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markPostponedState() {
        ArrayList<Operation> arrayList = this.mPendingOperations;
        synchronized (arrayList) {
            this.updateFinalState();
            this.mIsContainerPostponed = false;
            for (int index = this.mPendingOperations.size() - 1; index >= 0; --index) {
                Operation operation = this.mPendingOperations.get(index);
                Operation.State currentState = Operation.State.from(operation.getFragment().mView);
                if (operation.getFinalState() != Operation.State.VISIBLE || currentState == Operation.State.VISIBLE) continue;
                Fragment fragment = operation.getFragment();
                this.mIsContainerPostponed = fragment.isPostponed();
                break;
            }
        }
    }

    void forcePostponedExecutePendingOperations() {
        if (this.mIsContainerPostponed) {
            this.mIsContainerPostponed = false;
            this.executePendingOperations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executePendingOperations() {
        if (this.mIsContainerPostponed) {
            return;
        }
        if (!ViewCompat.isAttachedToWindow((View)this.mContainer)) {
            this.forceCompleteAllOperations();
            this.mOperationDirectionIsPop = false;
            return;
        }
        ArrayList<Operation> arrayList = this.mPendingOperations;
        synchronized (arrayList) {
            if (!this.mPendingOperations.isEmpty()) {
                ArrayList<Operation> currentlyRunningOperations = new ArrayList<Operation>(this.mRunningOperations);
                this.mRunningOperations.clear();
                for (Operation operation : currentlyRunningOperations) {
                    if (FragmentManager.isLoggingEnabled(2)) {
                        Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Cancelling operation " + operation));
                    }
                    operation.cancel();
                    if (operation.isComplete()) continue;
                    this.mRunningOperations.add(operation);
                }
                this.updateFinalState();
                ArrayList<Operation> newPendingOperations = new ArrayList<Operation>(this.mPendingOperations);
                this.mPendingOperations.clear();
                this.mRunningOperations.addAll(newPendingOperations);
                for (Operation operation : newPendingOperations) {
                    operation.onStart();
                }
                this.executeOperations(newPendingOperations, this.mOperationDirectionIsPop);
                this.mOperationDirectionIsPop = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceCompleteAllOperations() {
        boolean attachedToWindow = ViewCompat.isAttachedToWindow((View)this.mContainer);
        ArrayList<Operation> arrayList = this.mPendingOperations;
        synchronized (arrayList) {
            this.updateFinalState();
            for (Operation operation : this.mPendingOperations) {
                operation.onStart();
            }
            ArrayList<Operation> runningOperations = new ArrayList<Operation>(this.mRunningOperations);
            for (Operation operation : runningOperations) {
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)"FragmentManager", (String)("SpecialEffectsController: " + (attachedToWindow ? "" : "Container " + this.mContainer + " is not attached to window. ") + "Cancelling running operation " + operation));
                }
                operation.cancel();
            }
            ArrayList<Operation> arrayList2 = new ArrayList<Operation>(this.mPendingOperations);
            for (Operation operation : arrayList2) {
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)"FragmentManager", (String)("SpecialEffectsController: " + (attachedToWindow ? "" : "Container " + this.mContainer + " is not attached to window. ") + "Cancelling pending operation " + operation));
                }
                operation.cancel();
            }
        }
    }

    private void updateFinalState() {
        for (Operation operation : this.mPendingOperations) {
            if (operation.getLifecycleImpact() != Operation.LifecycleImpact.ADDING) continue;
            Fragment fragment = operation.getFragment();
            View view = fragment.requireView();
            Operation.State finalState = Operation.State.from(view.getVisibility());
            operation.mergeWith(finalState, Operation.LifecycleImpact.NONE);
        }
    }

    abstract void executeOperations(@NonNull List<Operation> var1, boolean var2);

    private static class FragmentStateManagerOperation
    extends Operation {
        @NonNull
        private final FragmentStateManager mFragmentStateManager;

        FragmentStateManagerOperation(@NonNull Operation.State finalState, @NonNull Operation.LifecycleImpact lifecycleImpact, @NonNull FragmentStateManager fragmentStateManager, @NonNull CancellationSignal cancellationSignal) {
            super(finalState, lifecycleImpact, fragmentStateManager.getFragment(), cancellationSignal);
            this.mFragmentStateManager = fragmentStateManager;
        }

        @Override
        void onStart() {
            if (this.getLifecycleImpact() == Operation.LifecycleImpact.ADDING) {
                View view;
                Fragment fragment = this.mFragmentStateManager.getFragment();
                View focusedView = fragment.mView.findFocus();
                if (focusedView != null) {
                    fragment.setFocusedView(focusedView);
                    if (FragmentManager.isLoggingEnabled(2)) {
                        Log.v((String)"FragmentManager", (String)("requestFocus: Saved focused view " + focusedView + " for Fragment " + fragment));
                    }
                }
                if ((view = this.getFragment().requireView()).getParent() == null) {
                    this.mFragmentStateManager.addViewToContainer();
                    view.setAlpha(0.0f);
                }
                if (view.getAlpha() == 0.0f && view.getVisibility() == 0) {
                    view.setVisibility(4);
                }
                view.setAlpha(fragment.getPostOnViewCreatedAlpha());
            }
        }

        @Override
        public void complete() {
            super.complete();
            this.mFragmentStateManager.moveToExpectedState();
        }
    }

    static class Operation {
        @NonNull
        private State mFinalState;
        @NonNull
        private LifecycleImpact mLifecycleImpact;
        @NonNull
        private final Fragment mFragment;
        @NonNull
        private final List<Runnable> mCompletionListeners = new ArrayList<Runnable>();
        @NonNull
        private final HashSet<CancellationSignal> mSpecialEffectsSignals = new HashSet();
        private boolean mIsCanceled = false;
        private boolean mIsComplete = false;

        Operation(@NonNull State finalState, @NonNull LifecycleImpact lifecycleImpact, @NonNull Fragment fragment, @NonNull CancellationSignal cancellationSignal) {
            this.mFinalState = finalState;
            this.mLifecycleImpact = lifecycleImpact;
            this.mFragment = fragment;
            cancellationSignal.setOnCancelListener(new CancellationSignal.OnCancelListener(){

                @Override
                public void onCancel() {
                    Operation.this.cancel();
                }
            });
        }

        @NonNull
        public State getFinalState() {
            return this.mFinalState;
        }

        @NonNull
        LifecycleImpact getLifecycleImpact() {
            return this.mLifecycleImpact;
        }

        @NonNull
        public final Fragment getFragment() {
            return this.mFragment;
        }

        final boolean isCanceled() {
            return this.mIsCanceled;
        }

        @NonNull
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Operation ");
            sb.append("{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append("} ");
            sb.append("{");
            sb.append("mFinalState = ");
            sb.append((Object)this.mFinalState);
            sb.append("} ");
            sb.append("{");
            sb.append("mLifecycleImpact = ");
            sb.append((Object)this.mLifecycleImpact);
            sb.append("} ");
            sb.append("{");
            sb.append("mFragment = ");
            sb.append(this.mFragment);
            sb.append("}");
            return sb.toString();
        }

        final void cancel() {
            if (this.isCanceled()) {
                return;
            }
            this.mIsCanceled = true;
            if (this.mSpecialEffectsSignals.isEmpty()) {
                this.complete();
            } else {
                ArrayList<CancellationSignal> signals = new ArrayList<CancellationSignal>(this.mSpecialEffectsSignals);
                for (CancellationSignal signal : signals) {
                    signal.cancel();
                }
            }
        }

        final void mergeWith(@NonNull State finalState, @NonNull LifecycleImpact lifecycleImpact) {
            switch (lifecycleImpact) {
                case ADDING: {
                    if (this.mFinalState != State.REMOVED) break;
                    if (FragmentManager.isLoggingEnabled(2)) {
                        Log.v((String)"FragmentManager", (String)("SpecialEffectsController: For fragment " + this.mFragment + " mFinalState = REMOVED -> VISIBLE. mLifecycleImpact = " + (Object)((Object)this.mLifecycleImpact) + " to ADDING."));
                    }
                    this.mFinalState = State.VISIBLE;
                    this.mLifecycleImpact = LifecycleImpact.ADDING;
                    break;
                }
                case REMOVING: {
                    if (FragmentManager.isLoggingEnabled(2)) {
                        Log.v((String)"FragmentManager", (String)("SpecialEffectsController: For fragment " + this.mFragment + " mFinalState = " + (Object)((Object)this.mFinalState) + " -> REMOVED. mLifecycleImpact  = " + (Object)((Object)this.mLifecycleImpact) + " to REMOVING."));
                    }
                    this.mFinalState = State.REMOVED;
                    this.mLifecycleImpact = LifecycleImpact.REMOVING;
                    break;
                }
                case NONE: {
                    if (this.mFinalState == State.REMOVED) break;
                    if (FragmentManager.isLoggingEnabled(2)) {
                        Log.v((String)"FragmentManager", (String)("SpecialEffectsController: For fragment " + this.mFragment + " mFinalState = " + (Object)((Object)this.mFinalState) + " -> " + (Object)((Object)finalState) + ". "));
                    }
                    this.mFinalState = finalState;
                }
            }
        }

        final void addCompletionListener(@NonNull Runnable listener) {
            this.mCompletionListeners.add(listener);
        }

        void onStart() {
        }

        public final void markStartedSpecialEffect(@NonNull CancellationSignal signal) {
            this.onStart();
            this.mSpecialEffectsSignals.add(signal);
        }

        public final void completeSpecialEffect(@NonNull CancellationSignal signal) {
            if (this.mSpecialEffectsSignals.remove(signal) && this.mSpecialEffectsSignals.isEmpty()) {
                this.complete();
            }
        }

        final boolean isComplete() {
            return this.mIsComplete;
        }

        @CallSuper
        public void complete() {
            if (this.mIsComplete) {
                return;
            }
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)"FragmentManager", (String)("SpecialEffectsController: " + this + " has called complete."));
            }
            this.mIsComplete = true;
            for (Runnable listener : this.mCompletionListeners) {
                listener.run();
            }
        }

        static enum LifecycleImpact {
            NONE,
            ADDING,
            REMOVING;

        }

        static enum State {
            REMOVED,
            VISIBLE,
            GONE,
            INVISIBLE;


            @NonNull
            static State from(@NonNull View view) {
                if (view.getAlpha() == 0.0f && view.getVisibility() == 0) {
                    return INVISIBLE;
                }
                return State.from(view.getVisibility());
            }

            @NonNull
            static State from(int visibility) {
                switch (visibility) {
                    case 0: {
                        return VISIBLE;
                    }
                    case 4: {
                        return INVISIBLE;
                    }
                    case 8: {
                        return GONE;
                    }
                }
                throw new IllegalArgumentException("Unknown visibility " + visibility);
            }

            void applyState(@NonNull View view) {
                switch (this) {
                    case REMOVED: {
                        ViewGroup parent = (ViewGroup)view.getParent();
                        if (parent == null) break;
                        if (FragmentManager.isLoggingEnabled(2)) {
                            Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Removing view " + view + " from container " + parent));
                        }
                        parent.removeView(view);
                        break;
                    }
                    case VISIBLE: {
                        if (FragmentManager.isLoggingEnabled(2)) {
                            Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Setting view " + view + " to VISIBLE"));
                        }
                        view.setVisibility(0);
                        break;
                    }
                    case GONE: {
                        if (FragmentManager.isLoggingEnabled(2)) {
                            Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Setting view " + view + " to GONE"));
                        }
                        view.setVisibility(8);
                        break;
                    }
                    case INVISIBLE: {
                        if (FragmentManager.isLoggingEnabled(2)) {
                            Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Setting view " + view + " to INVISIBLE"));
                        }
                        view.setVisibility(4);
                    }
                }
            }
        }
    }
}

