/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.android.component;

import android.os.Bundle;
import androidx.annotation.Nullable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.homunculus.android.compat.EventAppCompatActivity;
import org.homunculus.android.component.DefaultAndroidNavigation;
import org.homunculus.android.component.DefaultHomunculusScope;
import org.homunculus.android.component.module.uncaughtexception.UncaughtException;
import org.homunculus.android.core.ActivityEventDispatcher;
import org.homunculusframework.factory.container.Binding;
import org.homunculusframework.factory.container.Handler;
import org.homunculusframework.factory.flavor.hcf.ScopeElement;
import org.homunculusframework.factory.scope.ContextScope;
import org.homunculusframework.factory.scope.Scope;
import org.homunculusframework.factory.serializer.Serializable;
import org.homunculusframework.factory.serializer.Serializer;
import org.homunculusframework.navigation.Navigation;
import org.slf4j.LoggerFactory;

public abstract class HomunculusActivity<T extends ContextScope<?>>
extends EventAppCompatActivity
implements Thread.UncaughtExceptionHandler {
    private static final String HC_NAVIGATION_STACK = "HC_NAVIGATION_STACK";
    private T scope;
    private Navigation navigation;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.init(savedInstanceState);
    }

    protected void init(@Nullable Bundle savedInstanceState) {
        this.scope = this.createScope();
        this.navigation = this.createNavigation();
        this.scope.onCreate();
        if (savedInstanceState != null) {
            if (this.restoreStackState(savedInstanceState)) {
                if (!this.onStackRestored(this.navigation, savedInstanceState)) {
                    this.navigation.reload();
                }
            } else {
                this.navigation.forward(this.create());
            }
        } else {
            this.navigation.forward(this.create());
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        T scope = this.scope;
        if (scope != null) {
            scope.onDestroy();
        }
    }

    public T getScope() {
        return this.scope;
    }

    protected abstract T createScope();

    protected boolean onStackRestored(Navigation navigation, @Nullable Bundle savedInstanceState) {
        return false;
    }

    protected Navigation createNavigation() {
        DefaultHomunculusScope scope = (DefaultHomunculusScope)this.getScope().getParent();
        return new DefaultAndroidNavigation((Scope)this.getScope(), (Handler)scope.getBackgroundHandler(), (Handler)scope.getMainHandler());
    }

    @Override
    @ScopeElement
    public ActivityEventDispatcher<EventAppCompatActivity> getEventDispatcher() {
        return super.getEventDispatcher();
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.saveStackState(outState);
    }

    protected void saveStackState(Bundle outState) {
        Navigation nb = this.getNavigation();
        if (nb instanceof Navigation) {
            ArrayList tmp = new ArrayList(nb.getStack());
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                this.getInstanceStateSerializer().serialize(tmp, (OutputStream)bout);
                outState.putByteArray(HC_NAVIGATION_STACK, bout.toByteArray());
            }
            catch (IOException e) {
                outState.putByteArray(HC_NAVIGATION_STACK, null);
                LoggerFactory.getLogger(this.getClass()).warn("onSaveInstanceState: the navigation stack contains a value which is not serializable by {}. Reason:", (Object)this.getInstanceStateSerializer(), (Object)e);
            }
        } else {
            outState.putByteArray(HC_NAVIGATION_STACK, null);
            LoggerFactory.getLogger(this.getClass()).warn("onSaveInstanceState: getNavigation() does not provide a Navigation instance");
        }
    }

    protected boolean restoreStackState(Bundle savedInstanceState) {
        byte[] serializedStack = savedInstanceState.getByteArray(HC_NAVIGATION_STACK);
        Navigation nb = this.getNavigation();
        if (serializedStack != null && serializedStack.length > 0) {
            ByteArrayInputStream bin = new ByteArrayInputStream(serializedStack);
            try {
                ArrayList tmp = (ArrayList)this.getInstanceStateSerializer().deserialize((InputStream)bin, ArrayList.class);
                this.navigation.getStack().clear();
                this.navigation.getStack().addAll(tmp);
                return true;
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).warn("onRestoreInstanceState: the serialized navigation stack contains a value which is not deserializable by {}. Reason:", (Object)this.getInstanceStateSerializer(), (Object)e);
                return false;
            }
        }
        return false;
    }

    protected Serializer getInstanceStateSerializer() {
        return new Serializable();
    }

    @ScopeElement
    public Navigation getNavigation() {
        return this.navigation;
    }

    @Override
    public void onBackPressed() {
        if (!this.onDispatchNavigationBackPressed()) {
            super.onBackPressed();
        }
    }

    protected abstract Binding<?, ?> create();

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        Navigation nav = this.getNavigation();
        if (nav != null) {
            nav.redirect((Binding)new UncaughtException.BindUncaughtException(e, null));
        } else {
            LoggerFactory.getLogger(this.getClass()).error("failed to handle uncaught exception, no navigation present. Uncaught Exception: ", e);
        }
    }
}

