/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.android.component;

import android.app.Activity;
import android.content.Intent;
import org.homunculus.android.core.ActivityCallback;
import org.homunculus.android.core.ActivityEventDispatcher;
import org.homunculus.android.flavor.AndroidMainHandler;
import org.homunculusframework.concurrent.Task;
import org.homunculusframework.factory.scope.LifecycleOwner;
import org.homunculusframework.lang.Function;
import org.homunculusframework.lang.Procedure;
import org.homunculusframework.lang.Result;

public final class Intents {
    public static final String TAG_ACTIVITY_NOT_FOUND = "intents.activity.notfound";
    public static final String TAG_UNACCEPTED_RESULT_CODE = "intents.resultcode.unaccepted";
    private final ActivityEventDispatcher dispatcher;
    private final LifecycleOwner lifecycleOwner;

    public Intents(LifecycleOwner lifecycleOwner, ActivityEventDispatcher dispatcher) {
        this.dispatcher = dispatcher;
        this.lifecycleOwner = lifecycleOwner;
    }

    public void startActivityForResult(Intent intent, int requestCode) {
        this.dispatcher.getActivity().startActivityForResult(intent, requestCode);
    }

    public void registerOnActivityResult(final int requestCode, final Function<ActivityEventDispatcher.ActivityResult, Boolean> callback) {
        AndroidMainHandler.assertMainThread();
        final ActivityCallback cb = new ActivityCallback(this.lifecycleOwner, this.dispatcher);
        cb.setDelegate(new ActivityEventDispatcher.AbsActivityEventCallback(){

            @Override
            public boolean onActivityResult(Activity activity, int rCode, int resultCode, Intent data) {
                if (requestCode == rCode) {
                    cb.setDelegate(null);
                    return (Boolean)callback.apply((Object)new ActivityEventDispatcher.ActivityResult(activity, requestCode, resultCode, data));
                }
                return false;
            }
        });
        ActivityEventDispatcher.ActivityResult res = this.dispatcher.consumeActivityResult(requestCode);
        if (res != null) {
            callback.apply((Object)res);
        }
    }

    public Activity getContext() {
        return this.dispatcher.getActivity();
    }

    public static interface ResultIntent<R> {
        public Task<Result<Boolean>> invoke();

        public void whenReceived(Procedure<R> var1);
    }
}

