/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.android.component;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import org.homunculus.android.core.AndroidScopeContext;
import org.homunculusframework.factory.scope.Scope;
import org.slf4j.LoggerFactory;

public class UnbreakableCrashHandler {
    private final Handler mMainHandler = new Handler(Looper.getMainLooper());
    private Context mAppContext;

    public void install(Context context, final @Nullable Thread.UncaughtExceptionHandler handler) {
        this.mAppContext = context;
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                UnbreakableCrashHandler.this.print(e);
                UnbreakableCrashHandler.this.resurrect(t, e, handler);
            }
        });
    }

    public void install(Context context) {
        this.install(context, null);
    }

    protected void print(Throwable e) {
        LoggerFactory.getLogger(this.getClass()).error("caught uncaught exception", e);
    }

    protected void resurrect(Thread t, Throwable e, @Nullable Thread.UncaughtExceptionHandler handler) {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            this.fixRenderingAndDispatchCrash(t, e, handler);
            while (true) {
                try {
                    Looper.loop();
                    throw new RuntimeException("Main thread loop unexpectedly exited");
                }
                catch (Throwable followUpExceptions) {
                    this.print(e);
                    this.fixRenderingAndDispatchCrash(t, e, handler);
                    continue;
                }
                break;
            }
        }
        this.fixRenderingAndDispatchCrash(t, e, handler);
    }

    protected void fixRenderingAndDispatchCrash(final Thread t, final Throwable e, final @Nullable Thread.UncaughtExceptionHandler handler) {
        Thread otherThread = new Thread(){

            @Override
            public void run() {
                UnbreakableCrashHandler.this.mMainHandler.post(() -> {
                    Scope appScope;
                    if (handler != null) {
                        handler.uncaughtException(t, e);
                    }
                    if ((appScope = AndroidScopeContext.getScope(UnbreakableCrashHandler.this.mAppContext)) != null) {
                        UnbreakableCrashHandler.this.recursiveFixUI(appScope);
                        UnbreakableCrashHandler.this.recursiveDispatch(appScope, t, e);
                    }
                });
            }
        };
        otherThread.setName("pacemaker");
        otherThread.start();
    }

    protected void recursiveFixUI(Scope root) {
        root.forEachEntry(entry -> {
            if (entry instanceof Activity) {
                Activity activity = (Activity)entry;
                FrameLayout tmp = new FrameLayout((Context)activity);
                activity.setContentView((View)tmp);
                LoggerFactory.getLogger(this.getClass()).warn("reset content view with empty view");
                this.launch(activity);
                this.mMainHandler.postDelayed(() -> this.launch(activity), 100L);
            }
            return true;
        });
        root.forEachScope(scope -> {
            this.recursiveFixUI((Scope)scope);
            return true;
        });
    }

    protected void launch(Activity activity) {
        try {
            activity.startActivity(new Intent((Context)activity, RecoverActivity.class));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void recursiveDispatch(Scope root, Thread t, Throwable e) {
        root.forEachEntry(entry -> {
            if (entry instanceof Thread.UncaughtExceptionHandler) {
                ((Thread.UncaughtExceptionHandler)entry).uncaughtException(t, e);
            }
            return true;
        });
        root.forEachScope(scope -> {
            this.recursiveDispatch((Scope)scope, t, e);
            return true;
        });
    }

    public static class RecoverActivity
    extends Activity {
        protected void onCreate(@Nullable Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.getWindow().getDecorView().setBackgroundResource(17170445);
            this.finish();
        }
    }
}

