/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.android.component.module.storage;

import android.content.Context;
import androidx.annotation.Nullable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.homunculusframework.factory.serializer.Serializable;
import org.homunculusframework.factory.serializer.Serializer;
import org.homunculusframework.lang.Destroyable;
import org.homunculusframework.lang.Panic;
import org.homunculusframework.lang.Reference;
import org.homunculusframework.lang.Reflection;
import org.slf4j.LoggerFactory;

public class Persistent<T>
implements Reference<T>,
Destroyable {
    private final File targetDir;
    private final String name;
    private final Serializer serializer;
    private volatile T value;

    public Persistent(File targetDir, String name, Serializer serializer) {
        this.serializer = serializer;
        this.targetDir = targetDir;
        this.name = name;
        try {
            this.load();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("failed to load", (Throwable)e);
        }
    }

    public Persistent(Context context, String name) {
        this(new File(context.getFilesDir(), "persistent"), name, (Serializer)new Serializable());
    }

    @Nullable
    public T get() {
        return this.value;
    }

    public void set(@Nullable T value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        Persistent persistent = this;
        synchronized (persistent) {
            this.value = Persistent.read(this.targetDir, this.name, this.serializer, Object.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        Persistent persistent = this;
        synchronized (persistent) {
            Persistent.write(this.targetDir, this.name, this.serializer, Object.class, this.value);
        }
    }

    public void destroy() {
        try {
            this.save();
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("failed to save", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Persistent persistent = this;
        synchronized (persistent) {
            if (this.value == null) {
                return null;
            }
            return this.value.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File targetDir, String name, Serializer serializer, Class<?> type, Object obj) throws IOException {
        File tmp;
        File dstFile;
        block10: {
            dstFile = new File(targetDir, Reflection.getName(type) + "_" + name + "." + serializer.getId());
            if (obj == null && !dstFile.delete()) {
                if (dstFile.exists()) {
                    throw new IOException("cannot remove target file " + dstFile);
                }
                return;
            }
            tmp = new File(targetDir, UUID.randomUUID().toString());
            try {
                tmp.createNewFile();
            }
            catch (IOException e) {
                dstFile.getParentFile().mkdirs();
                if (tmp.createNewFile()) break block10;
                throw new IOException("failed to allocate tmp file " + tmp);
            }
        }
        try (FileOutputStream fout = new FileOutputStream(tmp);){
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            if (!serializer.serialize(obj, (OutputStream)bout)) {
                throw new Panic("the serializer " + serializer + " rejected serialization");
            }
            bout.flush();
        }
        if (!dstFile.delete() && dstFile.exists()) {
            throw new IOException("unable to delete " + dstFile);
        }
        if (!tmp.renameTo(dstFile)) {
            throw new IOException("unable to move " + tmp + " -> " + dstFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <T> T read(File targetDir, String name, Serializer serializer, Class<T> type) throws IOException {
        File dstFile = new File(targetDir, Reflection.getName(type) + "_" + name + "." + serializer.getId());
        if (dstFile.length() == 0L) {
            return null;
        }
        try (FileInputStream fin = new FileInputStream(dstFile);){
            Object res;
            BufferedInputStream bin = new BufferedInputStream(fin);
            Object object = res = serializer.deserialize((InputStream)bin, type);
            return (T)object;
        }
    }
}

