/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.android.component.module.uncaughtexception;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Scanner;
import org.homunculusframework.lang.Panic;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class Supportiety {
    private static final String API_CREATE = "1.0/receiver/ticket";
    private static final String API_UPLOAD = "1.0/receiver/ticket/{secret}";
    private final String endpointURL;
    private final String clientId;
    private final String clientSecret;

    private Supportiety(String endpointURL, String clientId, String clientSecret) {
        if (!endpointURL.endsWith("/")) {
            endpointURL = endpointURL + "/";
        }
        this.endpointURL = endpointURL;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public static Supportiety createCustom(String endpointURL, String clientId, String clientSecret) {
        return new Supportiety(endpointURL, clientId, clientSecret);
    }

    public Ticket createTicket(ApplicationDetails details) throws IOException, ProtocolException {
        InputStream in;
        JSONObject json = new JSONObject();
        try {
            json.put("applicationId", (Object)details.getApplicationId());
            json.put("versionName", (Object)details.getVersionName());
            json.put("versionNum", details.getVersionNum());
        }
        catch (JSONException e) {
            throw new Panic((Throwable)e);
        }
        HttpURLConnection conn = (HttpURLConnection)new URL(this.endpointURL + API_CREATE).openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("clientId", this.clientId);
        conn.setRequestProperty("clientSecret", this.clientSecret);
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setDoOutput(true);
        conn.getOutputStream().write(json.toString().getBytes("UTF-8"));
        try {
            in = conn.getInputStream();
        }
        catch (IOException e) {
            in = conn.getErrorStream();
        }
        Scanner s = new Scanner(in).useDelimiter("\\A");
        String result = s.hasNext() ? s.next() : "";
        try {
            JSONObject resp = new JSONObject(result);
            return new Ticket(resp.getString("ticketId"), resp.getString("ticketSecretId"));
        }
        catch (JSONException e) {
            throw new ProtocolException(result, e);
        }
    }

    public TicketFile appendTrace(Ticket ticket, Throwable t) throws IOException, ProtocolException {
        return this.appendBlob(ticket, "trace.json", new ByteArrayInputStream(this.asTrace(t).toString().getBytes("UTF-8")));
    }

    public TicketFile appendBlob(Ticket ticket, String name, InputStream src) throws IOException, ProtocolException {
        InputStream in;
        int read;
        HttpURLConnection conn = (HttpURLConnection)new URL(this.endpointURL + API_UPLOAD.replace("{secret}", ticket.getSecret())).openConnection();
        conn.setRequestMethod("PUT");
        conn.setRequestProperty("clientId", this.clientId);
        conn.setRequestProperty("clientSecret", this.clientSecret);
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("ticketSecretId", ticket.getSecret());
        conn.setRequestProperty("blobName", name);
        conn.setDoOutput(true);
        OutputStream out = conn.getOutputStream();
        byte[] buf = new byte[8192];
        while ((read = src.read(buf)) != -1) {
            out.write(buf, 0, read);
        }
        try {
            in = conn.getInputStream();
        }
        catch (IOException e) {
            in = conn.getErrorStream();
        }
        Scanner s = new Scanner(in).useDelimiter("\\A");
        String result = s.hasNext() ? s.next() : "";
        try {
            JSONObject resp = new JSONObject(result);
            return new TicketFile(resp.getString("ticketId"), resp.getString("sha2"), resp.getLong("fileId"), resp.getString("sha2"), resp.getLong("size"));
        }
        catch (JSONException e) {
            throw new ProtocolException(result, e);
        }
    }

    private JSONObject asTrace(Throwable t) {
        JSONObject res = new JSONObject();
        try {
            this.insert(res, t);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return res;
    }

    private void insert(JSONObject obj, Throwable throwable) throws JSONException {
        obj.put("msg", (Object)throwable.getMessage());
        obj.put("type", (Object)throwable.getClass().getName());
        this.insertStacktrace(obj, throwable.getStackTrace());
        try {
            Throwable[] suppressed = throwable.getSuppressed();
            if (suppressed != null && suppressed.length > 0) {
                JSONArray supp = new JSONArray();
                for (Throwable t : suppressed) {
                    JSONObject dst = new JSONObject();
                    this.insert(dst, t);
                    supp.put((Object)dst);
                }
                obj.put("suppressed", (Object)supp);
            }
        }
        catch (Error e) {
            System.err.println("no suppressed support");
        }
        if (throwable.getCause() != null) {
            JSONObject causedBy = new JSONObject();
            this.insert(causedBy, throwable.getCause());
            obj.put("causedBy", (Object)causedBy);
        }
    }

    private void insertStacktrace(JSONObject obj, StackTraceElement[] stackTraceElements) throws JSONException {
        JSONArray trace = new JSONArray();
        for (StackTraceElement elem : stackTraceElements) {
            JSONObject stack = new JSONObject();
            stack.put("c", (Object)elem.getClassName());
            stack.put("m", (Object)elem.getMethodName());
            stack.put("f", (Object)elem.getFileName());
            stack.put("l", elem.getLineNumber());
            stack.put("n", elem.isNativeMethod());
            trace.put((Object)stack);
        }
        obj.put("trace", (Object)trace);
    }

    public static final class ProtocolException
    extends Exception {
        public ProtocolException() {
        }

        public ProtocolException(String message) {
            super(message);
        }

        public ProtocolException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static final class Ticket {
        private final String id;
        private final String secret;

        public Ticket(String id2, String secret) {
            this.id = id2;
            this.secret = secret;
        }

        public String getId() {
            return this.id;
        }

        public String getSecret() {
            return this.secret;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Ticket ticket = (Ticket)o;
            if (!this.id.equals(ticket.id)) {
                return false;
            }
            return this.secret.equals(ticket.secret);
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + this.secret.hashCode();
            return result;
        }

        public String toString() {
            return "Ticket{id='" + this.id + '\'' + ", secret='" + this.secret + '\'' + '}';
        }
    }

    public static final class ApplicationDetails {
        private final String applicationId;
        private final String versionName;
        private final long versionNum;

        public ApplicationDetails(String applicationId, String versionName, long versionNum) {
            this.applicationId = applicationId;
            this.versionName = versionName;
            this.versionNum = versionNum;
        }

        public String getApplicationId() {
            return this.applicationId;
        }

        public String getVersionName() {
            return this.versionName;
        }

        public long getVersionNum() {
            return this.versionNum;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ApplicationDetails that = (ApplicationDetails)o;
            if (this.versionNum != that.versionNum) {
                return false;
            }
            if (!this.applicationId.equals(that.applicationId)) {
                return false;
            }
            return this.versionName.equals(that.versionName);
        }

        public int hashCode() {
            int result = this.applicationId.hashCode();
            result = 31 * result + this.versionName.hashCode();
            result = 31 * result + (int)(this.versionNum ^ this.versionNum >>> 32);
            return result;
        }

        public String toString() {
            return "ApplicationDetails{applicationId='" + this.applicationId + '\'' + ", versionName='" + this.versionName + '\'' + ", versionNum=" + this.versionNum + '}';
        }
    }

    public static final class TicketFile {
        private final String ticketId;
        private final String ticketSecret;
        private final long id;
        private final String sha2;
        private final long size;

        public TicketFile(String ticketId, String ticketSecret, long id2, String sha2, long size) {
            this.ticketId = ticketId;
            this.ticketSecret = ticketSecret;
            this.id = id2;
            this.sha2 = sha2;
            this.size = size;
        }

        public String getTicketId() {
            return this.ticketId;
        }

        public String getTicketSecret() {
            return this.ticketSecret;
        }

        public long getId() {
            return this.id;
        }

        public String getSha2() {
            return this.sha2;
        }

        public long getSize() {
            return this.size;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TicketFile that = (TicketFile)o;
            if (this.id != that.id) {
                return false;
            }
            if (this.size != that.size) {
                return false;
            }
            if (!this.ticketId.equals(that.ticketId)) {
                return false;
            }
            if (!this.ticketSecret.equals(that.ticketSecret)) {
                return false;
            }
            return this.sha2.equals(that.sha2);
        }

        public int hashCode() {
            int result = this.ticketId.hashCode();
            result = 31 * result + this.ticketSecret.hashCode();
            result = 31 * result + (int)(this.id ^ this.id >>> 32);
            result = 31 * result + this.sha2.hashCode();
            result = 31 * result + (int)(this.size ^ this.size >>> 32);
            return result;
        }

        public String toString() {
            return "TicketFile{ticketId='" + this.ticketId + '\'' + ", ticketSecret='" + this.ticketSecret + '\'' + ", id=" + this.id + ", sha2='" + this.sha2 + '\'' + ", size=" + this.size + '}';
        }
    }
}

