/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.android.component.module.uncaughtexception;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import androidx.annotation.Nullable;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.homunculus.android.component.MaterialFont;
import org.homunculus.android.component.MaterialFontView;
import org.homunculus.android.component.R;
import org.homunculus.android.component.module.uncaughtexception.Reporter;
import org.homunculusframework.factory.container.ObjectBinding;
import org.homunculusframework.factory.scope.AbsScope;
import org.homunculusframework.factory.scope.ContextScope;
import org.homunculusframework.factory.scope.Scope;
import org.homunculusframework.lang.Function;
import org.homunculusframework.lang.Result;
import org.homunculusframework.navigation.Navigation;

@Named(value="hcf/uncaughtexception")
public class UncaughtException {
    public static final String NAME = "hcf/uncaughtexception";
    public static final String PARAM_THROWABLE = "throwable";
    public static final String PARAM_RESULT = "result";
    @Inject
    private Activity activity;
    @Nullable
    private Throwable throwable;
    @Nullable
    private Result<?> result;
    @Nullable
    private Reporter reporter;
    private Navigation navigation;
    private Scope scope;

    private void apply() {
        View v = LayoutInflater.from((Context)this.activity).inflate(R.layout.hcf_uncaughtexception, null);
        this.activity.setContentView(v);
        View btnBack = v.findViewById(R.id.hcf_uncaughtexception_button_back);
        if (this.navigation == null) {
            btnBack.setVisibility(8);
        } else {
            btnBack.setOnClickListener(view -> {
                if (!this.navigation.backward()) {
                    this.activity.finish();
                }
            });
        }
        View btnSend = v.findViewById(R.id.hcf_uncaughtexception_button_send);
        if (this.reporter == null) {
            btnSend.setVisibility(8);
        } else {
            btnSend.setOnClickListener(view -> {
                TreeMap<String, Object> additional = new TreeMap<String, Object>();
                additional.put(PARAM_RESULT, this.result);
                additional.put(PARAM_THROWABLE, this.throwable);
                this.reporter.report(this.scope, additional).whenDone(res -> {
                    AlertDialog.Builder dlg = new AlertDialog.Builder((Context)this.activity);
                    if (res.exists()) {
                        dlg.setMessage((CharSequence)this.activity.getResources().getString(R.string.hcf_uncaughtexception_submitted, new Object[]{res.get()}));
                    } else {
                        res.log();
                        dlg.setMessage((CharSequence)this.activity.getResources().getString(R.string.hcf_uncaughtexception_submission_failed));
                    }
                    dlg.setNeutralButton(R.string.hcf_action_ok, (dialog, which) -> dialog.dismiss());
                    dlg.show();
                });
            });
        }
        View icon = v.findViewById(R.id.hcf_uncaughtexception_image);
        if (icon instanceof MaterialFontView) {
            ((MaterialFontView)icon).setIcon(MaterialFont.Icon.I_ERROR_OUTLINE);
        }
    }

    public static class UncaughtExceptionScope
    extends AbsScope
    implements ContextScope<UncaughtException> {
        private Scope parent;
        private UncaughtException value;

        public UncaughtExceptionScope(Scope parent, UncaughtException value) {
            this.parent = parent;
            this.value = value;
        }

        public void onCreate() {
            super.onCreate();
            this.value.apply();
        }

        public Scope getParent() {
            return this.parent;
        }

        public UncaughtException getContext() {
            return this.value;
        }

        @Nullable
        public <T> T resolve(Class<T> type) {
            return null;
        }

        public void forEachEntry(Function<Object, Boolean> closure) {
        }
    }

    public static class BindUncaughtException
    extends ObjectBinding<UncaughtExceptionScope, Scope> {
        private Throwable throwable;
        private Result<?> result;

        public BindUncaughtException(@Nullable Throwable throwable, @Nullable Result<?> result) {
            this.throwable = throwable;
            this.result = result;
        }

        public UncaughtExceptionScope create(Scope scope) throws Exception {
            UncaughtException obj = new UncaughtException();
            UncaughtExceptionScope eScope = new UncaughtExceptionScope(scope, obj);
            obj.activity = (Activity)scope.resolve(Activity.class);
            obj.navigation = (Navigation)scope.resolve(Navigation.class);
            obj.reporter = (Reporter)scope.resolve(Reporter.class);
            obj.result = this.result;
            obj.scope = (Scope)eScope;
            obj.throwable = this.throwable;
            return eScope;
        }
    }
}

