/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.android.component.module.validator;

import android.content.Context;
import java.util.Locale;
import javax.inject.Singleton;
import javax.validation.Configuration;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.homunculus.android.component.module.validator.BindingResult;
import org.homunculus.android.component.module.validator.UnsupportedDeviceValidator;
import org.homunculusframework.annotations.Unfinished;
import org.slf4j.LoggerFactory;

@Singleton
@Unfinished
public class HomunculusValidator {
    private final Validator validator;

    public static HomunculusValidator createDefaultValidator() {
        return new HomunculusValidator(false, null);
    }

    public static HomunculusValidator createAndroidResourceMessagesValidator(Context context) {
        return new HomunculusValidator(true, context);
    }

    private HomunculusValidator(boolean buildForAndroidMessages, final Context androidContext) {
        Validator validator;
        try {
            Configuration validationConfig = Validation.byDefaultProvider().configure().ignoreXmlConfiguration();
            if (buildForAndroidMessages) {
                validationConfig.messageInterpolator(new MessageInterpolator(){

                    public String interpolate(String messageTemplate, MessageInterpolator.Context context) {
                        try {
                            int id2 = androidContext.getResources().getIdentifier(messageTemplate, "string", androidContext.getApplicationContext().getPackageName());
                            return androidContext.getString(id2);
                        }
                        catch (Exception e) {
                            LoggerFactory.getLogger(this.getClass()).info("Could not find resource: " + messageTemplate);
                            return messageTemplate;
                        }
                    }

                    public String interpolate(String messageTemplate, MessageInterpolator.Context context, Locale locale) {
                        return this.interpolate(messageTemplate, context);
                    }
                });
            }
            ValidatorFactory validatorFactory = validationConfig.buildValidatorFactory();
            validator = validatorFactory.getValidator();
        }
        catch (ExceptionInInitializerError e) {
            LoggerFactory.getLogger(this.getClass()).error("Could not initialize Validator on this device! Validation via Validator will not work!", (Throwable)e);
            validator = new UnsupportedDeviceValidator();
        }
        this.validator = validator;
    }

    public <T> BindingResult<T> validate(T object, Class<?> ... groups) {
        return new BindingResult(this.validator.validate(object, (Class[])groups));
    }
}

