/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.android.component.module.validator.conversionAdapters;

import com.google.android.material.textfield.TextInputLayout;
import java.text.MessageFormat;
import org.homunculus.android.component.module.validator.ViewErrorHandler;
import org.homunculus.android.component.module.validator.conversionAdapters.ConversionAdapter;
import org.homunculus.android.component.module.validator.viewErrorHandlers.TextInputLayoutViewErrorHandler;

public class DoubleToTextInputLayoutAdapter
implements ConversionAdapter<TextInputLayout, Double> {
    @Override
    public void setFieldValueToView(Double value, TextInputLayout view) {
        try {
            view.getEditText().setText((CharSequence)MessageFormat.format("{0}", value));
        }
        catch (NullPointerException e) {
            throw new RuntimeException("Cannot set text, because EditText in TextInputLayout is null!: " + view.getId(), e);
        }
    }

    @Override
    public Double getFieldValueFromView(TextInputLayout view) {
        try {
            if (view.getEditText().getText() == null) {
                return null;
            }
            try {
                return Double.valueOf(view.getEditText().getText().toString());
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
        catch (NullPointerException e) {
            throw new RuntimeException("Cannot get text, because EditText in TextInputLayout is null!: " + view.getId(), e);
        }
    }

    @Override
    public ViewErrorHandler<TextInputLayout> getErrorHandler() {
        return new TextInputLayoutViewErrorHandler();
    }
}

