/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.android.component.module.validator.conversionAdapters;

import com.google.android.material.textfield.TextInputLayout;
import java.text.MessageFormat;
import org.homunculus.android.component.module.validator.ViewErrorHandler;
import org.homunculus.android.component.module.validator.conversionAdapters.ConversionAdapter;
import org.homunculus.android.component.module.validator.viewErrorHandlers.TextInputLayoutViewErrorHandler;

public class FloatToTextInputLayoutAdapter
implements ConversionAdapter<TextInputLayout, Float> {
    @Override
    public void setFieldValueToView(Float value, TextInputLayout view) {
        try {
            view.getEditText().setText((CharSequence)MessageFormat.format("{0}", value));
        }
        catch (NullPointerException e) {
            throw new RuntimeException("Cannot set text, because EditText in TextInputLayout is null!: " + view.getId(), e);
        }
    }

    @Override
    public Float getFieldValueFromView(TextInputLayout view) {
        try {
            if (view.getEditText().getText() == null) {
                return null;
            }
            try {
                return Float.valueOf(view.getEditText().getText().toString());
            }
            catch (NumberFormatException e) {
                return Float.valueOf(0.0f);
            }
        }
        catch (NullPointerException e) {
            throw new RuntimeException("Cannot get text, because EditText in TextInputLayout is null!: " + view.getId(), e);
        }
    }

    @Override
    public ViewErrorHandler<TextInputLayout> getErrorHandler() {
        return new TextInputLayoutViewErrorHandler();
    }
}

