/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.codegen;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ast.CompilationUnit;
import com.helger.jcodemodel.JCodeModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.homunculus.codegen.XMLFile;
import org.homunculus.codegen.generator.GenerateAsyncControllers;
import org.homunculus.codegen.generator.GenerateBindables;
import org.homunculus.codegen.generator.GenerateMethodBindings;
import org.homunculus.codegen.generator.GenerateScopes;
import org.homunculus.codegen.generator.GenerateTaskMethods;
import org.homunculus.codegen.generator.GenerateViewsFromXML;
import org.homunculus.codegen.generator.PreprocessDiscoverBeans;
import org.homunculus.codegen.parse.FullQualifiedName;
import org.homunculus.codegen.parse.Resolver;
import org.homunculus.codegen.parse.javaparser.JPResolver;
import org.homunculus.codegen.parse.javaparser.SrcFile;
import org.homunculus.codegen.parse.jcodemodel.JCodeModelResolver;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class GenProject {
    private List<SrcFile> units = new ArrayList<SrcFile>();
    private JCodeModel codeModel = new JCodeModel();
    private Map<PreprocessDiscoverBeans.DiscoveryKind, Set<FullQualifiedName>> discoveredKinds = new HashMap<PreprocessDiscoverBeans.DiscoveryKind, Set<FullQualifiedName>>();
    private List<XMLFile> xmlFiles = new ArrayList<XMLFile>();
    private File projectRoot;
    private String manifestPackage;
    private JPResolver resolver;

    public void addFile(File file) throws IOException {
        if (file.getName().toLowerCase().endsWith(".java")) {
            this.addParseJava(file);
        } else if (file.getName().toLowerCase().endsWith(".xml")) {
            this.addParseXml(file);
        }
    }

    public void setManifestPackage(String manifestPackage) {
        this.manifestPackage = manifestPackage;
    }

    public String getManifestPackage() {
        return this.manifestPackage;
    }

    public File getProjectRoot() {
        return this.projectRoot;
    }

    public void setProjectRoot(File file) {
        this.projectRoot = file;
    }

    private void addParseXml(File file) {
        try (FileInputStream in = new FileInputStream(file);){
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource is = new InputSource(in);
            Document doc = builder.parse(is);
            this.xmlFiles.add(new XMLFile(file, doc));
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("failed to parse {}", (Object)file, (Object)e);
        }
    }

    private void addParseJava(File file) {
        try (FileInputStream in = new FileInputStream(file);){
            JavaParser parser = new JavaParser();
            ParseResult cu = parser.parse((InputStream)in);
            cu.getResult().get();
            this.units.add(new SrcFile(file, (CompilationUnit)cu.getResult().get()));
        }
        catch (Exception e) {
            LoggerFactory.getLogger(GenProject.class).error("failed to parse {}", (Object)file, (Object)e);
        }
    }

    public void addDirectory(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (!file.isFile() || !file.getName().toLowerCase().endsWith(".java")) continue;
            this.addFile(file);
        }
    }

    public void clearDir(File dir) throws IOException {
        GenProject.delete(dir);
    }

    static void delete(File f) throws IOException {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            if (files == null) {
                return;
            }
            for (File c : files) {
                GenProject.delete(c);
            }
        }
        if (!f.delete() && f.exists()) {
            throw new FileNotFoundException("Failed to delete file: " + f);
        }
    }

    public void addRecursive(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.addRecursive(file);
                continue;
            }
            if (!file.isFile()) continue;
            this.addFile(file);
        }
    }

    @Nullable
    public SrcFile findSourceFileForType(String fqn) {
        for (SrcFile file : this.units) {
            if (!file.getFullQualifiedNamePrimaryClassName().equals(fqn)) continue;
            return file;
        }
        return null;
    }

    public JCodeModel getCodeModel() {
        return this.codeModel;
    }

    public List<SrcFile> getSrcFiles() {
        return this.units;
    }

    public List<XMLFile> getXmlFiles() {
        return this.xmlFiles;
    }

    public Map<PreprocessDiscoverBeans.DiscoveryKind, Set<FullQualifiedName>> getDiscoveredKinds() {
        return this.discoveredKinds;
    }

    public void generate() throws Exception {
        this.resolver = new JPResolver(new JCodeModelResolver(this.getCodeModel()), this.units);
        new GenerateViewsFromXML().generate(this);
        new PreprocessDiscoverBeans().generate(this);
        new GenerateAsyncControllers().generate(this);
        new GenerateScopes().generate(this);
        new GenerateBindables().generate(this);
        new GenerateTaskMethods().generate(this);
        new GenerateMethodBindings().generate(this);
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    public void emitGeneratedClass(File targetDir) throws IOException {
        this.codeModel.build(targetDir, System.out);
    }

    public String getDisclaimer(Class<?> clazz) {
        return "DO NOT MODIFY - GENERATED BY " + clazz.getName();
    }
}

