/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.codegen.generator;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.homunculus.codegen.GenProject;
import org.homunculus.codegen.Generator;
import org.homunculus.codegen.parse.Annotation;
import org.homunculus.codegen.parse.Field;
import org.homunculus.codegen.parse.FullQualifiedName;
import org.homunculus.codegen.parse.Resolver;
import org.homunculusframework.factory.flavor.hcf.Bind;
import org.homunculusframework.factory.flavor.hcf.ViewComponent;

public class PreprocessDiscoverBeans
implements Generator {
    @Override
    public void generate(GenProject project) throws Exception {
        this.discover(project);
    }

    private boolean isAcceptableBean(Resolver resolver, FullQualifiedName fqn) {
        return resolver.isTopLevelType(fqn) || resolver.isStatic(fqn) && !resolver.isAbstract(fqn) && !resolver.isPrivate(fqn);
    }

    private Map<DiscoveryKind, Set<FullQualifiedName>> discover(GenProject project) throws ClassNotFoundException {
        Map<DiscoveryKind, Set<FullQualifiedName>> discoveryKinds = project.getDiscoveredKinds();
        for (DiscoveryKind kind : DiscoveryKind.values()) {
            discoveryKinds.put(kind, new HashSet());
        }
        Resolver resolver = project.getResolver();
        block1: for (FullQualifiedName bean : resolver.getTypes()) {
            DiscoveryKind[] superTypeKinds;
            DiscoveryKind[] annotationKinds;
            if (!this.isAcceptableBean(resolver, bean)) continue;
            List<Annotation> typeAnnotations = resolver.getAnnotations(bean);
            for (DiscoveryKind kind : annotationKinds = new DiscoveryKind[]{DiscoveryKind.SINGLETON, DiscoveryKind.BEAN, DiscoveryKind.BIND}) {
                for (Annotation annotation : typeAnnotations) {
                    if (!kind.match(annotation.getFullQualifiedName().toString())) continue;
                    discoveryKinds.get((Object)kind).add(bean);
                    if (kind != DiscoveryKind.SINGLETON) continue block1;
                    discoveryKinds.get((Object)DiscoveryKind.BEAN).add(bean);
                    continue block1;
                }
                for (Field field : resolver.getFields(bean)) {
                    for (Annotation annotation : field.getAnnotations()) {
                        if (!kind.match(annotation.getFullQualifiedName().toString())) continue;
                        discoveryKinds.get((Object)kind).add(bean);
                    }
                }
            }
            for (DiscoveryKind kind : superTypeKinds = new DiscoveryKind[]{DiscoveryKind.APPLICATION, DiscoveryKind.ACTIVITY}) {
                for (String fqn : kind.fullQualifiedNames) {
                    if (!resolver.isInstanceOf(bean, new FullQualifiedName(fqn))) continue;
                    discoveryKinds.get((Object)kind).add(bean);
                    continue block1;
                }
            }
        }
        return discoveryKinds;
    }

    public static enum DiscoveryKind {
        SINGLETON("org.springframework.stereotype.Controller", "org.springframework.stereotype.Service", "javax.inject.Singleton"),
        BEAN("javax.inject.Inject", "org.springframework.beans.factory.annotation.Autowired", ViewComponent.class.getName()),
        BIND(Bind.class.getName()),
        APPLICATION("org.homunculus.android.component.HomunculusApplication", "android.app.Application"),
        ACTIVITY("org.homunculus.android.component.HomunculusActivity", "android.app.Activity");

        private String[] fullQualifiedNames;

        private DiscoveryKind(String ... args) {
            this.fullQualifiedNames = args;
        }

        public boolean match(String name) {
            for (String n : this.fullQualifiedNames) {
                if (!n.equals(name)) continue;
                return true;
            }
            return false;
        }
    }
}

