/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.codegen.gradle;

import com.android.build.gradle.internal.plugins.AppPlugin;
import java.io.File;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.homunculus.codegen.gradle.GenTask;
import org.slf4j.LoggerFactory;

public class HCFGenPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        File hcfDir = new File(project.getBuildDir(), "/generated/source/hcf/src/main/java");
        if (!hcfDir.mkdirs() && !hcfDir.isDirectory()) {
            throw new RuntimeException("failed to create directory " + hcfDir);
        }
        AppPlugin appPlugin = null;
        for (Plugin plugin : project.getPlugins()) {
            System.out.println(plugin.getClass() + "(" + plugin + ")");
            if (!(plugin instanceof AppPlugin)) continue;
            appPlugin = (AppPlugin)plugin;
        }
        if (appPlugin == null) {
            throw new RuntimeException("no android AppPlugin found");
        }
        appPlugin.getVariantInputModel().getDefaultConfigData().getSourceSet().getJava().srcDir((Object)hcfDir);
        LoggerFactory.getLogger((String)"TEST").info(hcfDir.toString());
        this.createAndroidTasks(project, hcfDir);
    }

    private void createAndroidTasks(Project project, File hcfDir) {
        project.getTasks().create("genHCF", GenTask.class);
        project.getTasks().getByName("preBuild").dependsOn(new Object[]{"genHCF"});
    }
}

