/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.codegen.parse.javaparser;

import com.github.javaparser.Range;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import java.util.ArrayList;
import java.util.List;
import org.homunculus.codegen.generator.LintException;
import org.homunculus.codegen.parse.Annotation;
import org.homunculus.codegen.parse.Constructor;
import org.homunculus.codegen.parse.FullQualifiedName;
import org.homunculus.codegen.parse.Parameter;
import org.homunculus.codegen.parse.javaparser.JPAnnotation;
import org.homunculus.codegen.parse.javaparser.JPParameter;
import org.homunculus.codegen.parse.javaparser.TypeContext;

public class JPConstructor
implements Constructor {
    private final ConstructorDeclaration methodDeclaration;
    private final TypeContext ctx;
    private final FullQualifiedName declaringType;

    public JPConstructor(TypeContext ctx, FullQualifiedName declaringType, ConstructorDeclaration methodDeclaration) {
        this.methodDeclaration = methodDeclaration;
        this.ctx = ctx;
        this.declaringType = declaringType;
    }

    @Override
    public boolean isPrivate() {
        return this.methodDeclaration.isPrivate();
    }

    @Override
    public boolean isPublic() {
        return this.methodDeclaration.isPublic();
    }

    @Override
    public boolean isAbstract() {
        return this.methodDeclaration.isAbstract();
    }

    @Override
    public boolean isProtected() {
        return this.methodDeclaration.isProtected();
    }

    @Override
    public boolean isStatic() {
        return this.methodDeclaration.isStatic();
    }

    @Override
    public String getName() {
        return this.methodDeclaration.getNameAsString();
    }

    @Override
    public List<Annotation> getAnnotations() {
        ArrayList<Annotation> res = new ArrayList<Annotation>();
        for (AnnotationExpr a : this.methodDeclaration.getAnnotations()) {
            res.add(new JPAnnotation(this.ctx, new FullQualifiedName(this.ctx.src.getFullQualifiedName(a.getNameAsString())), a));
        }
        return res;
    }

    @Override
    public LintException newLintException(String msg) {
        return new LintException(msg, this.ctx.src, (Range)this.methodDeclaration.getRange().get());
    }

    @Override
    public List<Parameter> getParameters() {
        ArrayList<Parameter> res = new ArrayList<Parameter>();
        for (com.github.javaparser.ast.body.Parameter p : this.methodDeclaration.getParameters()) {
            res.add(new JPParameter(this.ctx, p));
        }
        return res;
    }

    @Override
    public FullQualifiedName getDeclaringType() {
        return this.declaringType;
    }
}

