/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.codegen.parse.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JMethod;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.homunculus.codegen.parse.Annotation;
import org.homunculus.codegen.parse.Constructor;
import org.homunculus.codegen.parse.Field;
import org.homunculus.codegen.parse.FullQualifiedName;
import org.homunculus.codegen.parse.Method;
import org.homunculus.codegen.parse.Resolver;
import org.homunculus.codegen.parse.jcodemodel.JCodeModelConstructor;

public class JCodeModelResolver
implements Resolver {
    private final JCodeModel code;

    public JCodeModelResolver(JCodeModel code) {
        this.code = code;
    }

    @Override
    public void getSuperTypes(FullQualifiedName name, List<FullQualifiedName> dst) throws ClassNotFoundException {
        AbstractJClass a;
        JDefinedClass jc = this.code._getClass(name.toString());
        if (jc == null) {
            throw new ClassNotFoundException(name.toString());
        }
        Iterator it = jc._implements();
        while (it.hasNext()) {
            a = (AbstractJClass)it.next();
            this.getSuperTypes(new FullQualifiedName(this.stripGenerics(a.fullName())), dst);
        }
        while (jc._extends() != null) {
            a = jc._extends();
            this.getSuperTypes(new FullQualifiedName(this.stripGenerics(a.fullName())), dst);
        }
    }

    public void listTypes(FullQualifiedName src, List<FullQualifiedName> found, List<FullQualifiedName> notFound) {
        AbstractJClass a;
        JDefinedClass jc = this.code._getClass(src.toString());
        if (jc == null) {
            notFound.add(src);
            return;
        }
        found.add(src);
        Iterator it = jc._implements();
        while (it.hasNext()) {
            a = (AbstractJClass)it.next();
            this.listTypes(new FullQualifiedName(this.stripGenerics(a.fullName())), found, notFound);
        }
        if (jc._extends() != null) {
            a = jc._extends();
            this.listTypes(new FullQualifiedName(this.stripGenerics(a.fullName())), found, notFound);
        }
    }

    private String stripGenerics(String text) {
        int idx = text.indexOf(60);
        if (idx > 0) {
            return text.substring(0, idx);
        }
        return text;
    }

    @Override
    public boolean has(FullQualifiedName name) {
        return this.code._getClass(name.toString()) != null;
    }

    @Override
    public List<Constructor> getConstructors(FullQualifiedName name) throws ClassNotFoundException {
        JDefinedClass cl = this.code._getClass(name.toString());
        if (cl == null) {
            throw new ClassNotFoundException(name.toString());
        }
        ArrayList<Constructor> res = new ArrayList<Constructor>();
        Iterator it = cl.constructors();
        while (it.hasNext()) {
            JMethod m = (JMethod)it.next();
            res.add(new JCodeModelConstructor(m));
        }
        return res;
    }

    @Override
    public List<Method> getMethods(FullQualifiedName name) throws ClassNotFoundException {
        return null;
    }

    @Override
    public List<Field> getFields(FullQualifiedName name) throws ClassNotFoundException {
        return null;
    }

    @Override
    public List<FullQualifiedName> getTypes() {
        return null;
    }

    @Override
    public boolean isAbstract(FullQualifiedName name) {
        return false;
    }

    @Override
    public boolean isPublic(FullQualifiedName name) {
        return false;
    }

    @Override
    public boolean isPrivate(FullQualifiedName name) {
        return false;
    }

    @Override
    public boolean isTopLevelType(FullQualifiedName name) {
        return false;
    }

    @Override
    public boolean isStatic(FullQualifiedName name) {
        return false;
    }

    @Override
    public boolean isNested(FullQualifiedName name) {
        return false;
    }

    @Override
    public List<Annotation> getAnnotations(FullQualifiedName name) {
        return null;
    }

    @Override
    public boolean isInstanceOf(FullQualifiedName which, FullQualifiedName what) {
        return false;
    }
}

