/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.com.github.mustachejava;

import java.util.Objects;

public final class TemplateContext {
    private final String sm;
    private final String em;
    private final String file;
    private final int line;
    private final boolean startOfLine;

    public TemplateContext(String sm, String em, String file, int line, boolean startOfLine) {
        this.sm = sm;
        this.em = em;
        this.file = file;
        this.line = line;
        this.startOfLine = startOfLine;
    }

    public boolean startOfLine() {
        return this.startOfLine;
    }

    public String startChars() {
        return this.sm;
    }

    public String endChars() {
        return this.em;
    }

    public String file() {
        return this.file;
    }

    public int line() {
        return this.line;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateContext that = (TemplateContext)o;
        return this.line == that.line && Objects.equals(this.em, that.em) && Objects.equals(this.file, that.file) && Objects.equals(this.sm, that.sm);
    }

    public int hashCode() {
        int result = this.sm != null ? this.sm.hashCode() : 0;
        result = 31 * result + (this.em != null ? this.em.hashCode() : 0);
        result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
        result = 31 * result + this.line;
        return result;
    }

    public String toString() {
        return "[" + this.file + ":" + this.line + "]";
    }
}

