/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.com.jcabi.log;

import io.honeybadger.com.jcabi.log.Colors;
import io.honeybadger.com.jcabi.log.ControlSequenceIndicatorFormatted;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ConversionPattern {
    private static final Pattern METAS = Pattern.compile("%color(?:-([a-z]+|[0-9]{1,3};[0-9]{1,3};[0-9]{1,3}))?\\{");
    private final transient String pattern;
    private final transient Colors colors;

    ConversionPattern(String pat, Colors col) {
        this.pattern = pat;
        this.colors = col;
    }

    public String generate() {
        int argstart;
        int argend;
        String remaining = this.pattern;
        Matcher matcher = METAS.matcher(remaining);
        StringBuffer buf = new StringBuffer(0);
        while (matcher.find() && (argend = ConversionPattern.findArgumentEnd(remaining, argstart = matcher.end())) >= 0) {
            matcher.appendReplacement(buf, "");
            buf.append(ConversionPattern.csi()).append(this.colors.ansi(matcher.group(1))).append('m').append(remaining, argstart, argend).append(ConversionPattern.csi()).append('m');
            remaining = remaining.substring(argend + 1);
            matcher.reset(remaining);
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    private static int findArgumentEnd(String pattern, int start) {
        int index;
        int count = 1;
        for (index = start; index < pattern.length(); ++index) {
            char character = pattern.charAt(index);
            if (character == '}') {
                if (--count != 0) continue;
                break;
            }
            if (character != '{') continue;
            ++count;
        }
        if (index == pattern.length()) {
            index = -1;
        }
        return index;
    }

    private static String csi() {
        return new ControlSequenceIndicatorFormatted("%s").format();
    }
}

