/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.com.jcabi.log;

import io.honeybadger.com.jcabi.log.DecorException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Formattable;
import java.util.Formatter;

final class ListDecor
implements Formattable {
    private final transient Collection<?> list;

    ListDecor(Object obj) throws DecorException {
        if (obj == null || obj instanceof Collection) {
            this.list = (Collection)Collection.class.cast(obj);
        } else if (obj instanceof Object[]) {
            this.list = Arrays.asList((Object[])obj);
        } else {
            throw new DecorException(String.format("Collection or array required, while %s provided", obj.getClass().getName()), new Object[0]);
        }
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        StringBuilder builder = new StringBuilder(0);
        builder.append('[');
        if (this.list == null) {
            builder.append("NULL");
        } else {
            boolean first = true;
            for (Object item : this.list) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append(String.format("\"%s\"", item));
                first = false;
            }
        }
        builder.append(']');
        formatter.format("%s", builder.toString());
    }
}

