/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.com.jcabi.log;

import io.honeybadger.com.jcabi.log.PreFormatter;
import io.honeybadger.com.jcabi.log.SupplierLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.logging.Level;
import org.slf4j.LoggerFactory;

public final class Logger {
    private static final Object[] EMPTY = new Object[0];
    private static final String UTF_8 = "UTF-8";

    private Logger() {
    }

    public static String format(String fmt, Object ... args) {
        String result;
        if (args.length == 0) {
            result = fmt;
        } else {
            PreFormatter pre = new PreFormatter(fmt, args);
            result = String.format(pre.getFormat(), pre.getArguments());
        }
        return result;
    }

    public static void trace(Object source, String msg) {
        Logger.trace(source, msg, EMPTY);
    }

    public static void trace(Object source, String msg, Object ... args) {
        if (Logger.isTraceEnabled(source)) {
            Logger.traceForced(source, msg, args);
        }
    }

    public static void traceForced(Object source, String msg, Object ... args) {
        Logger.logger(source).trace(Logger.format(msg, args));
    }

    public static void debug(Object source, String msg) {
        Logger.debug(source, msg, EMPTY);
    }

    public static void debug(Object source, String msg, Object ... args) {
        if (Logger.isDebugEnabled(source)) {
            Logger.debugForced(source, msg, args);
        }
    }

    public static void debugForced(Object source, String msg, Object ... args) {
        Logger.logger(source).debug(Logger.format(msg, args));
    }

    public static void info(Object source, String msg) {
        Logger.info(source, msg, EMPTY);
    }

    public static void info(Object source, String msg, Object ... args) {
        if (Logger.isInfoEnabled(source)) {
            Logger.infoForced(source, msg, args);
        }
    }

    public static void infoForced(Object source, String msg, Object ... args) {
        Logger.logger(source).info(Logger.format(msg, args));
    }

    public static void warn(Object source, String msg) {
        Logger.warn(source, msg, EMPTY);
    }

    public static void warn(Object source, String msg, Object ... args) {
        if (Logger.isWarnEnabled(source)) {
            Logger.warnForced(source, msg, args);
        }
    }

    public static void warnForced(Object source, String msg, Object ... args) {
        Logger.logger(source).warn(Logger.format(msg, args));
    }

    public static void error(Object source, String msg) {
        Logger.error(source, msg, EMPTY);
    }

    public static void error(Object source, String msg, Object ... args) {
        Logger.logger(source).error(Logger.format(msg, args));
    }

    public static boolean isTraceEnabled(Object source) {
        return Logger.logger(source).isTraceEnabled();
    }

    public static boolean isDebugEnabled(Object source) {
        return Logger.logger(source).isDebugEnabled();
    }

    public static boolean isInfoEnabled(Object source) {
        return Logger.logger(source).isInfoEnabled();
    }

    public static boolean isWarnEnabled(Object source) {
        return Logger.logger(source).isWarnEnabled();
    }

    public static boolean isEnabled(Level level, Object source) {
        boolean enabled = false;
        if (level.equals(Level.SEVERE)) {
            enabled = Logger.logger(source).isErrorEnabled();
        } else if (level.equals(Level.WARNING)) {
            enabled = Logger.logger(source).isWarnEnabled();
        } else if (level.equals(Level.INFO) || level.equals(Level.CONFIG)) {
            enabled = Logger.logger(source).isInfoEnabled();
        } else if (level.equals(Level.FINE) || level.equals(Level.ALL)) {
            enabled = Logger.logger(source).isDebugEnabled();
        } else if (level.equals(Level.FINER) || level.equals(Level.FINEST)) {
            enabled = Logger.logger(source).isTraceEnabled();
        }
        return enabled;
    }

    public static void log(Level level, Object source, String msg, Object ... args) {
        if (level.equals(Level.SEVERE)) {
            Logger.error(source, msg, args);
        } else if (level.equals(Level.WARNING)) {
            Logger.warn(source, msg, args);
        } else if (level.equals(Level.INFO) || level.equals(Level.CONFIG)) {
            Logger.info(source, msg, args);
        } else if (level.equals(Level.FINE) || level.equals(Level.ALL)) {
            Logger.debug(source, msg, args);
        } else if (level.equals(Level.FINER) || level.equals(Level.FINEST)) {
            Logger.trace(source, msg, args);
        }
    }

    public static OutputStream stream(final Level level, final Object source) {
        return new OutputStream(){
            private final transient ByteArrayOutputStream buffer = new ByteArrayOutputStream();

            @Override
            public void write(int data) throws IOException {
                if (data == 10) {
                    Logger.log(level, source, this.buffer.toString(Logger.UTF_8), new Object[0]);
                    this.buffer.reset();
                } else if (data >= 32 && data <= 127) {
                    this.buffer.write(data);
                } else {
                    this.buffer.write(String.format("\\x%02x", data & 0xFF).getBytes(Logger.UTF_8));
                }
            }
        };
    }

    public static SupplierLogger withSupplier() {
        return new SupplierLogger();
    }

    private static void setFinalStatic(Field field, Object value) throws NoSuchFieldException, IllegalAccessException {
        field.setAccessible(true);
        Field modifiers = Field.class.getDeclaredField("modifiers");
        modifiers.setAccessible(true);
        modifiers.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(null, value);
    }

    private static org.slf4j.Logger logger(Object source) {
        org.slf4j.Logger logger = source instanceof Class ? LoggerFactory.getLogger((Class)((Class)source)) : (source instanceof String ? LoggerFactory.getLogger((String)((String)String.class.cast(source))) : LoggerFactory.getLogger(source.getClass()));
        if ("org.slf4j.impl.Log4jLoggerAdapter".equals(logger.getClass().getName())) {
            try {
                Field fqcn = logger.getClass().getDeclaredField("FQCN");
                Logger.setFinalStatic(fqcn, Logger.class.getName());
            }
            catch (NoSuchFieldException ex) {
                throw new IllegalStateException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return logger;
    }
}

