/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.com.jcabi.log;

import java.lang.reflect.Field;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Formattable;
import java.util.Formatter;

final class ObjectDecor
implements Formattable {
    private final transient Object object;

    ObjectDecor(Object obj) {
        this.object = obj;
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        if (this.object == null) {
            formatter.format("NULL", new Object[0]);
        } else if (this.object.getClass().isArray()) {
            formatter.format(new ArrayFormatAction((Object[])this.object).run(), new Object[0]);
        } else {
            String output = new ObjectContentsFormatAction(this.object).run();
            formatter.format(output, new Object[0]);
        }
    }

    private static final class ObjectContentsFormatAction
    implements PrivilegedAction<String> {
        private final transient Object object;

        ObjectContentsFormatAction(Object obj) {
            this.object = obj;
        }

        @Override
        public String run() {
            StringBuilder builder = new StringBuilder("{");
            for (Field field : this.object.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    builder.append(String.format("%s: \"%s\"", field.getName(), field.get(this.object)));
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException(ex);
                }
                builder.append(", ");
            }
            builder.replace(builder.length() - 2, builder.length(), "}");
            return builder.toString();
        }
    }

    private static final class ArrayFormatAction
    implements PrivilegedAction<String> {
        private final transient Object[] array;

        ArrayFormatAction(Object ... arr) {
            this.array = Arrays.copyOf(arr, arr.length);
        }

        @Override
        public String run() {
            StringBuilder builder = new StringBuilder("[");
            Formatter formatter = new Formatter(builder);
            for (Object obj : this.array) {
                new ObjectDecor(obj).formatTo(formatter, 0, 0, 0);
                builder.append(", ");
            }
            builder.replace(builder.length() - 2, builder.length(), "]");
            return builder.toString();
        }
    }
}

