/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.com.jcabi.log;

import java.util.Formattable;
import java.util.Formatter;

final class SecretDecor
implements Formattable {
    private final transient String secret;

    SecretDecor(Object scrt) {
        this.secret = scrt == null ? null : scrt.toString();
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        if (this.secret == null) {
            formatter.format("NULL", new Object[0]);
        } else {
            StringBuilder fmt = new StringBuilder(10);
            fmt.append('%');
            if ((flags & 1) != 0) {
                fmt.append('-');
            }
            if (width != 0) {
                fmt.append(width);
            }
            if ((flags & 2) == 0) {
                fmt.append('s');
            } else {
                fmt.append('S');
            }
            formatter.format(fmt.toString(), SecretDecor.scramble(this.secret));
        }
    }

    private static String scramble(String text) {
        StringBuilder out = new StringBuilder(10);
        if (text.isEmpty()) {
            out.append('?');
        } else {
            out.append(text.charAt(0));
        }
        out.append("***");
        if (text.isEmpty()) {
            out.append('?');
        } else {
            out.append(text.charAt(text.length() - 1));
        }
        return out.toString();
    }
}

