/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.com.jcabi.log;

import io.honeybadger.com.jcabi.log.Logger;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public final class VerboseCallable<T>
implements Callable<T> {
    private final transient Callable<T> origin;
    private final transient boolean rethrow;
    private final transient boolean verbose;

    public VerboseCallable(Callable<T> callable) {
        this(callable, false);
    }

    public VerboseCallable(Callable<T> callable, boolean swallow) {
        this(callable, swallow, true);
    }

    public VerboseCallable(final Runnable runnable, boolean swallow, boolean vrbs) {
        this(new Callable<T>(){

            @Override
            public T call() throws Exception {
                runnable.run();
                return null;
            }

            public String toString() {
                return runnable.toString();
            }
        }, swallow, vrbs);
    }

    public VerboseCallable(Runnable runnable, boolean swallow) {
        this(runnable, swallow, true);
    }

    public VerboseCallable(Callable<T> callable, boolean swallow, boolean vrbs) {
        this.origin = callable;
        this.rethrow = !swallow;
        this.verbose = vrbs;
    }

    public String toString() {
        return this.origin.toString();
    }

    @Override
    public T call() throws Exception {
        T result = null;
        try {
            result = this.origin.call();
        }
        catch (RuntimeException ex) {
            if (this.rethrow) {
                Logger.warn(this, "escalated runtime exception: %s", this.tail(ex));
                throw ex;
            }
            Logger.warn(this, "swallowed runtime exception: %s", this.tail(ex));
        }
        catch (Exception ex) {
            if (this.rethrow) {
                Logger.warn(this, "escalated exception: %s", this.tail(ex));
                throw ex;
            }
            Logger.warn(this, "swallowed exception: %s", this.tail(ex));
        }
        catch (Error error) {
            if (this.rethrow) {
                Logger.error(this, "escalated error: %s", this.tail(error));
                throw error;
            }
            Logger.error(this, "swallowed error: %s", this.tail(error));
        }
        try {
            TimeUnit.MICROSECONDS.sleep(1L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(ex);
        }
        return result;
    }

    private String tail(Throwable throwable) {
        String tail = this.verbose ? Logger.format("%[exception]s", throwable) : Logger.format("%[type]s('%s')", throwable, throwable.getMessage());
        return tail;
    }
}

